/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.mapper.GuidePriceDetailMapper;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.vo.GuidePriceDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="guidePriceDetailService")
public class GuidePriceDetailServiceImpl
extends BaseServiceImpl<GuidePriceDetailMapper, GuidePriceDetailEntity>
implements IGuidePriceDetailService {
    @Autowired
    private GuidePriceDetailMapper mapper;

    @Override
    public CommonResponse<List<GuidePriceDetailVO>> queryGuidePriceDetailData(List<GuidePriceDetailVO> detailVOList) {
        Map<Long, List<GuidePriceDetailVO>> byCollect = detailVOList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
        List<String> materialIds = Arrays.asList(byCollect.keySet().toArray(new String[0]));
        List<GuidePriceDetailEntity> queryList = this.mapper.queryDetailByMaterialIds(materialIds);
        Map<Long, List<GuidePriceDetailEntity>> queryCollect = queryList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
        for (GuidePriceDetailVO byDetail : detailVOList) {
            List<GuidePriceDetailEntity> guidePriceDetailEntities1;
            List<GuidePriceDetailEntity> guidePriceDetailEntities;
            Map<String, List<GuidePriceDetailEntity>> brandNameMap;
            if (!queryCollect.containsKey(byDetail.getMaterialId()) || !(brandNameMap = (guidePriceDetailEntities = queryCollect.get(byDetail.getMaterialId())).stream().collect(Collectors.groupingBy(e -> e.getBrandName()))).containsKey(byDetail.getBrandName()) || !CollectionUtils.isNotEmpty(guidePriceDetailEntities1 = brandNameMap.get(byDetail.getBrandName()))) continue;
            GuidePriceDetailEntity guidePriceDetailEntity = guidePriceDetailEntities1.get(0);
            byDetail.setPrice(guidePriceDetailEntity.getPrice());
        }
        return CommonResponse.success(detailVOList);
    }
}

