/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectDetail"})
public class BudgetProjectDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectDetailService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> saveOrUpdate(@RequestBody BudgetProjectDetailVO saveorUpdateVO) {
        BudgetProjectDetailEntity entity = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        BudgetProjectDetailVO vo = (BudgetProjectDetailVO)BeanMapper.map((Object)((Object)entity), BudgetProjectDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> queryDetail(Long id) {
        BudgetProjectDetailEntity entity = (BudgetProjectDetailEntity)((Object)this.service.selectById(id));
        BudgetProjectDetailVO vo = (BudgetProjectDetailVO)BeanMapper.map((Object)((Object)entity), BudgetProjectDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-detail-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/detailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailVO>> detailRef(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", this.service.detailRef(projectId));
    }

    @RequestMapping(value={"/downloadHk"})
    @ResponseBody
    public void downloadHk(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"hk-budget-detail-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportHk"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportHk(request, response);
    }
}

