/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailReferenProVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityVO;
import com.ejianc.business.budget.vo.BudgetProjectProVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectProService")
public class BudgetProjectProServiceImpl
extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity>
implements IBudgetProjectProService {
    @Autowired
    private BudgetProjectProMapper budgetProjectProMapper;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
    @Autowired
    private IBudgetProjectProService budgetProService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetProjectHistoryProService historyProService;

    @Override
    public BudgetProjectProVO queryDetail(Long id) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProjectProMapper.selectById(id));
        if (entity != null) {
            BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)vo.getId()));
            List detailProEntityList = this.budgetProjectDetailProService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)detailProEntityList)) {
                List resultMapList = BeanMapper.mapList((Iterable)detailProEntityList, BudgetProjectDetailProVO.class);
                for (BudgetProjectDetailProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                Collections.sort(resultMapList, new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
        if (paramControlVO.getProjectId() == null) {
            return null;
        }
        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectProEntity::getProjectId, (Object)paramControlVO.getProjectId());
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)super.getOne((Wrapper)lambdaQuery));
        if (entity == null) {
            return null;
        }
        quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
        quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
        quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
        quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
        quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
        quantityAndMnyVO.setLaborMny(entity.getLaborMny());
        quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
        quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
        quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
        quantityAndMnyVO.setMajorMny(entity.getMajorMny());
        quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
        quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
        quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
        Map<Long, BudgetProjectDetailProVO> detailProMap = (paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty((Collection)paramControlVO.getIds()) ? this.budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds()) : this.budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
        quantityAndMnyVO.setDetailProMap(detailProMap);
        return quantityAndMnyVO;
    }

    @Override
    public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public void pushCostSetting(Long budgetId) {
        ArrayList<SubjectEntity> subjectAndUpdateList = new ArrayList<SubjectEntity>();
        Map<Object, Object> subjectMap = new HashMap();
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProService.selectById(budgetId));
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"setting_id", (Object)budgetId);
        List subjectEntities = this.subjectService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty((Collection)subjectEntities)) {
                subjectMap = subjectEntities.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                for (BudgetProjectDetailProEntity projectDetailProEntity : detailList) {
                    SubjectEntity subjectEntity = null;
                    if (subjectMap.containsKey(projectDetailProEntity.getId())) {
                        subjectEntity = (SubjectEntity)((Object)subjectMap.get(projectDetailProEntity.getId()));
                        subjectEntity.setParentId(projectDetailProEntity.getParentId());
                        subjectEntity.setVersion(subjectEntity.getVersion());
                    } else {
                        subjectEntity = new SubjectEntity();
                        subjectEntity.setSettingId(budgetId);
                        subjectEntity.setId(projectDetailProEntity.getId());
                        subjectEntity.setVersion(null);
                    }
                    subjectMap.remove(subjectEntity.getId());
                    subjectEntity.setCostType(projectDetailProEntity.getCostType());
                    subjectEntity.setParentId(projectDetailProEntity.getParentId());
                    subjectEntity.setTid(projectDetailProEntity.getId());
                    subjectEntity.setSubjectName(projectDetailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(projectDetailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(projectDetailProEntity.getLeafFlag() == 1);
                    subjectEntity.setDetailIndex(projectDetailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            } else {
                for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                    SubjectEntity subjectEntity = new SubjectEntity();
                    subjectEntity.setSettingId(budgetId);
                    subjectEntity.setCostType(detailProEntity.getCostType());
                    subjectEntity.setId(detailProEntity.getId());
                    subjectEntity.setParentId(detailProEntity.getParentId());
                    subjectEntity.setTid(detailProEntity.getId());
                    subjectEntity.setVersion(null);
                    subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(detailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1);
                    subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            }
            if (!subjectMap.isEmpty()) {
                List ids = subjectMap.keySet().stream().collect(Collectors.toList());
                this.subjectService.removeByIds(ids);
            }
            this.subjectService.saveOrUpdateBatch(subjectAndUpdateList, subjectAndUpdateList.size());
        } else if (CollectionUtils.isNotEmpty((Collection)subjectEntities)) {
            List ids = subjectEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.subjectService.removeByIds(ids);
        }
    }

    @Override
    public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
        return this.budgetProjectProMapper.queryOnlySuject(projectId, costType, subjectIds);
    }

    @Override
    public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
        List<BudgetProjectProQuantityVO> list;
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (projectId != null && CollectionUtils.isNotEmpty(list = this.budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId))) {
            map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
        }
        return map;
    }

    @Override
    public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
        return this.budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
    }

    @Override
    public BudgetProjectVO convertToPro(BudgetProjectVO budgetProjectVO) {
        BudgetProjectVO result = new BudgetProjectVO();
        return result;
    }

    @Override
    public BudgetProjectProVO compareDetail(Long id) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.selectById(id));
        BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
        List detailList = vo.getDetailList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectHistoryProEntity::getBudgetId, (Object)id);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.historyProService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BudgetProjectHistoryProEntity budgetProjectHistoryProEntity = (BudgetProjectHistoryProEntity)((Object)list.get(0));
            BudgetProjectHistoryProEntity budgetProjectHistory = (BudgetProjectHistoryProEntity)((Object)this.historyProService.selectById(budgetProjectHistoryProEntity.getId()));
            BudgetProjectHistoryProVO historyVO = (BudgetProjectHistoryProVO)BeanMapper.map((Object)((Object)budgetProjectHistory), BudgetProjectHistoryProVO.class);
            CompareDifferenceUtil.compareObj((Object)historyVO, (Object)vo);
            CompareDifferenceUtil.compareList((List)historyVO.getDetailList(), (List)vo.getDetailList());
        }
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Collections.sort(detailList, new BudgetDetailProComparatoeVo());
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return vo;
    }

    private boolean isNotEqual(String str1, String str2) {
        if (str1 != null) {
            return !str1.equals(str2);
        }
        if (str2 != null) {
            return !str2.equals(str1);
        }
        return false;
    }

    private Long makeTarget(List<BudgetProjectDetailProEntity> detailList, BudgetProjectVO budgetVO, BudgetProjectProEntity proEntity) {
        if (null == proEntity) {
            proEntity = new BudgetProjectProEntity();
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)budgetVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            proEntity.setBillCode((String)billCode.getData());
            proEntity.setProjectId(budgetVO.getProjectId());
            proEntity.setProjectName(budgetVO.getProjectName());
            proEntity.setOrgId(budgetVO.getOrgId());
            proEntity.setOrgName(budgetVO.getOrgName());
            UserContext userContext = this.sessionManager.getUserContext();
            proEntity.setEmployeeId(userContext.getEmployeeId());
            proEntity.setEmployeeName(userContext.getEmployeeName());
            proEntity.setChangeStatus(1);
            proEntity.setDetailList(detailList);
            this.fullMny(proEntity);
            this.saveOrUpdate((Object)proEntity, false);
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BudgetProjectDetailProEntity::getSourceId, (Object)budgetVO.getId());
            queryWrapper.eq(BudgetProjectDetailProEntity::getBudgetType, (Object)budgetVO.getBudgetType());
            this.budgetProjectDetailProService.remove((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty(detailList)) {
                this.budgetProjectDetailProService.saveBatch(detailList);
            }
            proEntity = (BudgetProjectProEntity)((Object)this.selectById(proEntity.getId()));
            this.fullMny(proEntity);
            this.saveOrUpdate((Object)proEntity);
        }
        return proEntity.getId();
    }

    private void fullMny(BudgetProjectProEntity proEntity) {
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailProEntity detailProEntity : proEntity.getDetailList()) {
                if (null != detailProEntity.getParentId()) continue;
                budgetTaxMny = ComputeUtil.safeAdd((BigDecimal)budgetTaxMny, (BigDecimal)detailProEntity.getTaxMny());
                laborTaxMny = ComputeUtil.safeAdd((BigDecimal)laborTaxMny, (BigDecimal)detailProEntity.getLaborTaxMnyCost());
                materialTaxMny = ComputeUtil.safeAdd((BigDecimal)materialTaxMny, (BigDecimal)detailProEntity.getMaterialTaxMnyCost());
            }
        }
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }
}

