/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.mapper.GuidePriceDetailMapper;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.service.IGuidePriceService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="guidePriceDetailService")
public class GuidePriceDetailServiceImpl
extends BaseServiceImpl<GuidePriceDetailMapper, GuidePriceDetailEntity>
implements IGuidePriceDetailService {
    @Autowired
    private IGuidePriceService guidePriceService;

    @Override
    public Map<String, BigDecimal> queryGuidePriceDetailData() {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.in(GuidePriceEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        query.eq(GuidePriceEntity::getStatus, (Object)1);
        query.orderByDesc(GuidePriceEntity::getReleaseDate);
        query.last("limit 1");
        List list = this.guidePriceService.list((Wrapper)query);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            LambdaQueryWrapper detailQuery = Wrappers.lambdaQuery();
            detailQuery.eq(GuidePriceDetailEntity::getReviewId, (Object)((GuidePriceEntity)((Object)list.get(0))).getId());
            List detailEntityList = this.list((Wrapper)detailQuery);
            if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                for (GuidePriceDetailEntity entity : detailEntityList) {
                    map.put(entity.getMaterialId() + entity.getBrandId(), entity.getPrice());
                }
            }
        }
        return map;
    }
}

