/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectDetail"})
public class BudgetProjectDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectDetailService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> saveOrUpdate(@RequestBody BudgetProjectDetailVO saveorUpdateVO) {
        BudgetProjectDetailEntity entity = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        BudgetProjectDetailVO vo = (BudgetProjectDetailVO)BeanMapper.map((Object)((Object)entity), BudgetProjectDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectDetailVO> queryDetail(Long id) {
        BudgetProjectDetailEntity entity = (BudgetProjectDetailEntity)((Object)this.service.selectById(id));
        BudgetProjectDetailVO vo = (BudgetProjectDetailVO)BeanMapper.map((Object)((Object)entity), BudgetProjectDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-detail-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/detailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailVO>> detailRef(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", this.service.detailRef(projectId));
    }

    @RequestMapping(value={"/downloadHk"})
    @ResponseBody
    public void downloadHk(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"hk-budget-detail-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportHk"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportHk(request, response);
    }

    @RequestMapping(value={"/queryMatchList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetMatchVO>> queryMatchList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("detailCode");
        fuzzyFields.add("detailName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter budgetIdParm = (Parameter)param.getParams().get("budgetId");
        Parameter setDetailIdParm = (Parameter)param.getParams().get("setDetailId");
        if (null == budgetIdParm && null == setDetailIdParm) {
            throw new BusinessException("\u9884\u7b97\u4e66Id\u548c\u8bbe\u7f6e\u5b50\u8868Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        Long budgetId = null != budgetIdParm ? Long.valueOf((String)budgetIdParm.getValue()) : null;
        Long setDetailId = null != setDetailIdParm ? Long.valueOf((String)setDetailIdParm.getValue()) : null;
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BudgetMatchVO> list = this.service.queryMatchList((Page<BudgetMatchVO>)page, wrapper, budgetId, setDetailId);
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySimilar"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BudgetSetDetailVO>> querySimilar(Long budgetDetailId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u76f8\u4f3c\u6e05\u5355\u5217\u8868\u6210\u529f\uff01", this.service.querySimilar(budgetDetailId));
    }

    @RequestMapping(value={"/saveSimilarResult"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> saveSimilarResult(Long budgetDetailId, Long setDetailId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)budgetDetailId);
        updateWrapper.set(BudgetProjectDetailEntity::getSetDetailId, (Object)setDetailId);
        updateWrapper.set(BudgetProjectDetailEntity::getResultState, (Object)ConvertResultEnum.\u5df2\u66ff\u6362.getCode());
        updateWrapper.set(BudgetProjectDetailEntity::getMatchTime, (Object)new Date());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fdd\u5b58\u76f8\u4f3c\u6e05\u5355\u5339\u914d\u6210\u529f!");
    }

    @RequestMapping(value={"/updateIgnoreState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateIgnoreState(Long budgetDetailId, Boolean ignoreFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)budgetDetailId);
        updateWrapper.set(BudgetProjectDetailEntity::getResultState, (Object)(ignoreFlag != false ? ConvertResultEnum.\u5df2\u5ffd\u7565.getCode() : ConvertResultEnum.\u65e0\u76f8\u4f3c\u6e05\u5355.getCode()));
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fdd\u5b58\u76f8\u4f3c\u6e05\u5355\u5339\u914d\u6210\u529f!");
    }

    @RequestMapping(value={"/queryNumInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryNumInfo(Long budgetId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectDetailEntity::getBudgetId, (Object)budgetId);
        queryWrapper.eq(BudgetProjectDetailEntity::getLeafFlag, (Object)1);
        List detailEntities = this.service.list((Wrapper)queryWrapper);
        int matchNum = 0;
        int noMatchNum = 0;
        for (BudgetProjectDetailEntity detailEntity : detailEntities) {
            if (ConvertResultEnum.\u5df2\u5339\u914d.getCode().equals(detailEntity.getResultState()) || ConvertResultEnum.\u5df2\u66ff\u6362.getCode().equals(detailEntity.getResultState())) {
                ++matchNum;
                continue;
            }
            if (ConvertResultEnum.\u5df2\u5ffd\u7565.getCode().equals(detailEntity.getResultState())) continue;
            ++noMatchNum;
        }
        int count = Math.toIntExact(detailEntities.stream().filter(x -> ConvertResultEnum.\u5df2\u5339\u914d.getCode().equals(x.getResultState()) || ConvertResultEnum.\u5df2\u66ff\u6362.getCode().equals(x.getResultState())).count());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalNum", (Object)detailEntities.size());
        jsonObject.put("matchNum", (Object)matchNum);
        jsonObject.put("noMatchNum", (Object)noMatchNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u6761\u6570\u4fe1\u606f\u6210\u529f!", (Object)jsonObject);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<BudgetMatchVO>> commonResponse = this.queryMatchList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = ((IPage)commonResponse.getData()).getRecords();
        records.forEach(vo -> vo.setResultStateName(ConvertResultEnum.getEnumByCode(vo.getResultState()).getDescription()));
        beans.put("records", records);
        ExcelExport.getInstance().export("Match-export.xlsx", beans, response);
    }
}

