/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.mapper.QuotaDetailMapper;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.vo.QuotaDetailVO;
import com.ejianc.business.budget.vo.QuotaImportVO;
import com.ejianc.business.budget.vo.QuotaMatVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="quotaDetailService")
public class QuotaDetailServiceImpl
extends BaseServiceImpl<QuotaDetailMapper, QuotaDetailEntity>
implements IQuotaDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public CommonResponse<JSONObject> execlImport(HttpServletRequest request) {
        Long quotaId = Long.valueOf(request.getParameter("quotaId"));
        Long quotaTypeId = Long.valueOf(request.getParameter("quotaTypeId"));
        this.logger.info("\u5f00\u59cb\u5bfc\u5165--" + quotaId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<QuotaImportVO> allSuccessList = new ArrayList<QuotaImportVO>();
        ArrayList<QuotaImportVO> successList = new ArrayList<QuotaImportVO>();
        ArrayList<QuotaImportVO> errorList = new ArrayList<QuotaImportVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(5)))) continue;
                materialCodeList.add(datas.get(5));
            }
            if (CollectionUtils.isNotEmpty(materialCodeList)) {
                CommonResponse materialRes = this.materialApi.queryMaterialsByCodes(materialCodeList);
                if (!materialRes.isSuccess()) {
                    return CommonResponse.error((String)materialRes.getMsg());
                }
                this.logger.info("\u6750\u6599\u4fe1\u606f--" + JSONObject.toJSONString((Object)materialRes.getData()));
                map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (oldValue, newValue) -> newValue));
                this.logger.info("\u6750\u6599map\u4fe1\u606f--" + JSONObject.toJSONString(map));
            }
            Long lastDetailId = null;
            for (int i = 1; i < result.size(); ++i) {
                StringBuffer errMsg = new StringBuffer();
                boolean errflag = false;
                List datas = (List)result.get(i);
                QuotaImportVO importVO = new QuotaImportVO();
                importVO.setMatFlag(Boolean.valueOf(false));
                importVO.setId(Long.valueOf(IdWorker.getId()));
                importVO.setQuotaId(quotaId);
                importVO.setQuotaTypeId(quotaTypeId);
                String quotaDetailCode = (String)datas.get(0);
                if (StringUtils.isEmpty((CharSequence)quotaDetailCode)) {
                    if (lastDetailId == null) {
                        errMsg.append("\u5b9a\u989d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setMatFlag(Boolean.valueOf(true));
                    }
                } else {
                    importVO.setDetailCode(quotaDetailCode);
                }
                if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                    String detailName = (String)datas.get(1);
                    if (StringUtils.isEmpty((CharSequence)detailName)) {
                        errMsg.append("\u5b9a\u989d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setDetailName(detailName);
                    }
                    String description = (String)datas.get(2);
                    if (StringUtils.isEmpty((CharSequence)description)) {
                        errMsg.append("\u7279\u5f81\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        importVO.setDescription(description);
                    }
                    importVO.setDetailUnit((String)datas.get(3));
                    String laborPrice = (String)datas.get(4);
                    if (StringUtils.isEmpty((CharSequence)laborPrice)) {
                        errMsg.append("\u52b3\u52a1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a,");
                        errflag = true;
                    } else {
                        try {
                            importVO.setLaborPrice(StringUtils.isNotBlank((CharSequence)laborPrice) ? new BigDecimal(laborPrice) : null);
                        }
                        catch (Exception e) {
                            errMsg.append("\u52b3\u52a1\u5355\u4ef7\u683c\u5f0f\u9519\u8bef,");
                            errflag = true;
                        }
                    }
                }
                QuotaImportVO importMatVO = null;
                String materialCode = (String)datas.get(5);
                if (BooleanUtils.isTrue((Boolean)importVO.getMatFlag()) && StringUtils.isBlank((CharSequence)materialCode)) {
                    errMsg.append("\u6750\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,");
                    errflag = true;
                } else if (StringUtils.isNotBlank((CharSequence)materialCode)) {
                    String convertRate;
                    String lossRate;
                    MaterialVO materialVO = (MaterialVO)map.get(materialCode);
                    if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                        importMatVO = new QuotaImportVO();
                        importMatVO.setMatFlag(Boolean.valueOf(true));
                        importMatVO.setId(Long.valueOf(IdWorker.getId()));
                        importMatVO.setQuotaId(quotaId);
                        importMatVO.setQuotaTypeId(quotaTypeId);
                        if (materialVO != null) {
                            importMatVO.setQuotaDetailId(importVO.getId());
                            importMatVO.setMaterialId(materialVO.getId());
                            importMatVO.setMaterialCode(materialVO.getCode());
                            importMatVO.setMaterialName(materialVO.getName());
                            importMatVO.setMaterialUnit(materialVO.getUnitName());
                            importMatVO.setMaterialSpec(materialVO.getSpec());
                            importMatVO.setCategoryId(materialVO.getCategoryId());
                            importMatVO.setCategoryName(materialVO.getCategoryName());
                        } else {
                            errMsg.append("\u6750\u6599\u7f16\u7801\u672a\u5339\u914d\u5230\u7269\u6599,");
                            errflag = true;
                        }
                        try {
                            lossRate = (String)datas.get(8);
                            importMatVO.setLossRate(StringUtils.isNotBlank((CharSequence)lossRate) ? new BigDecimal(lossRate) : null);
                        }
                        catch (Exception e) {
                            errMsg.append("\u4e3b\u6750\u8017\u635f\u7387\u683c\u5f0f\u9519\u8bef,");
                            errflag = true;
                        }
                        try {
                            convertRate = (String)datas.get(10);
                            importMatVO.setConvertRate(StringUtils.isNotBlank((CharSequence)convertRate) ? new BigDecimal(convertRate) : null);
                        }
                        catch (Exception e) {
                            errMsg.append("\u6362\u7b97\u7387\u683c\u5f0f\u9519\u8bef,");
                            errflag = true;
                        }
                    } else if (materialVO != null) {
                        importVO.setQuotaDetailId(lastDetailId);
                        importVO.setMaterialId(materialVO.getId());
                        importVO.setMaterialCode(materialVO.getCode());
                        importVO.setMaterialName(materialVO.getName());
                        importVO.setMaterialUnit(materialVO.getUnitName());
                        importVO.setMaterialSpec(materialVO.getSpec());
                        importVO.setCategoryId(materialVO.getCategoryId());
                        importVO.setCategoryName(materialVO.getCategoryName());
                    } else {
                        errMsg.append("\u6750\u6599\u7f16\u7801\u672a\u5339\u914d\u5230\u7269\u6599,");
                        errflag = true;
                    }
                    try {
                        lossRate = (String)datas.get(8);
                        importVO.setLossRate(StringUtils.isNotBlank((CharSequence)lossRate) ? new BigDecimal(lossRate) : null);
                    }
                    catch (Exception e) {
                        errMsg.append("\u4e3b\u6750\u8017\u635f\u7387\u683c\u5f0f\u9519\u8bef,");
                        errflag = true;
                    }
                    try {
                        convertRate = (String)datas.get(10);
                        importVO.setConvertRate(StringUtils.isNotBlank((CharSequence)convertRate) ? new BigDecimal(convertRate) : null);
                    }
                    catch (Exception e) {
                        errMsg.append("\u6362\u7b97\u7387\u683c\u5f0f\u9519\u8bef,");
                        errflag = true;
                    }
                }
                if (errflag) {
                    importVO.setErrorMsg(errMsg.substring(0, errMsg.length() - 1));
                    errorList.add(importVO);
                    continue;
                }
                successList.add(importVO);
                allSuccessList.add(importVO);
                if (null != importMatVO) {
                    allSuccessList.add(importMatVO);
                }
                if (!BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) continue;
                lastDetailId = importVO.getId();
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        if (CollectionUtils.isEmpty(errorList)) {
            ArrayList<QuotaDetailVO> detailVOS = new ArrayList<QuotaDetailVO>();
            ArrayList<QuotaMatVO> matVOS = new ArrayList<QuotaMatVO>();
            HashMap matNameMap = new HashMap();
            for (QuotaImportVO importVO : allSuccessList) {
                if (BooleanUtils.isFalse((Boolean)importVO.getMatFlag())) {
                    QuotaDetailVO detailVO = (QuotaDetailVO)BeanMapper.map((Object)importVO, QuotaDetailVO.class);
                    detailVOS.add(detailVO);
                    continue;
                }
                QuotaMatVO matVO = (QuotaMatVO)BeanMapper.map((Object)importVO, QuotaMatVO.class);
                matVOS.add(matVO);
                ArrayList<String> matStrList = matNameMap.containsKey(matVO.getQuotaDetailId()) ? (List)matNameMap.get(matVO.getQuotaDetailId()) : new ArrayList<String>();
                matStrList.add(matVO.getMaterialName());
                matNameMap.put(matVO.getQuotaDetailId(), matStrList);
            }
            for (QuotaDetailVO detailVO : detailVOS) {
                if (!matNameMap.containsKey(detailVO.getId())) continue;
                List stringList = (List)matNameMap.get(detailVO.getId());
                detailVO.setMatName(StringUtils.join((Iterable)stringList, (String)","));
            }
            List resList = BeanMapper.mapList(detailVOS, QuotaDetailEntity.class);
            this.saveBatch(resList);
            List matEntities = BeanMapper.mapList(matVOS, QuotaMatEntity.class);
            this.quotaMatService.saveBatch(matEntities);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01", (Object)json);
    }
}

