/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.mapper.QuotaMapper;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.vo.QuotaTypeVO;
import com.ejianc.business.budget.vo.QuotaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="quotaService")
public class QuotaServiceImpl
extends BaseServiceImpl<QuotaMapper, QuotaEntity>
implements IQuotaService {
    private static final String BILL_CODE = "BUDGET_QUOTA";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public QuotaVO saveOrUpdate(QuotaVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getEnableState()) {
            saveOrUpdateVO.setEnableState(Integer.valueOf(0));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaEntity::getName, (Object)StringUtils.trim((String)saveOrUpdateVO.getName()));
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540d\u79f0\u91cd\u590d,\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        QuotaEntity entity = (QuotaEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, QuotaEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u7f16\u7801\u751f\u6210\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
        }
        this.saveOrUpdate((Object)entity, false);
        QuotaVO vo = (QuotaVO)BeanMapper.map((Object)((Object)entity), QuotaVO.class);
        return vo;
    }

    @Override
    public QuotaVO copySave(QuotaVO quotaVO) {
        Long copyId = quotaVO.getCopyId();
        Long mainId = IdWorker.getId();
        HashMap<Long, Long> typeIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> detailIdMap = new HashMap<Long, Long>();
        QuotaEntity quotaEntity = (QuotaEntity)((Object)this.selectById(copyId));
        quotaVO = (QuotaVO)BeanMapper.map((Object)((Object)quotaEntity), QuotaVO.class);
        quotaVO.setId(mainId);
        quotaVO.setName(quotaVO.getName() + "(\u526f\u672c)");
        quotaVO.setBillState(Integer.valueOf(0));
        quotaVO.setEnableState(Integer.valueOf(0));
        this.clearData((BaseVO)quotaVO);
        for (QuotaTypeVO typeVO : quotaVO.getTypeList()) {
            Long id = IdWorker.getId();
            typeIdMap.put(typeVO.getId(), id);
            typeVO.setId(id);
            typeVO.setQuotaId(mainId);
            this.clearData((BaseVO)typeVO);
        }
        this.saveOrUpdate(quotaVO);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QuotaDetailEntity::getQuotaId, (Object)copyId);
        List detailEntities = this.quotaDetailService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            for (QuotaDetailEntity detailEntity : detailEntities) {
                Long id = IdWorker.getId();
                detailIdMap.put(detailEntity.getId(), id);
                detailEntity.setId(id);
                detailEntity.setQuotaTypeId((Long)typeIdMap.get(detailEntity.getQuotaTypeId()));
                detailEntity.setQuotaId(mainId);
                this.clearData(detailEntity);
            }
            this.quotaDetailService.saveBatch(detailEntities);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(QuotaMatEntity::getQuotaId, (Object)copyId);
        List matEntities = this.quotaMatService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)matEntities)) {
            for (QuotaMatEntity matEntity : matEntities) {
                Long id = IdWorker.getId();
                matEntity.setId(id);
                matEntity.setQuotaTypeId((Long)typeIdMap.get(matEntity.getQuotaTypeId()));
                matEntity.setQuotaDetailId((Long)detailIdMap.get(matEntity.getQuotaDetailId()));
                matEntity.setQuotaId(mainId);
                this.clearData(matEntity);
            }
            this.quotaMatService.saveBatch(matEntities);
        }
        return (QuotaVO)BeanMapper.map((Object)this.selectById(mainId), QuotaVO.class);
    }

    private void clearData(BaseVO baseVO) {
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
    }

    private void clearData(BaseEntity baseEntity) {
        baseEntity.setCreateTime(null);
        baseEntity.setCreateUserCode(null);
        baseEntity.setUpdateTime(null);
        baseEntity.setUpdateUserCode(null);
    }
}

