/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.ejianc.business.budget.service.IBudgetCostReportService;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetCostReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetCostReport"})
public class BudgetCostReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetCostReportService service;

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetCostReportVO> queryReport(Long projectId) {
        return this.service.queryReport(projectId);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExport(@RequestParam Long projectId, HttpServletResponse response) {
        CommonResponse<BudgetCostReportVO> commonResponse = this.service.queryReport(projectId);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
            BudgetCostReportVO vo = (BudgetCostReportVO)commonResponse.getData();
            ArrayList<BudgetCostReportVO> list = new ArrayList<BudgetCostReportVO>();
            list.add(vo);
            beans.put("main", list);
            beans.put("detail", this.treeToList(vo.getDetailList()));
            ExcelExport.getInstance().export("budget-cost-report-export.xlsx", beans, response);
        }
    }

    private List<BudgetCostReportDetailVO> treeToList(List<BudgetCostReportDetailVO> values) {
        ArrayList<BudgetCostReportDetailVO> result = new ArrayList<BudgetCostReportDetailVO>();
        for (BudgetCostReportDetailVO value : values) {
            result.add(value);
            if (value.getChildren().isEmpty()) continue;
            List child = BeanMapper.mapList((Iterable)value.getChildren(), BudgetCostReportDetailVO.class);
            List<BudgetCostReportDetailVO> entityList = this.treeToList(child);
            result.addAll(entityList);
        }
        if (result.size() > 0) {
            for (BudgetCostReportDetailVO value : result) {
                value.setChildren(null);
            }
        }
        return result;
    }
}

