/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.service.IGuidePriceService;
import com.ejianc.business.cost.vo.GuidePriceDetailVO;
import com.ejianc.business.cost.vo.GuidePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"guidePrice"})
public class GuidePriceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBrandApi brandApi;
    private static final String BILL_CODE = "ZDJ-CODE";
    @Autowired
    private IGuidePriceService service;
    @Autowired
    private IGuidePriceDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GuidePriceVO> saveOrUpdate(@RequestBody GuidePriceVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GuidePriceVO> queryDetail(Long id) {
        GuidePriceEntity entity = (GuidePriceEntity)((Object)this.service.selectById(id));
        GuidePriceVO vo = (GuidePriceVO)BeanMapper.map((Object)((Object)entity), GuidePriceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GuidePriceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GuidePriceVO guidePriceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GuidePriceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("title");
        fuzzyFields.add("orgName");
        fuzzyFields.add("releaseUserName");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List guidePriceVOS = BeanMapper.mapList((Iterable)page.getRecords(), GuidePriceVO.class);
        guidePriceVOS.stream().forEach(e -> e.setStatusStr(e.getStatus() == 1 ? "\u542f\u7528" : "\u5173\u95ed"));
        pageData.setRecords(guidePriceVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<GuidePriceVO>> iPageCommonResponse = this.queryList(param);
        if (!iPageCommonResponse.isSuccess()) {
            throw new BusinessException(iPageCommonResponse.getMsg());
        }
        List records = ((IPage)iPageCommonResponse.getData()).getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        records.forEach(reviewVO -> reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)reviewVO.getBillState()).getDescription()));
        beans.put("records", records);
        ExcelExport.getInstance().export("GuidePrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refGuidePriceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GuidePriceVO>> refGuidePriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GuidePriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refGuidePriceDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GuidePriceDetailVO>> refGuidePriceDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"reviewId")) {
            param.getParams().put("reviewId", new Parameter("eq", _con.get((Object)"reviewId")));
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GuidePriceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGuidePriceDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryGuidePriceDetailData() {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.detailService.queryGuidePriceDetailData());
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"GuidePriceImport.xlsx", (String)"\u4ef7\u683c\u660e\u7ec6\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<GuidePriceDetailVO> successList = new ArrayList<GuidePriceDetailVO>();
        ArrayList<GuidePriceDetailVO> errorList = new ArrayList<GuidePriceDetailVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            GuidePriceDetailVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new GuidePriceDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setErrorMsg("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String materialCategoryCode = (String)datas.get(0);
                CommonResponse categoryResponse = this.materialApi.queryCategoryByCode(materialCategoryCode);
                if (!categoryResponse.isSuccess()) {
                    vo.setErrorMsg("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u5931\u8d25\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (null == categoryResponse.getData()) {
                    vo.setErrorMsg("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)categoryResponse.getData();
                vo.setMaterialCategoryId(materialCategoryVO.getId());
                vo.setMaterialCategoryCode(materialCategoryCode);
                vo.setMaterialCategoryName(materialCategoryVO.getName());
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u6750\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String materialCode = (String)datas.get(1);
                vo.setMaterialCode(materialCode);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u6750\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String materialName = (String)datas.get(2);
                vo.setMaterialName(materialName);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u89c4\u683c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String spec = (String)datas.get(3);
                vo.setSpec(spec);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setUnit(null);
                } else {
                    String unit = (String)datas.get(4);
                    vo.setUnit(unit);
                }
                MaterialVO materialVO = new MaterialVO();
                materialVO.setName(materialName);
                materialVO.setCode(materialCode);
                materialVO.setSpec(spec);
                materialVO.setUnitName(null == vo.getUnit() ? null : vo.getUnit());
                materialVO.setCategoryId(materialCategoryVO.getId());
                CommonResponse materialResponse = this.materialApi.queryExitFlag(materialVO);
                if (!materialResponse.isSuccess()) {
                    vo.setErrorMsg("\u5339\u914d\u67e5\u8be2\u7269\u6599\u5931\u8d25\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (null == materialResponse.getData()) {
                    vo.setErrorMsg("\u5339\u914d\u67e5\u8be2\u7269\u6599\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                MaterialVO material = (MaterialVO)materialResponse.getData();
                vo.setMaterialId(material.getId());
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setBrandId(null);
                    vo.setBrandName(null);
                } else {
                    String brandName = (String)datas.get(5);
                    CommonResponse brandVOCommonResponse = this.brandApi.queryBrandByName(brandName);
                    if (!brandVOCommonResponse.isSuccess()) {
                        vo.setErrorMsg("\u5339\u914d\u67e5\u8be2\u54c1\u724c\u5931\u8d25\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    if (null == brandVOCommonResponse.getData()) {
                        vo.setErrorMsg("\u5339\u914d\u67e5\u8be2\u54c1\u724c\u4e3a\u7a7a\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    vo.setBrandName(brandName);
                    vo.setBrandId(((BrandVO)brandVOCommonResponse.getData()).getId());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setErrorMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String price = (String)datas.get(6);
                try {
                    vo.setPrice(new BigDecimal(price));
                }
                catch (Exception e) {
                    vo.setPrice(null);
                    vo.setErrorMsg("\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setSourceType(Integer.valueOf(1));
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

