package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.QuotaTypeVO;
import com.ejianc.business.budget.vo.QuotaVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定额库
 *
 * @author generator
 */
@Controller
@RequestMapping("quota")
public class QuotaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IQuotaService service;
    @Autowired
    private IQuotaTypeService quotaTypeService;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaVO> saveOrUpdate(@RequestBody QuotaVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description copySave 复制
     */
    @RequestMapping(value = "/copySave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaVO> copySave(@RequestBody QuotaVO quotaVO) {
        return CommonResponse.success("复制单据成功！", service.copySave(quotaVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaVO> queryDetail(Long id) {
        QuotaEntity entity = service.selectById(id);
        QuotaVO vo = BeanMapper.map(entity, QuotaVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaVO> vos) {
        List<Long> mainIds = vos.stream().map(QuotaVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<QuotaDetailEntity> qry = new LambdaQueryWrapper<>();
        qry.in(QuotaDetailEntity::getQuotaId, mainIds);
        List<QuotaDetailEntity> list = quotaDetailService.list(qry);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> longs = list.stream().map(QuotaDetailEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<BudgetSetQuotaEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(BudgetSetQuotaEntity::getQuotaId, longs);
            if (budgetSetQuotaService.count(queryWrapper) > 0) {
                throw new BusinessException("所选定额库被[清单定额关系设置]引用，不允许删除!");
            }
            LambdaQueryWrapper<BudgetProjectDetailProEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(BudgetProjectDetailProEntity::getSourceId, longs);
            if (budgetProjectDetailProService.count(wrapper) > 0) {
                throw new BusinessException("所选定额库被[目标成本]引用，不允许删除!");
            }
        }
        service.removeByIds(mainIds, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<QuotaEntity> page = service.queryPage(param, false);
        IPage<QuotaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id ", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<QuotaEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quota-export.xlsx", beans, response);
    }


    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refQuotaData", method = RequestMethod.GET)
    @ResponseBody
    public List<QuotaTypeVO> refQuotaData(@RequestParam(required = false) String searchText,
                                          @RequestParam(required = false) String condition) {
        List<QuotaTypeVO> typeList = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        LambdaQueryWrapper<QuotaEntity> queryWrapper = Wrappers.<QuotaEntity>lambdaQuery();
        queryWrapper.eq(QuotaEntity::getEnableState, 1);
        queryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
        QuotaEntity quotaEntity = service.getOne(queryWrapper, false);
        if (null == quotaEntity) {
            return typeList;
        }
        LambdaQueryWrapper<QuotaTypeEntity> lambda = Wrappers.<QuotaTypeEntity>lambdaQuery();
        lambda.eq(QuotaTypeEntity::getQuotaId, quotaEntity.getId());
        if (StringUtils.isNotBlank(searchText)) {
            lambda.like(QuotaTypeEntity::getQuotaName, searchText);
        }
        List<QuotaTypeEntity> resList = quotaTypeService.list(lambda);
        if (CollectionUtils.isNotEmpty(resList)) {
            typeList = BeanMapper.mapList(resList, QuotaTypeVO.class);

            typeList.forEach(e -> {
                e.setCode(e.getQuotaName());
                e.setName(e.getQuotaName());
            });
        }
        return typeList;
    }

    /**
     * @param id
     * @Description updaeEnable 更新启用停用
     */
    @RequestMapping(value = "/updateEnable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateEnable(Long id, Boolean enableState) {
        if (enableState) {
            LambdaQueryWrapper<QuotaEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.ne(QuotaEntity::getId, id);
            queryWrapper.eq(QuotaEntity::getEnableState, 1);
            QuotaEntity quotaEntity = service.getOne(queryWrapper, false);
            if (null != quotaEntity) {
                quotaEntity.setEnableState(0);
                service.saveOrUpdate(quotaEntity);
            }
        }
        LambdaUpdateWrapper<QuotaEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(QuotaEntity::getId, id);
        updateWrapper.set(QuotaEntity::getEnableState, enableState);
        service.update(updateWrapper);
        return CommonResponse.success("更新启用停用成功！");
    }
}
