package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 预算量调整申请单-ERP材料调整表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_adjustment_detail")
public class AdjustmentDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="adjustment_id")
    private Long adjustmentId; // 预算调整申请主键
    @TableField(value="materials_name")
    private String materialsName; // 材料名称
    @TableField(value="materials_size")
    private String materialsSize; // 规格
    @TableField(value="materials_num")
    private BigDecimal materialsNum; // ERP数量
    @TableField(value="drawing_num")
    private BigDecimal drawingNum; // 图纸数量
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="project_adjustment_num")
    private BigDecimal projectAdjustmentNum; // 项目部计算需调整数量
    @TableField(value="settlement_adjustment_num")
    private BigDecimal settlementAdjustmentNum; // 结算部核算需调整数量
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 采购部填写单价
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 采购总价
    @TableField(value="office")
    private String office; // 科室
    @TableField(value="has_contract")
    private Integer hasContract; // 合同内是否有单价 0-是,1-否
    @TableField(value="accomplish_time")
    private Date accomplishTime; // 认质认价完成时间
    @TableField(value="memo")
    private String memo; // 备注
    
    
    

    public Long getAdjustmentId() {
        return adjustmentId;
    }

    public void setAdjustmentId(Long adjustmentId) {
        this.adjustmentId = adjustmentId;
    }
    public String getMaterialsName() {
        return materialsName;
    }

    public void setMaterialsName(String materialsName) {
        this.materialsName = materialsName;
    }
    public String getMaterialsSize() {
        return materialsSize;
    }

    public void setMaterialsSize(String materialsSize) {
        this.materialsSize = materialsSize;
    }
    public BigDecimal getMaterialsNum() {
        return materialsNum;
    }

    public void setMaterialsNum(BigDecimal materialsNum) {
        this.materialsNum = materialsNum;
    }
    public BigDecimal getDrawingNum() {
        return drawingNum;
    }

    public void setDrawingNum(BigDecimal drawingNum) {
        this.drawingNum = drawingNum;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getProjectAdjustmentNum() {
        return projectAdjustmentNum;
    }

    public void setProjectAdjustmentNum(BigDecimal projectAdjustmentNum) {
        this.projectAdjustmentNum = projectAdjustmentNum;
    }
    public BigDecimal getSettlementAdjustmentNum() {
        return settlementAdjustmentNum;
    }

    public void setSettlementAdjustmentNum(BigDecimal settlementAdjustmentNum) {
        this.settlementAdjustmentNum = settlementAdjustmentNum;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getOffice() {
        return office;
    }

    public void setOffice(String office) {
        this.office = office;
    }
    public Integer getHasContract() {
        return hasContract;
    }

    public void setHasContract(Integer hasContract) {
        this.hasContract = hasContract;
    }
    public Date getAccomplishTime() {
        return accomplishTime;
    }

    public void setAccomplishTime(Date accomplishTime) {
        this.accomplishTime = accomplishTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
