package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.mapper.GuidePriceDetailMapper;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.service.IGuidePriceService;
import com.ejianc.business.cost.vo.GuidePriceDetailVO;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 指导价-价格明细
 *
 * @author generator
 */
@Service("guidePriceDetailService")
public class GuidePriceDetailServiceImpl extends BaseServiceImpl<GuidePriceDetailMapper, GuidePriceDetailEntity> implements IGuidePriceDetailService {


    @Autowired
    private IGuidePriceService guidePriceService;


    @Override
    public Map<String, BigDecimal> queryGuidePriceDetailData() {
        LambdaQueryWrapper<GuidePriceEntity> query = Wrappers.lambdaQuery();
        query.in(GuidePriceEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        query.eq(GuidePriceEntity::getStatus, 1);
        query.orderByDesc(GuidePriceEntity::getReleaseDate);
        query.last("limit 1");
        List<GuidePriceEntity> list = guidePriceService.list(query);
        Map<String, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            LambdaQueryWrapper<GuidePriceDetailEntity> detailQuery = Wrappers.lambdaQuery();
            detailQuery.eq(GuidePriceDetailEntity::getReviewId, list.get(0).getId());
            List<GuidePriceDetailEntity> detailEntityList = this.list(detailQuery);
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (GuidePriceDetailEntity entity : detailEntityList) {
                    map.put(entity.getMaterialId().toString() + (null==entity.getBrandId()?null:entity.getBrandId().toString()), entity.getPrice());
                }
            }
        }
        return map;
    }
}
