package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaTypeEntity;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaTypeService;
import com.ejianc.business.budget.vo.QuotaTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定额库工程类型
 *
 * @author generator
 */
@Controller
@RequestMapping("quotaType")
public class QuotaTypeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IQuotaTypeService service;
    @Autowired
    private IQuotaDetailService quotaDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaTypeVO> saveOrUpdate(@RequestBody QuotaTypeVO saveOrUpdateVO) {
        LambdaQueryWrapper<QuotaTypeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(QuotaTypeEntity::getQuotaId, saveOrUpdateVO.getQuotaId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), QuotaTypeEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaTypeEntity::getQuotaCode, StringUtils.trim(saveOrUpdateVO.getQuotaCode()));
        if (service.count(queryWrapper) > 0) {
            throw new BusinessException("编码重复,不允许保存!");
        }
        QuotaTypeEntity entity = BeanMapper.map(saveOrUpdateVO, QuotaTypeEntity.class);
        service.saveOrUpdate(entity, false);
        QuotaTypeVO vo = BeanMapper.map(entity, QuotaTypeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaTypeVO> queryDetail(Long id) {
        QuotaTypeEntity entity = service.selectById(id);
        QuotaTypeVO vo = BeanMapper.map(entity, QuotaTypeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaTypeVO> vos) {
        List<Long> longs = vos.stream().map(QuotaTypeVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<QuotaDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(QuotaDetailEntity::getQuotaTypeId, longs);
        if (quotaDetailService.count(queryWrapper) > 0) {
            throw new BusinessException("所选[工程类型]下存在定额项，不允许删除!");
        }
        service.removeByIds(longs, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaTypeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<QuotaTypeEntity> page = service.queryPage(param, false);
        IPage<QuotaTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaTypeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<QuotaTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("QuotaType-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refQuotaTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotaTypeVO>> refQuotaTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotaTypeEntity> page = service.queryPage(param, false);
        IPage<QuotaTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaTypeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
