package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 甲方批复
 *
 * @author generator
 *
 */
 @TableName("ejc_cost_approvment")
public class ApprovmentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="proj_manager_id")
    private Long projManagerId; // 项目负责人ID
    @TableField(value="proj_manager_name")
    private String projManagerName; // 项目负责人名称
    @TableField(value="claim_id")
    private Long claimId; // 签证id
    @TableField(value="claim_code")
    private String claimCode; // 签证编号
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="occur_date")
    private Date occurDate; // 发生日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="pre_approve_mny")
    private BigDecimal preApproveMny; // 预计审定金额
    @TableField(value="offer_mny")
    private BigDecimal offerMny; // 报价金额
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额
    @TableField(value="first_agree_mny")
    private BigDecimal firstAgreeMny; // 甲方批复金额
    @TableField(value="lock_state")
    private Integer lockState; // 锁定状态1-锁项2-锁价




    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjManagerId() {
        return projManagerId;
    }

    public void setProjManagerId(Long projManagerId) {
        this.projManagerId = projManagerId;
    }
    public String getProjManagerName() {
        return projManagerName;
    }

    public void setProjManagerName(String projManagerName) {
        this.projManagerName = projManagerName;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getClaimCode() {
        return claimCode;
    }

    public void setClaimCode(String claimCode) {
        this.claimCode = claimCode;
    }
    public Date getOccurDate() {
        return occurDate;
    }

    public void setOccurDate(Date occurDate) {
        this.occurDate = occurDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public BigDecimal getPreApproveMny() {
        return preApproveMny;
    }

    public void setPreApproveMny(BigDecimal preApproveMny) {
        this.preApproveMny = preApproveMny;
    }
    public BigDecimal getOfferMny() {
        return offerMny;
    }

    public void setOfferMny(BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getFirstAgreeMny() {
        return firstAgreeMny;
    }

    public void setFirstAgreeMny(BigDecimal firstAgreeMny) {
        this.firstAgreeMny = firstAgreeMny;
    }
    public Integer getLockState() {
        return lockState;
    }

    public void setLockState(Integer lockState) {
        this.lockState = lockState;
    }

}
