package com.ejianc.business.budget.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 项目预算清单
 *
 * @author generator
 *
 */
public interface IBudgetProjectDetailService extends IBaseService<BudgetProjectDetailEntity> {

    void deleteByBudgetId(Long budgetId);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    List<BudgetProjectDetailVO> detailRef(Long projectId);

    CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response);

    List<BudgetMatchVO> queryMatchList(Page<BudgetMatchVO> page, QueryWrapper wrapper, Long budgetId, Long setDetailId);

    List<BudgetSetDetailVO> querySimilar(Long budgetDetailId);
}
