package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetMatchVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 项目预算清单
 *
 * @author generator
 */
@Service("budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity> implements IBudgetProjectDetailService {

    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;


    @Override
    public void deleteByBudgetId(Long id) {
        QueryWrapper<BudgetProjectDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("budget_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "项目名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setProjectFeature(datas.get(3));//项目特征
                    vo.setUnit(datas.get(4));
//                    if (StringUtils.isEmpty(datas.get(4))) {//清单名称为空
//                        vo.setUnit(null);
//                        warnType =  warnType+"单位为空,";
//                        flag = true;
//                        parentWarn = true;
//                    } else {
//                        vo.setUnit(datas.get(4));
//                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType + "工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

//                    if (StringUtils.isEmpty(datas.get(6))) {
//                        vo.setPrice(null);
//                        warnType = warnType+"综合单价为空,";
//                        flag = true;
//                    } else {
//                        try {
//                            vo.setPrice(new BigDecimal(datas.get(6)));
//                        } catch (Exception e) {
//                            vo.setPrice(null);
//                            warnType = warnType+"综合单价只能为数字或小数,";
//                            flag = true;
//                        }
//                    }

                    if (StringUtils.isEmpty(datas.get(7))) {// 不是强制必输
                        vo.setLaborCost(null);
                    } else {
                        try {
                            vo.setLaborCost(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setLaborCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {// 不是强制必输
                        vo.setMaterialCost(null);
                    } else {
                        try {
                            vo.setMaterialCost(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setMaterialCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {// 不是强制必输
                        vo.setMechanicalCost(null);
                    } else {
                        try {
                            vo.setMechanicalCost(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setMechanicalCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {// 不是强制必输
                        vo.setOtherCost(null);
                    } else {
                        try {
                            vo.setOtherCost(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setOtherCost(null);
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setMny(null);
                        warnType = warnType + "合价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "合价只能为数字或小数,";
                            flag = true;
                        }
                    }


                    if (null == vo.getNum() || null == vo.getMny()) {
                        vo.setPrice(null);
                    } else {
                        if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                            vo.setPrice(null);
                        } else {
                            vo.setPrice(vo.getMny().divide(vo.getNum(), 20, BigDecimal.ROUND_HALF_EVEN));
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (BudgetProjectDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    //清单参照
    @Override
    public List<BudgetProjectDetailVO> detailRef(Long projectId) {
        // 根据项目获取主表主键
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, projectId);
        queryWrapper.and(wrapper -> wrapper.eq(BudgetProjectEntity::getBillState, 1).or().eq(BudgetProjectEntity::getBillState, 3));
        BudgetProjectEntity entity = budgetProjectService.getOne(queryWrapper);
        // 根据主表主键查询子表
        List<BudgetProjectDetailVO> detailList = new ArrayList<>();
        if (entity != null && entity.getId() != null) {
            LambdaQueryWrapper<BudgetProjectDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BudgetProjectDetailEntity::getBudgetId, entity.getId());
            wrapper.ne(BudgetProjectDetailEntity::getChangeType, 5);//中止不显示
            wrapper.orderBy(true, true, BudgetProjectDetailEntity::getDetailIndex);
            List<BudgetProjectDetailEntity> entityList = super.list(wrapper);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (BudgetProjectDetailEntity i : entityList) {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                }
            }
            detailList = BeanMapper.mapList(entityList, BudgetProjectDetailVO.class);
            //实现排序
            Collections.sort(detailList, new BudgetDetailComparatoeVo());
        }
        return TreeNodeBUtil.buildTree(detailList);
    }

    @Override
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        Integer projNameLine = Integer.valueOf(request.getParameter("projNameLine"));
        Integer beginLine = Integer.valueOf(request.getParameter("beginLine"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = HuaKangExcelReader.readExcel(mf, projNameLine, beginLine);
            if (result != null && result.size() > 0) {
                int engineeringNameIndex = 0;

                int nameIndex = 0;

                int itemIndex = 0;

                String engineeringtpid = "";

                String tpid = "";

                //筛选重复序号
                List<BudgetProjectDetailVO> detailVoList = new LinkedList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;

                    vo.setSheetName(datas.get(0));
                    String detailIndex = datas.get(1);
                    String code = datas.get(2);
                    String name = datas.get(3);
                    if (StringUtils.isEmpty(code) || StringUtils.isEmpty(detailIndex)) {
                        if (StringUtils.isNotEmpty(detailIndex)) {
                            // 工程名称
                            if (detailIndex.contains("工程名称")) {
                                String engineeringName = detailIndex.replaceAll("工程名称：", "").trim();
                                engineeringNameIndex++;
                                vo.setDetailIndex(String.valueOf(engineeringNameIndex));
                                vo.setName(engineeringName);
                                engineeringtpid = vo.getDetailIndex();
                                vo.setTid(vo.getDetailIndex());
                                nameIndex = 0;
                                vo.setImportFlag(true);// true=可以导入，false=不可导入
                                vo.setParentWarn(false);
                                vo.setRowState("add");
                                vo.setShadowId(vo.getTid());
                                String key = vo.getCode() + vo.getName() + vo.getUnit();
                                vo.setKey(key);
                                detailVoList.add(vo);
                                continue;
                            }
                            // 标题
                            if (StringUtils.isEmpty(name)) {
                                continue;
                            }
                        } else {
                            // 序号为空，name不为空则是项目名称
                            if (StringUtils.isNotEmpty(name) && !"分部小计".equals(name)) {
                                BudgetProjectDetailVO lastVO = detailVoList.get(detailVoList.size() - 1);
                                if (lastVO.getDetailIndex().contains(".") && lastVO.getDetailIndex().split("[-/.]").length == 2) {
                                    vo.setDetailIndex(engineeringNameIndex + "." + nameIndex + ".1");
                                    vo.setName(name);
                                    vo.setTpid(tpid);
                                    vo.setTid(vo.getDetailIndex());
                                    vo.setParentId(Long.valueOf(111));//随便给个父级id，前端合计时parentId必须有值
                                    tpid = vo.getDetailIndex();
                                    itemIndex = 0;
                                    vo.setImportFlag(true);// true=可以导入，false=不可导入
                                    vo.setParentWarn(false);
                                    vo.setRowState("add");
                                    vo.setShadowId(vo.getTid());
                                    String key = vo.getCode() + vo.getName() + vo.getUnit();
                                    vo.setKey(key);
                                    detailVoList.add(vo);
                                    continue;
                                } else {
                                    nameIndex++;
                                    vo.setDetailIndex(engineeringNameIndex + "." + nameIndex);
                                    vo.setCode("单价措施费".equals(name) ? code : null);
                                    vo.setName(name);
                                    vo.setTpid(engineeringtpid);
                                    vo.setTid(vo.getDetailIndex());
                                    vo.setParentId(Long.valueOf(111));//随便给个父级id，前端合计时parentId必须有值
                                    tpid = vo.getDetailIndex();
                                    itemIndex = 0;
                                    vo.setImportFlag(true);// true=可以导入，false=不可导入
                                    vo.setParentWarn(false);
                                    vo.setRowState("add");
                                    vo.setShadowId(vo.getTid());
                                    String key = vo.getCode() + vo.getName() + vo.getUnit();
                                    vo.setKey(key);
                                    detailVoList.add(vo);
                                    continue;
                                }
                            }
                        }
                    } else {
                        itemIndex++;
                        String warnType = "";
                        vo.setDetailIndex(tpid + "." + itemIndex);
                        vo.setTid(vo.getDetailIndex());
                        vo.setTpid(tpid);
                        vo.setParentId(Long.valueOf(111));//随便给个父级id，前端合计时parentId必须有值

                        if (StringUtils.isEmpty(code)) {// 清单编码为空
                            vo.setCode(null);
                            warnType = warnType + "项目编码为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setCode(code);
                        }

                        if (StringUtils.isEmpty(name)) {//清单名称为空
                            vo.setName(null);
                            warnType = warnType + "项目名称为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setName(name.replace(" ", ""));
                        }

                        vo.setProjectFeature(datas.get(4));//项目特征
                        vo.setUnit(datas.get(5));

                        if (StringUtils.isEmpty(datas.get(6))) {
                            vo.setNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setNum(new BigDecimal(datas.get(6)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isEmpty(datas.get(7))) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setPrice(new BigDecimal(datas.get(7)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType + "综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }


                        if (StringUtils.isEmpty(datas.get(8))) {
                            vo.setMny(null);
                            warnType = warnType + "合价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMny(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setMny(null);
                                warnType = warnType + "合价只能为数字或小数,";
                                flag = true;
                            }
                        }


                        if (null == vo.getNum() || null == vo.getMny()) {
                            vo.setPrice(null);
                        } else {
                            if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                                vo.setPrice(null);
                            } else {
                                vo.setPrice(vo.getMny().divide(vo.getNum(), 20, BigDecimal.ROUND_HALF_EVEN));
                                vo.setPrice(ComputeUtil.scale(ComputeUtil.safeDiv(vo.getMny(), vo.getNum()), 4));
                            }
                        }

                        vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                        vo.setParentWarn(parentWarn);
                        if (flag) {
                            warnType = warnType.substring(0, warnType.length() - 1);
                        }
                        vo.setWarnType(warnType);
                        vo.setRowState("add");
                        vo.setShadowId(vo.getTid());
                        vo.setChangeType(3);//增补项
                        detailVoList.add(vo);
                    }
                }

                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<BudgetMatchVO> queryMatchList(Page<BudgetMatchVO> page, QueryWrapper wrapper, Long budgetId, Long setDetailId) {
        return baseMapper.queryMatchList(page, wrapper, budgetId, setDetailId);
    }

    @Override
    public List<BudgetSetDetailVO> querySimilar(Long budgetDetailId) {
        LambdaQueryWrapper<BudgetSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetSetEntity::getEnableState, 1);
        BudgetSetEntity setEntity = budgetSetService.getOne(queryWrapper, false);
        LambdaQueryWrapper<BudgetSetDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetSetDetailEntity::getSetId, setEntity.getId());
        List<BudgetSetDetailEntity> list = budgetSetDetailService.list(wrapper);
        Map<String, List<BudgetSetDetailEntity>> detailMap = new HashMap<>();
        for (BudgetSetDetailEntity detailEntity : list) {
            String detailCode = removeLastThreeCharacters(detailEntity.getDetailCode());
            List<BudgetSetDetailEntity> result = detailMap.containsKey(detailCode) ? detailMap.get(detailCode) : new ArrayList<>();
            result.add(detailEntity);
            detailMap.put(detailCode, result);
        }
        BudgetProjectDetailEntity detailEntity = selectById(budgetDetailId);
        String detailCode = removeLastThreeCharacters(detailEntity.getCode());
        return CollectionUtils.isNotEmpty(detailMap.get(detailCode)) ? BeanMapper.mapList(detailMap.get(detailCode), BudgetSetDetailVO.class) : null;
    }

    private String removeLastThreeCharacters(String str) {
        if (str == null || str.length() <= 3) {
            return "";  // 如果字符串为null或长度小于等于3，返回空字符串
        }
        return str.substring(0, str.length() - 3);
    }

}
