package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目预算
 *
 * @author generator
 */
@Service("budgetProjectService")
public class BudgetProjectServiceImpl extends BaseServiceImpl<BudgetProjectMapper, BudgetProjectEntity> implements IBudgetProjectService {
    private static final String BILL_CODE_ROLE = "BUDGET_PRO_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectDetailService detailsService;
    @Autowired
    private BudgetProjectMapper budgetProjectMapper;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;

    @Override
    public CommonResponse<BudgetProjectVO> saveOrUpdate(BudgetProjectVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetProjectEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, BudgetProjectEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(saveorUpdateVO, BudgetProjectEntity.class);
            operateType = "add";
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<BudgetProjectEntity> lambda = Wrappers.<BudgetProjectEntity>lambdaQuery();
            lambda.eq(BudgetProjectEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(BudgetProjectEntity::getTenantId, tenantId);
            lambda.ne(BudgetProjectEntity::getId, saveorUpdateVO.getId());
            List<BudgetProjectEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
//            LambdaQueryWrapper<BudgetProjectEntity> lambda2 = Wrappers.<BudgetProjectEntity>lambdaQuery();
//            lambda2.eq(BudgetProjectEntity::getProjectId, saveorUpdateVO.getProjectId());
//            lambda2.eq(BudgetProjectEntity::getTenantId, tenantId);
//            lambda2.ne(BudgetProjectEntity::getId, saveorUpdateVO.getId());
//            List<BudgetProjectEntity> entities2 = super.list(lambda2);
//            if(entities2 != null && entities2.size() > 0) {
//                throw new BusinessException("该项目已经做过预算，不允许保存!");
//            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<BudgetProjectEntity> lambda = Wrappers.<BudgetProjectEntity>lambdaQuery();
            lambda.eq(BudgetProjectEntity::getTenantId, tenantId);
            lambda.eq(BudgetProjectEntity::getBillCode, saveorUpdateVO.getBillCode());
            List<BudgetProjectEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
//            LambdaQueryWrapper<BudgetProjectEntity> lambda2 = Wrappers.<BudgetProjectEntity>lambdaQuery();
//            lambda2.eq(BudgetProjectEntity::getTenantId, tenantId);
//            lambda2.eq(BudgetProjectEntity::getProjectId, saveorUpdateVO.getProjectId());
//            List<BudgetProjectEntity> entities2 = super.list(lambda2);
//            if(entities2 != null && entities2.size() > 0) {
//                throw new BusinessException("该项目已经做过预算，不允许保存!");
//            }
        }
        entity.setConvertState(0);
        entity.setBaseBudgetMoney(entity.getBudgetMny());//初始版本金额
        entity.setBeforeChangeBudgetMny(entity.getBudgetMny());//变更前金额
        entity.setBaseLaborMny(entity.getLaborMny());//初始版本金额
        entity.setBeforeChangeLaborMny(entity.getLaborMny());//变更前金额
        entity.setBaseMaterialMny(entity.getMaterialMny());//初始版本金额
        entity.setBeforeChangeMaterialMny(entity.getMaterialMny());//变更前金额
        entity.setBaseMechanicalMny(entity.getMechanicalMny());//初始版本金额
        entity.setBeforeChangeMechanicalMny(entity.getMechanicalMny());//变更前金额
        entity.setBaseOtherMny(entity.getOtherMny());//初始版本金额
        entity.setBeforeChangeOtherMny(entity.getOtherMny());//变更前金额
        entity.setBaseTotalMny(entity.getTotalMny());
        entity.setBeforeChangeTotalMny(entity.getTotalMny());
        List<BudgetProjectDetailVO> detailsVos = saveorUpdateVO.getCheckList();
        int leaf = 0;//全部末级数量
        int subject = 0;// 已关联数量
        for (BudgetProjectDetailVO detailsVo : detailsVos) {
            // 不是删除项 末级
            if (!"del".equals(detailsVo.getRowState()) && detailsVo.getLeafFlag()) {
                leaf++;
                if (detailsVo.getSubjectId() != null) {// 有关联
                    subject++;
                }
            }
        }
        if (leaf == subject) {
            entity.setLinkedFlag(1);
            entity.setUnassociate(0);
        } else {
            entity.setLinkedFlag(0);
            entity.setUnassociate(leaf - subject);
        }
        super.saveOrUpdate(entity);

        List<BudgetProjectDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (BudgetProjectDetailVO detailsVo : detailsVos) {
            detailsVo.setChangeType(0);//因为导入的时候设置为增补项，避免后面逻辑问题，这里修改一下
            if ("add".equals(detailsVo.getRowState())) {
                BudgetProjectDetailEntity detailslist = BeanMapper.map(detailsVo, BudgetProjectDetailEntity.class);
                detailslist.setBudgetId(entity.getId());
                saveOrUpldates.add(detailslist);
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetProjectDetailEntity detailslist = BeanMapper.map(detailsVo, BudgetProjectDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            detailsService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public BudgetProjectVO queryDetail(Long id) {
        BudgetProjectEntity entity = budgetProjectMapper.selectById(id);
        if (entity != null) {
            BudgetProjectVO contractVo = BeanMapper.map(entity, BudgetProjectVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<BudgetProjectDetailEntity> purchaseDetailss = detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (BudgetProjectDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                //List<BudgetProjectDetailVO> purchaseDetailsVos = BeanMapper.mapList(purchaseDetailss, BudgetProjectDetailVO.class);
                List<BudgetProjectDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, BudgetProjectDetailVO.class);
                //实现排序
                Collections.sort(resultMapList, new BudgetDetailComparatoeVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
                //contractVo.setDetailsList(purchaseDetailsVos);
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public CommonResponse<BudgetProjectVO> pushCost(BudgetProjectVO pushVO) {
        List<BudgetProjectDetailVO> checkList = pushVO.getCheckList();
        int leaf = 0;//全部末级数量
        int subject = 0;// 已关联数量
        if (CollectionUtils.isNotEmpty(checkList)) {
            for (BudgetProjectDetailVO detailsVo : checkList) {
                // 不是删除项 末级
                if (detailsVo.getLeafFlag()) {
                    leaf++;
                    if (detailsVo.getSubjectId() != null) {// 有关联
                        subject++;
                    }
                }
            }
            LambdaUpdateWrapper<BudgetProjectEntity> lambda = new LambdaUpdateWrapper();
            if (leaf == subject) {
                lambda.set(BudgetProjectEntity::getLinkedFlag, 1);
                lambda.set(BudgetProjectEntity::getUnassociate, 0);
            } else {
                lambda.set(BudgetProjectEntity::getLinkedFlag, 0);
                lambda.set(BudgetProjectEntity::getUnassociate, leaf - subject);
            }
            lambda.eq(BudgetProjectEntity::getId, pushVO.getId());
            super.update(lambda);

            List<BudgetProjectDetailEntity> detailEntities = BeanMapper.mapList(checkList, BudgetProjectDetailEntity.class);
            detailsService.saveOrUpdateBatch(detailEntities);
        }
        return CommonResponse.success(queryDetail(pushVO.getId()));
    }

    @Override
    public CommonResponse<String> convertToPro(BudgetProjectVO budgetProjectVO) {
        if (2 != budgetProjectVO.getBudgetType().intValue() && 4 != budgetProjectVO.getBudgetType().intValue()) {
            throw new BusinessException("只有类型为[施工图预算]和[签证]的预算书允许转换成目标成本!");
        }
        List<BudgetProjectDetailVO> projectDetailVOS = budgetProjectVO.getCheckList().stream().filter(x -> x.getLeafFlag()).collect(Collectors.toList());
        budgetProjectVO.setCheckList(projectDetailVOS);

        LambdaQueryWrapper<BudgetSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetSetEntity::getEnableState, 1);
        BudgetSetEntity setEntity = budgetSetService.getOne(queryWrapper, false);

        LambdaQueryWrapper<BudgetSetDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetSetDetailEntity::getSetId, setEntity.getId());
        List<BudgetSetDetailEntity> list = budgetSetDetailService.list(wrapper);
        Map<String, List<BudgetSetDetailEntity>> detailMap = new HashMap<>();
        for (BudgetSetDetailEntity detailEntity : list) {
            String detailCode = removeLastThreeCharacters( detailEntity.getDetailCode());
            List<BudgetSetDetailEntity> result = detailMap.containsKey(detailCode) ? detailMap.get(detailCode) : new ArrayList<>();
            result.add(detailEntity);
            detailMap.put(detailCode, result);
        }

        List<BudgetProjectDetailVO> detailVOS = budgetProjectVO.getCheckList();
        for (BudgetProjectDetailVO detailVO : detailVOS) {
            String detailFeature = nullToTrim(detailVO.getProjectFeature()).replaceAll("\\n|\\r|\\r\\n", "");
            boolean matchFlag = false;
            String detailCode = removeLastThreeCharacters(detailVO.getCode());
            if (detailMap.containsKey(detailCode)) {
                List<BudgetSetDetailEntity> result = detailMap.get(detailCode);
                Map<Long, BudgetSetDetailEntity> map = new HashMap<>();
                //循环清单，特征完全匹配，说明是精确匹配，结束
                for (BudgetSetDetailEntity detailEntity : result) {
                    String features = detailEntity.getDescription().replaceAll("\\n|\\r|\\r\\n", "");
                    if (features.equals(detailFeature)) {
                        detailVO.setResultState(ConvertResultEnum.已匹配.getCode());
                        detailVO.setBaseResultState(ConvertResultEnum.已匹配.getCode());
                        detailVO.setSetDetailId(detailEntity.getId());
                        detailVO.setMatchTime(new Date());
                        matchFlag = true;
                        break;
                    }
                    map.put(detailEntity.getId(), detailEntity);
                }

                if (matchFlag) {
                    continue;
                }

                //循环关键特征值，全都包含，说明是精确匹配，结束
                LambdaQueryWrapper<BudgetSetFeaturesEntity> featureQry = new LambdaQueryWrapper<>();
                featureQry.in(BudgetSetFeaturesEntity::getSetDetailId, new ArrayList<>(map.keySet()));
                List<BudgetSetFeaturesEntity> featuresEntities = budgetSetFeaturesService.list(featureQry);
                Map<Long, List<BudgetSetFeaturesEntity>> featMap = featuresEntities.stream().collect(Collectors.groupingBy(BudgetSetFeaturesEntity::getSetDetailId));
                for (Long key : featMap.keySet()) {
                    boolean featMatchFlag = true;
                    List<BudgetSetFeaturesEntity> featList = featMap.get(key);
                    for (BudgetSetFeaturesEntity featuresEntity : featList) {
                        //特征值列表里如果有不包含的，就跳出当前清单循环，继续下一个
                        if (!judgeMatch(detailFeature, featuresEntity)) {
                            featMatchFlag = false;
                            break;
                        }
                    }

                    //特征值列表全都包含，精确匹配
                    if (featMatchFlag) {
                        detailVO.setResultState(ConvertResultEnum.已匹配.getCode());
                        detailVO.setBaseResultState(ConvertResultEnum.已匹配.getCode());
                        detailVO.setSetDetailId(map.get(key).getId());
                        detailVO.setMatchTime(new Date());
                        matchFlag = true;
                        break;
                    }
                }

                if (matchFlag) {
                    continue;
                }
                detailVO.setResultState(ConvertResultEnum.存在相似清单.getCode());
                detailVO.setBaseResultState(ConvertResultEnum.存在相似清单.getCode());
            } else {
                //未匹配
                detailVO.setResultState(ConvertResultEnum.无相似清单.getCode());
                detailVO.setBaseResultState(ConvertResultEnum.无相似清单.getCode());
            }
        }
        List<BudgetProjectDetailEntity> detailEntities = BeanMapper.mapList(detailVOS, BudgetProjectDetailEntity.class);
        detailsService.saveOrUpdateBatch(detailEntities);

        LambdaUpdateWrapper<BudgetProjectEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(BudgetProjectEntity::getId, budgetProjectVO.getId());
        updateWrapper.set(BudgetProjectEntity::getConvertState, 1);
        update(updateWrapper);

        return CommonResponse.success("转换成功!");
    }

    private String removeLastThreeCharacters(String str) {
        if (str == null || str.length() <= 3) {
            return "";  // 如果字符串为null或长度小于等于3，返回空字符串
        }
        return str.substring(0, str.length() - 3);
    }

    private String nullToTrim(String source){
        if (null == source) {
            return "";
        }
        return source;
    }

    private boolean judgeMatch(String features, BudgetSetFeaturesEntity featuresEntity) {
        if (StringUtils.isNotEmpty(featuresEntity.getFeaturesName()) && features.contains(featuresEntity.getFeaturesName())) {
            return true;
        }
        String featuresDescription = featuresEntity.getFeaturesDescription();
        if (StringUtils.isNotEmpty(featuresDescription)) {
            if(featuresDescription.contains(",")){
                String[] arr = featuresDescription.split(",");
                for (String str : arr) {
                    if (features.contains(str)) {
                        return true;
                    }
                }
            }else {
                return features.contains(featuresDescription);
            }

        }
        return false;
    }

    @Override
    public CommonResponse<String> pushToPro(Long budgetId) {
        BudgetProjectEntity entity = selectById(budgetId);
        if (2 != entity.getBudgetType().intValue() && 4 != entity.getBudgetType().intValue()) {
            throw new BusinessException("只有类型为[施工图预算]和[签证]的预算书允许转换成目标成本!");
        }
        if(null != entity.getTargetId()){
            throw new BusinessException("该预算已转换过目标成本!");
        }
        BudgetProjectVO budgetProjectVO = BeanMapper.map(entity, BudgetProjectVO.class);
//        List<BudgetProjectDetailVO> projectDetailVOS = budgetProjectVO.getCheckList().stream().filter(x -> x.getLeafFlag()).collect(Collectors.toList());
//        budgetProjectVO.setCheckList(projectDetailVOS);
        Long result = budgetProjectProService.pushToPro(budgetProjectVO);
        if (null != result) {
            LambdaUpdateWrapper<BudgetProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BudgetProjectEntity::getId, budgetId);
            updateWrapper.set(BudgetProjectEntity::getTargetId, result);
            update(updateWrapper);
            return CommonResponse.success("生成目标成本成功, 可点击【查看目标成本】！");
        } else {
            return CommonResponse.error("生成目标成本失败!");
        }
    }

    @Override
    public CommonResponse<Boolean> checkBeforePush(Long budgetId) {
        BudgetProjectEntity entity = selectById(budgetId);
        if (2 != entity.getBudgetType().intValue() && 4 != entity.getBudgetType().intValue()) {
            throw new BusinessException("只有类型为[施工图预算]和[签证]的预算书允许转换成目标成本!");
        }
        LambdaQueryWrapper<BudgetProjectProEntity> qry = new LambdaQueryWrapper<>();
        qry.eq(BudgetProjectProEntity::getProjectId, entity.getProjectId());
        BudgetProjectProEntity proEntity = budgetProjectProService.getOne(qry, false);
        if (null != proEntity) {
            if (null == proEntity.getSourceId()) {
                throw new BusinessException("已存在自制目标成本，不允许预算转换生成!");
            } else if (!BillStateEnum.COMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(proEntity.getBillState())) {
                throw new BusinessException("该项目目标成本未生效，请处理后生成!");
            } else if (2 == proEntity.getChangeStatus()) {
                throw new BusinessException("目标成本变更中，请处理后生成!");
            }else if(null != entity.getTargetId()){
                throw new BusinessException("该预算已转换过目标成本!");
            }
            return CommonResponse.success("校验通过，该项目存在已生效的目标成本!", true);
        }
        return CommonResponse.success("校验通过，该项目没转换过目标成本!", false);
    }
}
