package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ShareEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.IShareService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.SubjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.SettingEntity;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.vo.SettingVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 成本设置
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("setting")
public class SettingController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISettingService service;

    @Autowired
    private ISubjectService subjectService;

    @Autowired
    private IShareService shareService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettingVO> saveOrUpdate(@RequestBody SettingVO saveorUpdateVO) {
        if(CollectionUtils.isEmpty(saveorUpdateVO.getSubjectDetails())){
            return CommonResponse.error("科目明细不允许为空!");
        }
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(SettingEntity::getProjectId,saveorUpdateVO.getProjectId());
        if(null!=saveorUpdateVO.getId()){
            lambda.ne(SettingEntity::getId,saveorUpdateVO.getId());
        }else {
            saveorUpdateVO.setPushFlag(0);
        }
        List<SettingEntity> details  = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.error("该项目已存在,不允许重复新增！");
        }

        if(null==saveorUpdateVO.getId()){
            List<SubjectVO> listbs = saveorUpdateVO.getSubjectDetails();
            listbs.forEach(e->{
                e.setId(null);
            });
        }

    	SettingEntity entity = BeanMapper.map(saveorUpdateVO, SettingEntity.class);
    	service.saveOrUpdate(entity, false);

    	List<SubjectEntity> listbs = entity.getSubjectDetails();

        //维护父子级关系
        Map<Long,Long> idMap=new HashMap<>();
        for(SubjectEntity cdEntity:listbs){
            idMap.put(cdEntity.getTid(),cdEntity.getId());
        }
        for(SubjectEntity cdEntity:listbs){
            if(999L!=cdEntity.getParentId()){
                cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                cdEntity.setTid(cdEntity.getId());
            }else{
                cdEntity.setTid(cdEntity.getId());
            }
        }
        subjectService.saveOrUpdateBatch(listbs,listbs.size(),false);

    	SettingVO vo = BeanMapper.map(entity, SettingVO.class);
        vo.setSubjectDetails(TreeNodeBUtil.buildTree(vo.getSubjectDetails()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettingVO> queryDetail(Long id) {
    	SettingEntity entity = service.selectById(id);
    	SettingVO settingVO = BeanMapper.map(entity, SettingVO.class);
        if(CollectionUtils.isNotEmpty(entity.getSubjectDetails())){
            settingVO.setSubjectDetails(TreeNodeBUtil.buildTree(settingVO.getSubjectDetails()));
        }
        return CommonResponse.success("查询详情数据成功！",settingVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettingVO> queryCopyDetail(Long id) {
        SettingEntity entity = service.selectById(id);
        entity.setId(null);
        entity.setCreateUserName("");
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setProjectId(null);
        entity.setProjectName("");
        entity.setOrgId(null);
        entity.setOrgName("");
        entity.setBillState(null);

        if(CollectionUtils.isNotEmpty(entity.getSubjectDetails())){
            entity.getSubjectDetails().forEach(vo -> {
                vo.setRowState("add");
            });
        }
        SettingVO settingVO = BeanMapper.map(entity, SettingVO.class);
        if(CollectionUtils.isNotEmpty(settingVO.getSubjectDetails())){
            settingVO.setSubjectDetails(TreeNodeBUtil.buildTree(settingVO.getSubjectDetails()));
        }
        return CommonResponse.success("查询详情数据成功！",settingVO);
    }

    /**
     * @Description querySettingFlag 查询项目是否成本设置
     * @param projectId
     */
    @RequestMapping(value = "/querySettingFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> querySettingFlag(Long projectId) {
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(SettingEntity::getProjectId,projectId);
        lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettingEntity> details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("该项目已成本设置",true);
        }else{
            return CommonResponse.success("该项目未成本设置",false);
        }
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettingVO> vos) {
        service.removeByIds(vos.stream().map(SettingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettingVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<SettingEntity> page = service.queryPage(param,false);
        IPage<SettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        page.getRecords().forEach(vo -> {
            vo.setTaxFlag("0".equals(vo.getTaxFlag())?"是":"否");
            vo.setMaterialCost("0".equals(vo.getMaterialCost())?"出库入成本":"物资合同结算入成本");
        });

  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettingVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 设置参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "costSettingRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettingVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");

        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));


        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("type")) {
                LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
                lambda.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
                lambda.notIn(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
                List<ShareEntity> list = shareService.list(lambda);
                if(CollectionUtils.isNotEmpty(list)){
                    List<Long> projects = list.stream().map(ShareEntity::getProjectId).collect(Collectors.toList());
                    queryParam.getParams().put("projectId", new Parameter(QueryParam.NOT_IN, projects));
                }
            }
        }
        queryParam.getOrderMap().put("createTime","desc");
        IPage<SettingEntity> page = service.queryPage(queryParam,false);

        IPage<SettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        page.getRecords().forEach(vo -> {
            vo.setTaxFlag("0".equals(vo.getTaxFlag())?"是":"否");
            vo.setMaterialCost("0".equals(vo.getMaterialCost())?"出库入成本":"物资合同结算入成本");
        });

        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettingVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
