/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetCostReportMapper;
import com.ejianc.business.budget.service.IBudgetCostReportService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.utils.DecimalUtils;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetCostReportVO;
import com.ejianc.business.budget.vo.comparator.BudgetCostReportDetailComparatoeVO;
import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetCostReportService")
public class BudgetCostReportServiceImpl
extends BaseServiceImpl<BudgetCostReportMapper, BudgetCostReportDetailVO>
implements IBudgetCostReportService {
    @Autowired
    private IBudgetProjectService budgetService;

    @Override
    public CommonResponse<BudgetCostReportVO> queryReport(Long projectId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BudgetProjectEntity::getProjectId, (Object)projectId);
        lambda.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BudgetProjectEntity::getBillState, (Object)1)).or()).eq(BudgetProjectEntity::getBillState, (Object)3));
        BudgetProjectEntity budgetEntity = (BudgetProjectEntity)((Object)this.budgetService.getOne((Wrapper)lambda));
        BudgetCostReportVO vo = new BudgetCostReportVO();
        vo.setProjectId(projectId);
        List<BudgetCostReportDetailVO> detailList = ((BudgetCostReportMapper)this.baseMapper).getBudgetCostReport(projectId);
        Collections.sort(detailList, new BudgetCostReportDetailComparatoeVO());
        BigDecimal costMny = null;
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (BudgetCostReportDetailVO detail : detailList) {
                if (!detail.getLeafFlag().equals(1)) continue;
                costMny = DecimalUtils.add(costMny, (BigDecimal)detail.getCostMny());
                detail.setBudgetCostMny(DecimalUtils.subtractNull((BigDecimal)detail.getBudgetMny(), (BigDecimal)detail.getCostMny()));
            }
            vo.setBudgetMny(budgetEntity != null ? budgetEntity.getBudgetMny() : null);
            vo.setCostMny(costMny);
            vo.setProjectName(detailList.get(0).getProjectName());
            List treeList = TreeNodeBUtil.buildTree(detailList);
            for (BudgetCostReportDetailVO child : treeList) {
                this.dealChildList(child);
            }
            vo.setDetailList(treeList);
        }
        return CommonResponse.success((Object)vo);
    }

    private void dealChildList(BudgetCostReportDetailVO vo) {
        BigDecimal budgetMny = null;
        BigDecimal costMny = null;
        if (CollectionUtils.isNotEmpty((Collection)vo.getChildren())) {
            List list = BeanMapper.mapList((Iterable)vo.getChildren(), BudgetCostReportDetailVO.class);
            for (BudgetCostReportDetailVO child : list) {
                this.dealChildList(child);
                budgetMny = DecimalUtils.add(budgetMny, (BigDecimal)child.getBudgetMny());
                costMny = DecimalUtils.add(costMny, (BigDecimal)child.getCostMny());
            }
            vo.setBudgetMny(budgetMny);
            vo.setCostMny(costMny);
            vo.setBudgetCostMny(DecimalUtils.subtractNull(budgetMny, costMny));
            vo.setChildren(BeanMapper.mapList((Iterable)list, ITreeNodeB.class));
        }
    }
}

