/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.mapper.BudgetProjectHistoryMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectHistoryService")
public class BudgetProjectHistoryServiceImpl
extends BaseServiceImpl<BudgetProjectHistoryMapper, BudgetProjectHistoryEntity>
implements IBudgetProjectHistoryService {
    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectService budgetService;

    @Override
    public BudgetProjectHistoryVO queryDetailByChangeId(Long id) {
        BudgetProjectHistoryEntity historyEntity = (BudgetProjectHistoryEntity)((Object)((BudgetProjectHistoryMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().eq((Object)"change_id", (Object)id)));
        if (historyEntity != null) {
            BudgetProjectHistoryVO historyVo = (BudgetProjectHistoryVO)BeanMapper.map((Object)((Object)historyEntity), BudgetProjectHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter("eq", (Object)historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List historyDetailEntities = this.historyDetailService.queryList(queryParam, false);
            if (historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List detailVos = BeanMapper.mapList((Iterable)historyDetailEntities, BudgetProjectDetailHistoryVO.class);
                Collections.sort(detailVos, new BudgetDetailHistoryComparatoeVo());
                for (BudgetProjectDetailHistoryVO cdEntity : detailVos) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree((List)detailVos));
            }
            return historyVo;
        }
        return null;
    }

    @Override
    public BudgetProjectChangeVO queryChange(Long budgetId) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        BudgetProjectHistoryEntity changeEntity = (BudgetProjectHistoryEntity)((Object)((BudgetProjectHistoryMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"budget_id", (Object)budgetId)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"change_version")).last("limit 1")));
        if (null != changeEntity) {
            Map map = ((BudgetProjectHistoryEntity)((Object)this.selectById(changeEntity.getId()))).getCheckList().stream().collect(Collectors.toMap(BudgetProjectDetailHistoryEntity::getBudgetDetailId, Function.identity(), (key1, key2) -> key1));
            BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetService.selectById(budgetId));
            BudgetProjectChangeVO changeVO = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
            changeVO.setBeforeChangeBudgetMny(changeEntity.getBudgetMny());
            for (BudgetProjectDetailChangeVO detailVO : changeVO.getCheckList()) {
                BudgetProjectDetailHistoryEntity projectDetailEntity = (BudgetProjectDetailHistoryEntity)((Object)map.get(detailVO.getId()));
                if (null != projectDetailEntity) {
                    detailVO.setBeforeChangeCode(projectDetailEntity.getCode());
                    detailVO.setBeforeChangeName(projectDetailEntity.getName());
                    detailVO.setBeforeChangeProjectFeature(projectDetailEntity.getProjectFeature());
                    detailVO.setBeforeChangeUnit(projectDetailEntity.getUnit());
                    detailVO.setBeforeChangeNum(projectDetailEntity.getNum());
                    detailVO.setBeforeChangePrice(projectDetailEntity.getPrice());
                    detailVO.setBeforeChangeMny(projectDetailEntity.getMny());
                    if (!(this.nullToTrim(detailVO.getBeforeChangeCode()).equals(this.nullToTrim(detailVO.getCode())) && this.nullToTrim(detailVO.getBeforeChangeName()).equals(this.nullToTrim(detailVO.getName())) && this.nullToTrim(detailVO.getBeforeChangeProjectFeature()).equals(this.nullToTrim(detailVO.getProjectFeature())) && this.nullToTrim(detailVO.getBeforeChangeUnit()).equals(this.nullToTrim(detailVO.getUnit())) && ComputeUtil.equals((BigDecimal)detailVO.getBeforeChangeNum(), (BigDecimal)detailVO.getNum()) && ComputeUtil.equals((BigDecimal)detailVO.getBeforeChangePrice(), (BigDecimal)detailVO.getPrice()) && ComputeUtil.equals((BigDecimal)detailVO.getBeforeChangeMny(), (BigDecimal)detailVO.getMny()))) {
                        detailVO.setChangeFlag(Boolean.valueOf(true));
                        continue;
                    }
                    detailVO.setChangeFlag(Boolean.valueOf(false));
                    continue;
                }
                detailVO.setChangeFlag(Boolean.valueOf(true));
            }
            changeVO.setCheckList(TreeNodeBUtil.buildTree((List)changeVO.getCheckList()));
            return changeVO;
        }
        return null;
    }

    private String nullToTrim(String source) {
        if (null == source) {
            return "";
        }
        return source;
    }
}

