package com.ejianc.business.budget.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目预算变更清单明细
 *
 * @author generator
 *
 */
 @TableName("ejc_budget_project_detail_change_pro")
public class BudgetProjectDetailChangeProEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="budget_id")
    private Long budgetId; // 预算主键
    @TableField(value="budget_detail_id")
    private Long budgetDetailId; // 原始子表主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="code")
    private String code; // 清单编号
    @TableField(value="parent_id")
    private Long parentId; // parent_id
    @TableField(value="name")
    private String name; // 清单名称
    @TableField(value="category_id")
    private Long categoryId; // 分类id
    @TableField(value="category_name")
    private String categoryName; // 分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="cost_type")
    private Integer costType; // 费用类型
    @TableField(value="cost_type_name")
    private String costTypeName; // 费用类型名称
    @TableField(value="spec")
    private String spec; // 特征/规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 工程量
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 综合单价（含税）
    @TableField(value="price")
    private BigDecimal price; // 综合单价（无税）
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @TableField(value="labor_tax_mny_cost")
    private BigDecimal laborTaxMnyCost; // 人工费（含税）
    @TableField(value="labor_mny_cost")
    private BigDecimal laborMnyCost; // 人工费(无税)
    @TableField(value="material_tax_mny_cost")
    private BigDecimal materialTaxMnyCost; // 材料费（含税）
    @TableField(value="material_mny_cost")
    private BigDecimal materialMnyCost; // 材料费（无税）
    @TableField(value="mechanical_tax_mny_cost")
    private BigDecimal mechanicalTaxMnyCost; // 机械费(含税)
    @TableField(value="mechanical_mny_cost")
    private BigDecimal mechanicalMnyCost; // 机械费（无税）
    @TableField(value="indirection_tax_mny_cost")
    private BigDecimal indirectionTaxMnyCost; // 间接费用(含税)
    @TableField(value="indirection_mny_cost")
    private BigDecimal indirectionMnyCost; // 间接费用（无税）
    @TableField(value="major_tax_mny_cost")
    private BigDecimal majorTaxMnyCost; // 专业费（含税）
    @TableField(value="major_mny_cost")
    private BigDecimal majorMnyCost; // 专业费（无税）
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 合价(含税)
    @TableField(value="mny")
    private BigDecimal mny; // 合价(无税)
    @TableField(value="leaf_flag")
    private Integer leafFlag; // 是否末级
    @TableField(value="lock_num")
    private BigDecimal lockNum; // 占用数量
    @TableField(value="lock_mny")
    private BigDecimal lockMny; // 占用金额(无税)
    @TableField(value="lock_tax_mny")
    private BigDecimal lockTaxMny; // 占用金额(含税)
    @TableField(value="budget_change_id")
    private Long budgetChangeId; // 变更主表id
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目id
    @TableField(value="subject_name")
    private String subjectName; // 成本科目
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    @TableField(value="loss_rate")
    private BigDecimal lossRate; // 材料耗率
    @TableField(value="brand_id")
    private Long brandId; // 品牌
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="guide_price")
    private BigDecimal guidePrice; // 指导价
    @TableField(value="compete_factor")
    private BigDecimal competeFactor; // 竞聘系数

    @TableField(value="source_id")
    private Long sourceId; // 来源ID


    @TableField(value="budget_type")
    private Integer budgetType; // 预算类型：0-中标预算1-施工图预算2-结算预算3-变更4-签证5-索赔6-其他

    @TableField(value="source_detail_id")
    private Long sourceDetailId; // 来源子表ID
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型1-费用类型档案

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }


    public BigDecimal getCompeteFactor() {
        return competeFactor;
    }

    public void setCompeteFactor(BigDecimal competeFactor) {
        this.competeFactor = competeFactor;
    }

    public BigDecimal getLossRate() {
        return lossRate;
    }

    public void setLossRate(BigDecimal lossRate) {
        this.lossRate = lossRate;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }



    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }


    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    public BigDecimal getLaborTaxMnyCost() {
        return laborTaxMnyCost;
    }

    public void setLaborTaxMnyCost(BigDecimal laborTaxMnyCost) {
        this.laborTaxMnyCost = laborTaxMnyCost;
    }
    public BigDecimal getLaborMnyCost() {
        return laborMnyCost;
    }

    public void setLaborMnyCost(BigDecimal laborMnyCost) {
        this.laborMnyCost = laborMnyCost;
    }
    public BigDecimal getMaterialTaxMnyCost() {
        return materialTaxMnyCost;
    }

    public void setMaterialTaxMnyCost(BigDecimal materialTaxMnyCost) {
        this.materialTaxMnyCost = materialTaxMnyCost;
    }
    public BigDecimal getMaterialMnyCost() {
        return materialMnyCost;
    }

    public void setMaterialMnyCost(BigDecimal materialMnyCost) {
        this.materialMnyCost = materialMnyCost;
    }
    public BigDecimal getMechanicalTaxMnyCost() {
        return mechanicalTaxMnyCost;
    }

    public void setMechanicalTaxMnyCost(BigDecimal mechanicalTaxMnyCost) {
        this.mechanicalTaxMnyCost = mechanicalTaxMnyCost;
    }
    public BigDecimal getMechanicalMnyCost() {
        return mechanicalMnyCost;
    }

    public void setMechanicalMnyCost(BigDecimal mechanicalMnyCost) {
        this.mechanicalMnyCost = mechanicalMnyCost;
    }
    public BigDecimal getIndirectionTaxMnyCost() {
        return indirectionTaxMnyCost;
    }

    public void setIndirectionTaxMnyCost(BigDecimal indirectionTaxMnyCost) {
        this.indirectionTaxMnyCost = indirectionTaxMnyCost;
    }
    public BigDecimal getIndirectionMnyCost() {
        return indirectionMnyCost;
    }

    public void setIndirectionMnyCost(BigDecimal indirectionMnyCost) {
        this.indirectionMnyCost = indirectionMnyCost;
    }

    public BigDecimal getMajorTaxMnyCost() {
        return majorTaxMnyCost;
    }

    public void setMajorTaxMnyCost(BigDecimal majorTaxMnyCost) {
        this.majorTaxMnyCost = majorTaxMnyCost;
    }

    public BigDecimal getMajorMnyCost() {
        return majorMnyCost;
    }

    public void setMajorMnyCost(BigDecimal majorMnyCost) {
        this.majorMnyCost = majorMnyCost;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Integer getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }
    public BigDecimal getLockNum() {
        return lockNum;
    }

    public void setLockNum(BigDecimal lockNum) {
        this.lockNum = lockNum;
    }
    public BigDecimal getLockMny() {
        return lockMny;
    }

    public void setLockMny(BigDecimal lockMny) {
        this.lockMny = lockMny;
    }
    public BigDecimal getLockTaxMny() {
        return lockTaxMny;
    }

    public void setLockTaxMny(BigDecimal lockTaxMny) {
        this.lockTaxMny = lockTaxMny;
    }
    public Long getBudgetChangeId() {
        return budgetChangeId;
    }

    public void setBudgetChangeId(Long budgetChangeId) {
        this.budgetChangeId = budgetChangeId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
}
