package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.mapper.QuotaDetailMapper;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.vo.QuotaDetailVO;
import com.ejianc.business.budget.vo.QuotaImportVO;
import com.ejianc.business.budget.vo.QuotaMatVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定额库明细表
 *
 * @author generator
 */
@Service("quotaDetailService")
public class QuotaDetailServiceImpl extends BaseServiceImpl<QuotaDetailMapper, QuotaDetailEntity> implements IQuotaDetailService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public CommonResponse<JSONObject> execlImport(HttpServletRequest request) {
        Long quotaId = Long.valueOf(request.getParameter("quotaId"));
        Long quotaTypeId = Long.valueOf(request.getParameter("quotaTypeId"));
        logger.info("开始导入--" + quotaId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<QuotaImportVO> allSuccessList = new ArrayList<>();
        List<QuotaImportVO> successList = new ArrayList<>();
        List<QuotaImportVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    if (StringUtils.isNotEmpty(datas.get(5))) {
                        materialCodeList.add(datas.get(5));//取材料编码
                    }
                }
                if (CollectionUtils.isNotEmpty(materialCodeList)) {
                    CommonResponse<List<MaterialVO>> materialRes = materialApi.queryMaterialsByCodes(materialCodeList);
                    if (!materialRes.isSuccess()) {
                        return CommonResponse.error(materialRes.getMsg());
                    }
                    logger.info("材料信息--" + JSONObject.toJSONString(materialRes.getData()));
                    map = materialRes.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (oldValue, newValue) -> newValue));
                    logger.info("材料map信息--" + JSONObject.toJSONString(map));
                }

                Long lastDetailId = null;
                for (int i = 1; i < result.size(); i++) {
                    StringBuffer errMsg = new StringBuffer();
                    boolean errflag = false;
                    List<String> datas = result.get(i);
                    QuotaImportVO importVO = new QuotaImportVO();
                    importVO.setMatFlag(false);
                    importVO.setId(IdWorker.getId());
                    importVO.setQuotaId(quotaId);
                    importVO.setQuotaTypeId(quotaTypeId);
                    String quotaDetailCode = datas.get(0);
                    //编码为空
                    if (StringUtils.isEmpty(quotaDetailCode)) {
                        //没有读取到定额
                        if (lastDetailId == null) {
                            errMsg.append("定额编码不能为空,");
                            errflag = true;
                        }
                        //有定额说明是主材，放到最近的定额子表
                        else {
                            importVO.setMatFlag(true);
                        }
                    } else {
                        importVO.setDetailCode(quotaDetailCode);
                    }

                    if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                        String detailName = datas.get(1);
                        if (StringUtils.isEmpty(detailName)) {
                            errMsg.append("定额名称不能为空,");
                            errflag = true;
                        } else {
                            importVO.setDetailName(detailName);
                        }

                        String description = datas.get(2);
                        if (StringUtils.isEmpty(description)) {
                            errMsg.append("特征描述不能为空,");
                            errflag = true;
                        } else {
                            importVO.setDescription(description);
                        }

                        importVO.setDetailUnit(datas.get(3));

                        String laborPrice = datas.get(4);
                        if (StringUtils.isEmpty(laborPrice)) {
                            errMsg.append("劳务单价不能为空,");
                            errflag = true;
                        } else {
                            try {
                                importVO.setLaborPrice(StringUtils.isNotBlank(laborPrice) ? new BigDecimal(laborPrice) : null);
                            } catch (Exception e) {
                                errMsg.append("劳务单价格式错误,");
                                errflag = true;
                            }
                        }
                    }

                    QuotaImportVO importMatVO = null;
                    String materialCode = datas.get(5);
                    if (BooleanUtils.isTrue(importVO.getMatFlag()) && StringUtils.isBlank(materialCode)) {
                        errMsg.append("材料编码不能为空,");
                        errflag = true;
                    } else if (StringUtils.isNotBlank(materialCode)) {
                        MaterialVO materialVO = map.get(materialCode);
                        if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                            importMatVO = new QuotaImportVO();
                            importMatVO.setMatFlag(true);
                            importMatVO.setId(IdWorker.getId());
                            importMatVO.setQuotaId(quotaId);
                            importMatVO.setQuotaTypeId(quotaTypeId);
                            if (materialVO != null) {
                                importMatVO.setQuotaDetailId(importVO.getId());
                                importMatVO.setMaterialId(materialVO.getId());
                                importMatVO.setMaterialCode(materialVO.getCode());
                                importMatVO.setMaterialName(materialVO.getName());
                                importMatVO.setMaterialUnit(materialVO.getUnitName());
                                importMatVO.setMaterialSpec(materialVO.getSpec());
                                importMatVO.setCategoryId(materialVO.getCategoryId());
                                importMatVO.setCategoryName(materialVO.getCategoryName());
                            } else {
                                errMsg.append("材料编码未匹配到物料,");
                                errflag = true;
                            }

                            try {
                                String lossRate = datas.get(8);
                                importMatVO.setLossRate(StringUtils.isNotBlank(lossRate) ? new BigDecimal(lossRate) : null);
                            } catch (Exception e) {
                                errMsg.append("主材耗损率格式错误,");
                                errflag = true;
                            }

                            try {
                                String convertRate = datas.get(10);
                                importMatVO.setConvertRate(StringUtils.isNotBlank(convertRate) ? new BigDecimal(convertRate) : null);
                            } catch (Exception e) {
                                errMsg.append("换算率格式错误,");
                                errflag = true;
                            }
                        } else {
                            if (materialVO != null) {
                                importVO.setQuotaDetailId(lastDetailId);
                                importVO.setMaterialId(materialVO.getId());
                                importVO.setMaterialCode(materialVO.getCode());
                                importVO.setMaterialName(materialVO.getName());
                                importVO.setMaterialUnit(materialVO.getUnitName());
                                importVO.setMaterialSpec(materialVO.getSpec());
                                importVO.setCategoryId(materialVO.getCategoryId());
                                importVO.setCategoryName(materialVO.getCategoryName());
                            } else {
                                errMsg.append("材料编码未匹配到物料,");
                                errflag = true;
                            }
                        }
                        try {
                            String lossRate = datas.get(8);
                            importVO.setLossRate(StringUtils.isNotBlank(lossRate) ? new BigDecimal(lossRate) : null);
                        } catch (Exception e) {
                            errMsg.append("主材耗损率格式错误,");
                            errflag = true;
                        }

                        try {
                            String convertRate = datas.get(10);
                            importVO.setConvertRate(StringUtils.isNotBlank(convertRate) ? new BigDecimal(convertRate) : null);
                        } catch (Exception e) {
                            errMsg.append("换算率格式错误,");
                            errflag = true;
                        }
                    }

                    if (errflag) {
                        importVO.setErrorMsg(errMsg.substring(0, errMsg.length() - 1));
                        errorList.add(importVO);
                    } else {
                        successList.add(importVO);
                        allSuccessList.add(importVO);
                        if (null != importMatVO) {
                            allSuccessList.add(importMatVO);
                        }
                    }
                    if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                        lastDetailId = importVO.getId();
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        if (CollectionUtils.isEmpty(errorList)) {
            List<QuotaDetailVO> detailVOS = new ArrayList<>();
            List<QuotaMatVO> matVOS = new ArrayList<>();
            Map<Long, List<String>> matNameMap = new HashMap<>();
            for (QuotaImportVO importVO : allSuccessList) {
                if (BooleanUtils.isFalse(importVO.getMatFlag())) {
                    QuotaDetailVO detailVO = BeanMapper.map(importVO, QuotaDetailVO.class);
                    detailVOS.add(detailVO);
                } else {
                    QuotaMatVO matVO = BeanMapper.map(importVO, QuotaMatVO.class);
                    matVOS.add(matVO);
                    List<String> matStrList = matNameMap.containsKey(matVO.getQuotaDetailId()) ? matNameMap.get(matVO.getQuotaDetailId()) : new ArrayList<>();
                    matStrList.add(matVO.getMaterialName());
                    matNameMap.put(matVO.getQuotaDetailId(), matStrList);
                }
            }
            for (QuotaDetailVO detailVO : detailVOS) {
                if (matNameMap.containsKey(detailVO.getId())) {
                    List<String> stringList = matNameMap.get(detailVO.getId());
                    detailVO.setMatName(StringUtils.join(stringList, ","));
                }
            }
            List<QuotaDetailEntity> resList = BeanMapper.mapList(detailVOS, QuotaDetailEntity.class);
            saveBatch(resList);
            List<QuotaMatEntity> matEntities = BeanMapper.mapList(matVOS, QuotaMatEntity.class);
            quotaMatService.saveBatch(matEntities);
        }
        return CommonResponse.success("导入成功！", json);
    }

}
