package com.ejianc.business.cost.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.CostDocumentsDetailEntity;
import com.ejianc.business.cost.bean.CostDocumentsEntity;
import com.ejianc.business.cost.service.ICostDocumentsDetailService;
import com.ejianc.business.cost.service.ICostDocumentsService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/costDocuments/")
public class CostDocumentsApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICostDocumentsService costDocumentsService;
    @Autowired
    private ICostDocumentsDetailService documentsDetailService;

    @GetMapping(value = "queryFeeMny")
    public CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "feeTypeId") Long feeTypeId) {
        BigDecimal result = BigDecimal.ZERO;
        LambdaQueryWrapper<CostDocumentsEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CostDocumentsEntity::getProjectId, projectId);
        queryWrapper.in(CostDocumentsEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CostDocumentsEntity> entities = costDocumentsService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            List<Long> idList = entities.stream().map(CostDocumentsEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<CostDocumentsDetailEntity> query = Wrappers.lambdaQuery();
            query.eq(CostDocumentsDetailEntity::getCostType, feeTypeId);
            query.in(CostDocumentsDetailEntity::getDocumentsId, idList);
            List<CostDocumentsDetailEntity> infoEntities = documentsDetailService.list(query);
            if (CollectionUtils.isNotEmpty(infoEntities)) {
                result =  infoEntities.stream().map(CostDocumentsDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return CommonResponse.success("查询成功!", result);
    }
}
