/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.vo.QuotaDetailVO;
import com.ejianc.business.budget.vo.QuotaMatVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"quotaDetail"})
public class QuotaDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IQuotaDetailService service;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private IQuotaService quotaService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotaDetailVO> saveOrUpdate(@RequestBody QuotaDetailVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QuotaDetailEntity::getQuotaId, (Object)saveOrUpdateVO.getQuotaId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaDetailEntity::getDetailCode, (Object)StringUtils.trim((String)saveOrUpdateVO.getDetailCode()));
        if (this.service.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d,\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        QuotaDetailEntity entity = (QuotaDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, QuotaDetailEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getMatList())) {
            List nameList = entity.getMatList().stream().filter(x -> !"del".equals(x.getRowState())).map(QuotaMatEntity::getMaterialName).collect(Collectors.toList());
            entity.setMatName(StringUtils.join(nameList, (String)","));
        }
        this.service.saveOrUpdate((Object)entity, false);
        QuotaDetailVO vo = (QuotaDetailVO)BeanMapper.map((Object)((Object)entity), QuotaDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuotaDetailVO> queryDetail(Long id) {
        QuotaDetailEntity entity = (QuotaDetailEntity)((Object)this.service.selectById(id));
        QuotaDetailVO vo = (QuotaDetailVO)BeanMapper.map((Object)((Object)entity), QuotaDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaDetailVO> vos) {
        List longs = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BudgetSetQuotaEntity::getQuotaId, longs);
        if (this.budgetSetQuotaService.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u6240\u9009\u5b9a\u989d\u5e93\u88ab[\u6e05\u5355\u5b9a\u989d\u5173\u7cfb\u8bbe\u7f6e]\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BudgetProjectDetailProEntity::getSourceId, longs);
        if (this.budgetProjectDetailProService.count((Wrapper)wrapper) > 0) {
            throw new BusinessException("\u6240\u9009\u5b9a\u989d\u5e93\u88ab[\u76ee\u6807\u6210\u672c]\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        this.service.removeByIds(longs, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotaDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("QuotaDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuotaDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailVO>> refQuotaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("detailCode", "detailName", "description"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long quotaTypeId = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            quotaTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("quotaTypeId", new Parameter("eq", (Object)quotaTypeId));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"quotaTypeId")) {
            quotaTypeId = Long.valueOf(String.valueOf(_con.get((Object)"quotaTypeId")));
            param.getParams().put("quotaTypeId", new Parameter("eq", (Object)quotaTypeId));
        }
        LambdaQueryWrapper quotaEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getEnableState, (Object)1);
        quotaEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        QuotaEntity quotaEntity = (QuotaEntity)((Object)this.quotaService.getOne((Wrapper)quotaEntityLambdaQueryWrapper, false));
        if (null == quotaEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u542f\u7528\u7684\u5b9a\u989d\u5e93\uff01");
        }
        param.getParams().put("quotaId", new Parameter("eq", (Object)quotaEntity.getId()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List detailVOS = BeanMapper.mapList((Iterable)page.getRecords(), QuotaDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailVOS)) {
            List detailIds = detailVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(QuotaMatEntity::getQuotaDetailId, detailIds);
            List matEntities = this.quotaMatService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)matEntities)) {
                Map<Long, List<QuotaMatEntity>> map = matEntities.stream().collect(Collectors.groupingBy(QuotaMatEntity::getQuotaDetailId));
                Iterator iterator = detailVOS.iterator();
                while (iterator.hasNext()) {
                    QuotaDetailVO detailVO;
                    detailVO.setMatList(map.containsKey((detailVO = (QuotaDetailVO)iterator.next()).getId()) ? BeanMapper.mapList((Iterable)map.get(detailVO.getId()), QuotaMatVO.class) : null);
                }
            }
        }
        pageData.setRecords(detailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"QuotaDetail-import.xlsx", (String)"\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.execlImport(request);
    }
}

