/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.SchemeEntity;
import com.ejianc.business.cost.bean.SchemeOtherEntity;
import com.ejianc.business.cost.service.ISchemeOtherService;
import com.ejianc.business.cost.service.ISchemeService;
import com.ejianc.business.cost.vo.SchemeOtherVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"schemeOther"})
public class SchemeOtherController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISchemeService schemeService;
    @Autowired
    private ISchemeOtherService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SchemeOtherVO> saveOrUpdate(@RequestBody SchemeOtherVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SchemeOtherEntity entity = (SchemeOtherEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SchemeOtherEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SchemeOtherVO vo = (SchemeOtherVO)BeanMapper.map((Object)((Object)entity), SchemeOtherVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemeOtherVO> queryDetail(Long id) {
        SchemeOtherEntity entity = (SchemeOtherEntity)((Object)this.service.selectById(id));
        SchemeOtherVO vo = (SchemeOtherVO)BeanMapper.map((Object)((Object)entity), SchemeOtherVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeOtherVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SchemeOtherVO schemeOtherVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeOtherVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeOtherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SchemeOther-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSchemeOtherData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SchemeOtherVO>> refSchemeOtherData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeOtherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refFeeWithSchemeOther"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SchemeOtherVO>> refFeeWithSchemeOther(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        CommonResponse response = this.defdocApi.getDefDocDetailByDefCodeAndTenantId("indirect-costType", InvocationInfoProxy.getTenantid());
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List<SchemeOtherVO> result = new ArrayList<SchemeOtherVO>();
            for (DefdocDetailVO detailVO : (List)response.getData()) {
                if (!StringUtils.isEmpty((CharSequence)searchText) && !detailVO.getName().contains(searchText)) continue;
                SchemeOtherVO otherVO = new SchemeOtherVO();
                otherVO.setId(detailVO.getId());
                otherVO.setFeeCode(detailVO.getCode());
                otherVO.setOtherFeeName(detailVO.getName());
                otherVO.setAttrName(detailVO.getAttrName());
                result.add(otherVO);
            }
            int total = result.size();
            result = this.getPaginatedList(result, pageNumber, pageSize);
            if (StringUtils.isNotEmpty((CharSequence)condition) && JSONObject.parseObject((String)condition).containsKey((Object)"projectId") && CollectionUtils.isNotEmpty(result)) {
                Long projectId = JSONObject.parseObject((String)condition).getLong("projectId");
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(SchemeEntity::getProjectId, (Object)projectId);
                queryWrapper.in(SchemeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List list = this.schemeService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    LambdaQueryWrapper query = Wrappers.lambdaQuery();
                    query.eq(SchemeOtherEntity::getPid, (Object)((SchemeEntity)((Object)list.get(0))).getId());
                    List otherEntities = this.service.list((Wrapper)query);
                    Map<Long, BigDecimal> map = otherEntities.stream().filter(x -> null != x.getSourceId()).collect(Collectors.toMap(SchemeOtherEntity::getSourceId, SchemeOtherEntity::getOtherMny, (x1, x2) -> x1));
                    for (SchemeOtherVO otherVO : result) {
                        otherVO.setOtherMny(map.get(otherVO.getId()));
                    }
                }
                Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), (long)total);
                pageData.setPages((long)((total + pageSize - 1) / pageSize));
                pageData.setRecords(result);
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L));
    }

    private List<SchemeOtherVO> getPaginatedList(List<SchemeOtherVO> list, int pageNumber, int pageSize) {
        if (pageSize <= 0 || pageNumber <= 0) {
            throw new IllegalArgumentException("pageSize and pageNumber must be greater than 0.");
        }
        int fromIndex = (pageNumber - 1) * pageSize;
        if (list == null || list.size() <= fromIndex) {
            return new ArrayList<SchemeOtherVO>();
        }
        int toIndex = Math.min(fromIndex + pageSize, list.size());
        return list.subList(fromIndex, toIndex);
    }
}

