/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.bean.QuotaTypeEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.service.IQuotaTypeService;
import com.ejianc.business.budget.vo.QuotaTypeVO;
import com.ejianc.business.budget.vo.QuotaVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"quota"})
public class QuotaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaService service;
    @Autowired
    private IQuotaTypeService quotaTypeService;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotaVO> saveOrUpdate(@RequestBody QuotaVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/copySave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotaVO> copySave(@RequestBody QuotaVO quotaVO) {
        return CommonResponse.success((String)"\u590d\u5236\u5355\u636e\u6210\u529f\uff01", (Object)this.service.copySave(quotaVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuotaVO> queryDetail(Long id) {
        QuotaEntity entity = (QuotaEntity)((Object)this.service.selectById(id));
        QuotaVO vo = (QuotaVO)BeanMapper.map((Object)((Object)entity), QuotaVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaVO> vos) {
        List mainIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.in(QuotaDetailEntity::getQuotaId, mainIds);
        List detailIds = null;
        List list = this.quotaDetailService.list((Wrapper)qry);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            detailIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BudgetSetQuotaEntity::getQuotaId, detailIds);
            if (this.budgetSetQuotaService.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u6240\u9009\u5b9a\u989d\u5e93\u88ab[\u6e05\u5355\u5b9a\u989d\u5173\u7cfb\u8bbe\u7f6e]\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BudgetProjectDetailProEntity::getSourceId, detailIds);
            if (this.budgetProjectDetailProService.count((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u6240\u9009\u5b9a\u989d\u5e93\u88ab[\u76ee\u6807\u6210\u672c]\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
        }
        this.service.removeByIds(mainIds, true);
        if (CollectionUtils.isNotEmpty(detailIds)) {
            this.quotaDetailService.removeByIds(detailIds, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuotaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id ", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quota-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuotaData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<QuotaTypeVO> refQuotaData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List resList;
        List typeList = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(QuotaEntity::getEnableState, (Object)1);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        QuotaEntity quotaEntity = (QuotaEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        if (null == quotaEntity) {
            return typeList;
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(QuotaTypeEntity::getQuotaId, (Object)quotaEntity.getId());
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            lambda.like(QuotaTypeEntity::getQuotaName, (Object)searchText);
        }
        if (CollectionUtils.isNotEmpty((Collection)(resList = this.quotaTypeService.list((Wrapper)lambda)))) {
            typeList = BeanMapper.mapList((Iterable)resList, QuotaTypeVO.class);
            typeList.forEach(e -> {
                e.setCode(e.getQuotaName());
                e.setName(e.getQuotaName());
            });
        }
        return typeList;
    }

    @RequestMapping(value={"/updateEnable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateEnable(Long id, Boolean enableState) {
        if (enableState.booleanValue()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.ne(BaseEntity::getId, (Object)id);
            queryWrapper.eq(QuotaEntity::getEnableState, (Object)1);
            QuotaEntity quotaEntity = (QuotaEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
            if (null != quotaEntity) {
                quotaEntity.setEnableState(0);
                this.service.saveOrUpdate((Object)quotaEntity);
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(QuotaEntity::getEnableState, (Object)enableState);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u542f\u7528\u505c\u7528\u6210\u529f\uff01");
    }
}

