/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetProjectChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChangeService")
public class BudgetProjectChangeServiceImpl
extends BaseServiceImpl<BudgetProjectChangeMapper, BudgetProjectChangeEntity>
implements IBudgetProjectChangeService {
    private static final String BILL_CODE_ROLE = "BUDGET_PRO_CHANGE_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectDetailChangeService changeDetailService;
    @Autowired
    private IBudgetProjectService budgetService;
    @Autowired
    private BudgetProjectMapper budgetMapper;
    @Autowired
    private IBudgetProjectDetailService detailsService;
    @Autowired
    private BudgetProjectChangeMapper changeMapper;

    @Override
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(BudgetProjectChangeVO changeVo) {
        BudgetProjectDetailChangeEntity detailslist;
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetProjectChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = (BudgetProjectChangeEntity)((Object)BeanMapper.map((Object)changeVo, BudgetProjectChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(Integer.valueOf(1));
            } else {
                changeVo.setChangeVersion(Integer.valueOf(changeVo.getChangeVersion() + 1));
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)changeVo.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    changeVo.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (BudgetProjectChangeEntity)((Object)BeanMapper.map((Object)changeVo, BudgetProjectChangeEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        List detailsVos = changeVo.getCheckList();
        ArrayList<BudgetProjectDetailChangeEntity> saveOrUpldates = new ArrayList<BudgetProjectDetailChangeEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        if (operateType.equals("add")) {
            for (Object detailsVo : detailsVos) {
                detailslist = (BudgetProjectDetailChangeEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailChangeEntity.class));
                detailslist.setBudgetChangeId(entity.getId());
                detailslist.setBudgetId(entity.getBudgetId());
                detailslist.setBudgetDetailId(detailsVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(detailsVo.getMny());
                detailslist.setBeforeChangePrice(detailsVo.getPrice());
                detailslist.setBeforeChangeNum(detailsVo.getNum());
                detailslist.setBeforeChangeLaborCost(detailsVo.getLaborCost());
                detailslist.setBeforeChangeMaterialCost(detailsVo.getMechanicalCost());
                detailslist.setBeforeChangeMechanicalCost(detailsVo.getMechanicalCost());
                detailslist.setBeforeChangeOtherCost(detailsVo.getOtherCost());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (Object detailsVo : detailsVos) {
                if ("add".equals(detailsVo.getRowState())) {
                    detailslist = (BudgetProjectDetailChangeEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailChangeEntity.class));
                    detailslist.setBudgetChangeId(entity.getId());
                    detailslist.setBudgetId(entity.getBudgetId());
                    detailslist.setBudgetDetailId(detailsVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if ("edit".equals(detailsVo.getRowState())) {
                    detailslist = (BudgetProjectDetailChangeEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailChangeEntity.class));
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if (!"del".equals(detailsVo.getRowState())) continue;
                deleteIds.add(detailsVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            this.changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetProjectDetailChangeEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailChangeEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            List resultMapList = BeanMapper.mapList(saveOrUpldates, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> listCodeDate = this.creatCode(treeData, null);
            ArrayList<BudgetProjectDetailChangeEntity> entities = new ArrayList<BudgetProjectDetailChangeEntity>();
            this.treeToList(listCodeDate, entities);
            this.changeDetailService.saveOrUpdateBatch(entities, entities.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.changeDetailService.removeByIds(deleteIds, false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetProjectEntity::getChangingBudgetMny, (Object)changeVo.getBudgetMny());
        updateWrapper.set(BudgetProjectEntity::getChangingLaborMny, (Object)changeVo.getLaborMny());
        updateWrapper.set(BudgetProjectEntity::getChangingMaterialMny, (Object)changeVo.getMaterialMny());
        updateWrapper.set(BudgetProjectEntity::getChangingMechanicalMny, (Object)changeVo.getMechanicalMny());
        updateWrapper.set(BudgetProjectEntity::getChangingOtherMny, (Object)changeVo.getOtherMny());
        updateWrapper.set(BudgetProjectEntity::getChangingTotalMny, (Object)changeVo.getTotalMny());
        updateWrapper.set(BudgetProjectEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(BudgetProjectEntity::getChangeStatus, (Object)2);
        updateWrapper.set(BudgetProjectEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBudgetId());
        this.budgetService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            String key = (ypd.get("code") == null ? "" : ypd.get("code")) + ":" + ypd.get("name");
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + key);
            } else {
                ypd.put("innerCode", key);
            }
            if (ypd.get("children") == null) continue;
            List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("innerCode").toString());
            ypd.put("children", child);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetProjectDetailChangeEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetProjectDetailChangeEntity)((Object)BeanMapper.map(ypd, BudgetProjectDetailChangeEntity.class)));
        }
    }

    @Override
    public BudgetProjectChangeVO queryDetail(Long id) {
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.changeMapper.selectById(id));
        BudgetProjectChangeVO changeVo = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("budget_change_id", new Parameter("eq", (Object)changeVo.getId()));
        List deils = this.changeDetailService.queryList(param);
        List checkList = BeanMapper.mapList((Iterable)deils, BudgetProjectDetailChangeVO.class);
        if (checkList != null && checkList.size() > 0) {
            for (BudgetProjectDetailChangeVO cdEntity : checkList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            changeVo.setCheckList(TreeNodeBUtil.buildTree((List)checkList));
        }
        return changeVo;
    }

    @Override
    public void deleteChange(List<BudgetProjectChangeVO> vos) {
        for (BudgetProjectChangeVO vo : vos) {
            BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(BudgetProjectEntity::getChangingBudgetMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingLaborMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingMaterialMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingMechanicalMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingOtherMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingTotalMny, (Object)BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(BudgetProjectEntity::getChangeStatus, (Object)1);
            } else {
                updateWrapper.set(BudgetProjectEntity::getChangeStatus, (Object)3);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getBudgetId());
            this.budgetService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public BudgetProjectVO queryDetailChange(Long id) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetMapper.selectById(id));
        if (entity != null) {
            BudgetProjectVO contractVo = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budgetId", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (BudgetProjectDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, BudgetProjectDetailVO.class);
                Collections.sort(resultMapList, new BudgetDetailComparatoeVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            contractVo.setBeforeChangeBudgetMny(entity.getBudgetMny());
            contractVo.setBeforeChangeLaborMny(entity.getLaborMny());
            contractVo.setBeforeChangeMaterialMny(entity.getMaterialMny());
            contractVo.setBeforeChangeMechanicalMny(entity.getMechanicalMny());
            contractVo.setBeforeChangeOtherMny(entity.getOtherMny());
            contractVo.setBeforeChangeTotalMny(entity.getTotalMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            return contractVo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = this.changeMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"budget_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"used_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, BudgetProjectChangeVO.class);
            for (BudgetProjectChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }
}

