/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.bean.SettingEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.ProjectReportVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cost/"})
public class CostDetailApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    @RequestMapping(value={"saveCostDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveCostDetail(@RequestBody List<CostDetailVO> list) {
        try {
            this.logger.info("\u6210\u672c\u4fe1\u606f:" + JSONObject.toJSONString(list));
            if (CollectionUtils.isNotEmpty(list)) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(SettingEntity::getProjectId, (Object)list.get(0).getProjectId());
                lambda.in(SettingEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List settingEntityList = this.settingService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)settingEntityList)) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(SubjectEntity::getSettingId, (Object)((SettingEntity)((Object)settingEntityList.get(0))).getId());
                    List subjectEntityList = this.subjectService.list((Wrapper)lambda2);
                    Map<Long, List<SubjectEntity>> map = subjectEntityList.stream().collect(Collectors.groupingBy(BaseEntity::getId));
                    for (CostDetailVO e : list) {
                        if (e.getSubjectId() == null) continue;
                        List<SubjectEntity> subjectEntities = map.get(e.getSubjectId());
                        if (CollectionUtils.isEmpty(subjectEntities)) {
                            return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u7684\u6210\u672c\u8bbe\u7f6e\u4e2d\u6ca1\u6709\u6b64\u6210\u672c\u79d1\u76ee!");
                        }
                        Integer costType = subjectEntities.get(0).getCostType() != null ? subjectEntities.get(0).getCostType() : e.getCostType();
                        e.setCostType(costType);
                        e.setCostTypeName(CostTypeEnum.getEnumByType((Integer)costType).getName());
                    }
                }
                List listres = BeanMapper.mapList(list, CostDetailEntity.class);
                this.costDetailService.deleteCostDetail(((CostDetailEntity)((Object)listres.get(0))).getSourceId());
                this.costDetailService.saveBatch(listres);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u63d2\u5165\u6210\u529f");
    }

    @RequestMapping(value={"deleteCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
        try {
            this.costDetailService.deleteCostDetail(id);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/checkShareFlag"})
    public CommonResponse<String> checkShareFlag(@RequestParam(value="id", required=true) Long id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"source_id", (Object)id);
        objectQueryWrapper.eq((Object)"share_flag", (Object)1);
        int count = this.costDetailService.count((Wrapper)objectQueryWrapper);
        if (count == 0) {
            return CommonResponse.success((String)"\u8be5\u5355\u636e\u6ca1\u6709\u88ab\u6210\u672c\u5206\u644a\uff01");
        }
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u7ecf\u88ab\u6210\u672c\u5206\u644a\uff01");
    }

    @GetMapping(value={"/getCostMonth"})
    public CommonResponse<Map<String, BigDecimal>> getCostMonth(@RequestParam(value="projectId") Long projectId) {
        Map<String, BigDecimal> map = null;
        List<ProjectReportVo> costMonth = this.costDetailService.getCostMonth(projectId);
        if (CollectionUtils.isNotEmpty(costMonth)) {
            map = costMonth.stream().collect(Collectors.toMap(k -> k.getFinishMonth(), k -> k.getMny()));
        }
        return CommonResponse.success((String)"\u6210\u672c\u67e5\u8be2\uff01", map);
    }

    @GetMapping(value={"/getCostTypeAndBudgetMny"})
    public CommonResponse<Map<Integer, BigDecimal>> getCostTypeAndBudgetMny(@RequestParam(value="projectId") Long projectId) {
        HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
        CostAmountVO costAmountVO = this.subjectService.queryCostSumMny(projectId);
        if (!Objects.isNull(costAmountVO)) {
            map.put(1, costAmountVO.getLaborTaxMnyCost());
            map.put(2, costAmountVO.getMaterialTaxMnyCost());
            map.put(3, costAmountVO.getMajorTaxMnyCost());
            map.put(4, costAmountVO.getMechanicalTaxMnyCost());
            map.put(5, costAmountVO.getIndirectionTaxMnyCost());
        }
        QueryWrapper budgetQueryWrapper = new QueryWrapper();
        budgetQueryWrapper.eq((Object)"project_id", (Object)projectId);
        List budgetList = this.budgetProjectProService.list((Wrapper)budgetQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)budgetList)) {
            BudgetProjectProEntity budgetProjectProEntity = (BudgetProjectProEntity)((Object)budgetList.get(0));
            BigDecimal budgetTaxMny = budgetProjectProEntity.getBudgetTaxMny();
            map.put(6, budgetTaxMny);
        }
        return CommonResponse.success((String)"\u6210\u672c\u4e0e\u9884\u7b97\u67e5\u8be2\uff01", map);
    }
}

