package com.ejianc.business.budget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.budget.service.IBudgetProjectChangeProService;

/**
 * 项目预算变更单主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectChangePro")
public class BudgetProjectChangeProController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";//此处需要根据实际修改

    @Autowired
    private IBudgetProjectChangeProService service;
    @Autowired
    private IBudgetProjectProService budgetService;
    @Autowired
    private IBudgetProjectDetailChangeProService detailsService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetProjectService budgetProjectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> saveOrUpdate(@RequestBody BudgetProjectChangeProVO saveOrUpdateVO) {
        String operateType = null;
    	BudgetProjectChangeProEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectChangeProEntity.class);
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            budgetService.beforeSaveCheck(BeanMapper.mapList(entity.getDetailList(), BudgetProjectDetailProEntity.class));
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                operateType = "add";
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<BudgetProjectDetailChangeProEntity> changeDetailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList) && operateType!=null && operateType.equals("add")){
            for (BudgetProjectDetailChangeProEntity changeProEntity : changeDetailList) {
                changeProEntity.setId(null);
            }
        }
        service.saveOrUpdate(entity, false);
        List<BudgetProjectDetailChangeProEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            //维护父子级关系
            Map<String,Long> idMap=new HashMap<>();
            for(BudgetProjectDetailChangeProEntity cdEntity:detailList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(BudgetProjectDetailChangeProEntity cdEntity:detailList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (cdEntity.getBudgetDetailId()==null){
                    cdEntity.setSubjectId(cdEntity.getId());
                }else {
                    cdEntity.setSubjectId(cdEntity.getBudgetDetailId());
                }
                String subjectName=cdEntity.getName();
                if (cdEntity.getMaterialId()!=null){
                    if (StringUtils.isNotEmpty(cdEntity.getSpec())){
                        subjectName= subjectName+" "+"["+cdEntity.getSpec()+"]";
                    }
                }
                cdEntity.setSubjectCode(cdEntity.getCode());
                cdEntity.setSubjectName(subjectName);
                if (cdEntity.getCostType()!=null){
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType(cdEntity.getCostType()).getName());
                }
            }
            entity.setDetailList(detailList);
            detailsService.saveOrUpdateBatch(detailList, detailList.size(),false);
        }
        //回写主表 变更信息
        LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectProEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(BudgetProjectProEntity::getChangeStatus, 2);//状态：变更中
        updateWrapper.set(BudgetProjectProEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.set(BudgetProjectProEntity::getChangeVersion, entity.getVersion());//变更编码
        updateWrapper.eq(BudgetProjectProEntity::getId, entity.getBudgetId());
        budgetService.update(updateWrapper);
        BudgetProjectChangeProVO vo = service.queryDetail(entity.getId());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetail(Long id) {
        BudgetProjectChangeProVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeProVO> vos) {
        List<Long> mainIds = vos.stream().map(BudgetProjectChangeProVO::getId).collect(Collectors.toList());
        List<BudgetProjectChangeProEntity> entities = (List<BudgetProjectChangeProEntity>) service.listByIds(mainIds);
        List<Long> longs = entities.stream().filter(x -> null != x.getSourceId()).map(BudgetProjectChangeProEntity::getSourceId).collect(Collectors.toList());
        List<BudgetProjectEntity> list = (List<BudgetProjectEntity>) budgetProjectService.listByIds(longs);
        if (CollectionUtils.isNotEmpty(list)) {
            for (BudgetProjectEntity entity : list) {
                entity.setTargetId(null);
            }
            budgetProjectService.saveOrUpdateBatch(list);
        }
        if(ListUtil.isNotEmpty(vos)){
            for (BudgetProjectChangeProVO vo : vos) {
                BudgetProjectChangeProEntity budgetProjectChangeProEntity = service.selectById(vo.getId());
                LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(BudgetProjectProEntity::getId, budgetProjectChangeProEntity.getBudgetId());
                if (budgetProjectChangeProEntity.getChangeStatus()==1){
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus,1);
                }else {
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus,3);
                }
                budgetService.update(updateWrapper);
            }
        }
        service.removeByIds(vos.stream().map(BudgetProjectChangeProVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BudgetProjectChangeProEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectChangeProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeProVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectChangeProEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectChangePro-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetProjectChangeProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> refBudgetProjectChangeProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetProjectChangeProEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectChangeProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeProVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 变更新增
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetailChange(@RequestParam Long id) {
        BudgetProjectChangeProVO vo=service.queryDetailChange(id, true);
        return CommonResponse.success(vo);
    }

    @RequestMapping(value = "/checkQuote", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkQuote(@RequestBody List<Long> ids) {
        if(CollectionUtils.isNotEmpty(ids)){
            for (Long billId : ids) {
                CommonResponse<String>  res = billTypeApi.checkQuote("BT202210000001",billId);
                if(res.isSuccess()) {//单据未被下游单据引用
                    return CommonResponse.success();
                }else{
                    return CommonResponse.error(res.getMsg());
                }
            }
        }
        return CommonResponse.success();
    }

}
