package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 项目预算主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectPro")
public class BudgetProjectProController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CODE";

    @Autowired
    private IBudgetProjectProService service;
    @Autowired
    private IBudgetProjectDetailProService detailsService;

    @Autowired
    private ICommonBusinessService budgetProjectPro;
    @Autowired
    private ICommonBusinessService budgetProjectChangePro;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBudgetProjectService budgetProjectService;

    /**
     * @description: 项目预算参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return {@link CommonResponse< IPage< BudgetProjectProVO>>}
     * @author songlx
     * @date: 2024/2/4
     */
    @RequestMapping(value = "/refBudgetProjectPro", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProVO>> refBudgetProjectPro(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "employeeName", "departmentName"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<BudgetProjectProEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectProVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @description: 项目预算明细参照含有完工累计值
     *
     * @author songlx
     * @date: 2024/2/4
     */
    @RequestMapping(value = "/getBudgetProjectDetailProDataAndSum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailProVO>> getBudgetProjectDetailProDataAndSum(@RequestParam Long projectId) {
        List<BudgetProjectDetailProVO> list = service.getBudgetProjectDetailProDataAndSum(projectId);
        for (BudgetProjectDetailProVO vo : list) {
            vo.setTid(vo.getId().toString());
            vo.setTpid(vo.getParentId() != null && vo.getParentId() > 0 ? vo.getParentId().toString() : "");
        }
        //实现排序
        Collections.sort(list, new BudgetDetailProComparatoeVo());
        list = TreeNodeBUtil.buildTree(list);
        return CommonResponse.success("查询预算明细数据成功！", list);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> saveOrUpdate(@RequestBody BudgetProjectProVO saveOrUpdateVO) {
        BudgetProjectProEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectProEntity.class);
        service.beforeSaveCheck(entity.getDetailList());

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, MaterialVO> materialVOMap = new HashMap<>();
            Map<String, MaterialVO> archiveMap = new HashMap<>();
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (null != cdEntity.getCostType() && 2 == cdEntity.getCostType() && cdEntity.getMatchStatus() != null && cdEntity.getMatchStatus() != 1) {
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setCategoryName(cdEntity.getCategoryName());
                    materialVO.setName(cdEntity.getMaterialName());
                    materialVO.setSpec(cdEntity.getSpec());
                    materialVO.setUnitName(cdEntity.getUnit());
                    materialVO.setType(1);
                    //这个地方拼接一个key 用于从返回的数据中取到 档案的相关信息
                    String key = cdEntity.getName() + (cdEntity.getCostType() != null ? cdEntity.getCostType() : "") + cdEntity.getCategoryName() + cdEntity.getSpec() + cdEntity.getUnit();
                    cdEntity.setKey(key);
                    materialVOMap.put(key, materialVO);
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            if (materialVOMap != null) {
                MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(materialVOMap, entity.getId(), entity.getBillCode(), entity.getProjectName(), "目标成本");
                CommonResponse<Map<String, MaterialVO>> listCommonResponse = materialApi.batchInsertArchiveBySourceBill(archiveVO);
                if (listCommonResponse.isSuccess()) {
                    Map<String, MaterialVO> data = listCommonResponse.getData();
                    if (data != null) {
                        archiveMap = data;
                    }
                }
            }
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (archiveMap != null) {
                    MaterialVO materialVO = archiveMap.get(cdEntity.getKey());
                    if (materialVO != null) {
                        cdEntity.setCategoryId(materialVO.getCategoryId());
                        cdEntity.setMaterialId(materialVO.getId());
                        cdEntity.setCategoryId(materialVO.getCategoryId());
                        cdEntity.setCode(materialVO.getCode());
                        cdEntity.setMatchStatus(1);
                        cdEntity.setMatchStatusDescription("已匹配");
                    }
                }
                if (cdEntity.getCostType() != null && cdEntity.getCostType() != 0) {
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType(cdEntity.getCostType()).getName());
                }
                //设置成本科目的id name code 和预算清单保持一致
                cdEntity.setSubjectId(cdEntity.getId());
                String subjectName = cdEntity.getName();
                if (cdEntity.getMaterialId() != null) {
                    if (StringUtils.isNotEmpty(cdEntity.getSpec())) {
                        subjectName = subjectName + " " + "[" + cdEntity.getSpec() + "]";
                    }
                }
                cdEntity.setSubjectName(subjectName);
                cdEntity.setSubjectCode(cdEntity.getCode());
            }
            entity.setDetailList(detailList);
            detailsService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        //实现排序
        BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
        List<BudgetProjectDetailProVO> list = BeanMapper.mapList(detailList, BudgetProjectDetailProVO.class);
        Collections.sort(list, new BudgetDetailProComparatoeVo());
        vo.setDetailList(TreeNodeBUtil.buildTree(list));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> queryDetail(Long id) {
        BudgetProjectProVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/compareDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> compareDetail(Long id) {
        BudgetProjectProVO budgetProjectProVO = service.compareDetail(id);
        return CommonResponse.success("查询详情数据成功！", budgetProjectProVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectProVO> vos) {
        List<Long> mainIds = vos.stream().map(BudgetProjectProVO::getId).collect(Collectors.toList());
        List<BudgetProjectProEntity> entities = (List<BudgetProjectProEntity>) service.listByIds(mainIds);
        List<Long> longs = entities.stream().filter(x -> null != x.getSourceId()).map(BudgetProjectProEntity::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(longs)) {
            List<BudgetProjectEntity> list = (List<BudgetProjectEntity>) budgetProjectService.listByIds(longs);
            for (BudgetProjectEntity entity : list) {
                entity.setTargetId(null);
            }
            budgetProjectService.saveOrUpdateBatch(list);
        }
        service.removeByIds(mainIds, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectProVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BudgetProjectProEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectProVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectProEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectPro-export.xlsx", beans, response);
    }

    /**
     * @Description 设备物资参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetProjectProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailReferenProVO>> refBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                          String condition,
                                                                                          String searchObject,
                                                                                          String searchText) {
        QueryParam param = new QueryParam();

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        /** 租户隔离 */
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                projectId = Long.parseLong(_con.get("projectId").toString());
            }
            if (_con.get("costType") != null) {
                costType = _con.get("costType").toString();
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.orderByAsc("orderId");
        Page<BudgetProjectDetailReferenProVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<BudgetProjectDetailReferenProVO> list = service.queryDetailList(page, wrapper, projectId, costType);

        Map<Long, BudgetProjectDetailReferenProVO> collect = list.stream().collect(Collectors.toMap(BudgetProjectDetailReferenProVO::getMaterialId, e -> e, (item1, item2) -> item1));
        List<Long> materialIds = collect.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            CommonResponse<List<MaterialVO>> queryMaterialResponse = materialApi.queryMaterialByIds(materialIds);
            if (queryMaterialResponse.isSuccess()) {
                if (CollectionUtils.isNotEmpty(queryMaterialResponse.getData())) {
                    for (BudgetProjectDetailReferenProVO data : list) {

                        for (MaterialVO vo : queryMaterialResponse.getData()) {
                            if (data.getMaterialId().equals(vo.getId())) {
                                data.setMaterialCode(vo.getCode());
                            }
                        }
                    }
                }
            } else {
                throw new BusinessException("网络异常， 获取物资编码失败");
            }
        }
        page.setRecords(list);
        page.setTotal(page.getTotal());
        return CommonResponse.success("查询参照数据成功！", page);
    }

    /**
     * @Description 预算管理-其他支出参照
     * @Return void
     */
    @RequestMapping(value = "/refotherBudgetProjectProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailReferenProVO>> refotherBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                               String condition,
                                                                                               String searchObject,
                                                                                               String searchText) {
        QueryParam param = new QueryParam();

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        /** 租户隔离 */
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                projectId = Long.parseLong(_con.get("projectId").toString());
            }
            if (_con.get("costType") != null) {
                costType = _con.get("costType").toString();
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.orderByDesc("tax_mny");
        Page<BudgetProjectDetailReferenProVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<BudgetProjectDetailReferenProVO> list = service.queryOtherDetailList(page, wrapper, projectId, costType);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success("查询参照数据成功！", page);
    }


    /**
     * @Description 预算管理-分包管理参照
     * @Return void
     */
    @RequestMapping(value = "/refSubBudgetProjectProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailProVO>> refSubBudgetProjectProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                      String condition,
                                                                                      String searchObject,
                                                                                      String searchText) {
        QueryParam param = new QueryParam();

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        /** 租户隔离 */
        String costType = null;
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                projectId = Long.parseLong(_con.get("projectId").toString());
            }
            if (_con.get("costType") != null) {
                costType = _con.get("costType").toString();
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<BudgetProjectDetailProVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<BudgetProjectDetailProVO> list = service.querySubDetailList(page, wrapper, projectId, costType);
        //需要子级找父级
        if (CollectionUtils.isNotEmpty(list)) {

            List<BudgetProjectDetailProVO> detailProVOS = BeanMapper.mapList(list, BudgetProjectDetailProVO.class);
            //需要一直往上找
            List<BudgetProjectDetailProVO> parentList = new ArrayList<>();
            parentList = getParent(detailProVOS, parentList);
            list.addAll(parentList);
            for (BudgetProjectDetailProVO vo : list) {
                vo.setTid(vo.getId().toString());
                vo.setTpid(vo.getParentId() != null && vo.getParentId() > 0 ? vo.getParentId().toString() : "");
            }
            //实现排序
            Collections.sort(list, new BudgetDetailProComparatoeVo());
            list = TreeNodeBUtil.buildTree(list);
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success("查询参照数据成功！", page);
    }

    private List<BudgetProjectDetailProVO> getParent(List<BudgetProjectDetailProVO> detailProVOS, List<BudgetProjectDetailProVO> parentList) {
        List<Long> ids = detailProVOS.stream().filter(s -> s.getParentId() != null).map(BudgetProjectDetailProVO::getParentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper<BudgetProjectDetailProEntity> objectQueryWrapper = new QueryWrapper<>();
            objectQueryWrapper.in("id", ids);
            List<BudgetProjectDetailProEntity> parentDetailProEntities = budgetProjectDetailProService.list(objectQueryWrapper);
            if (CollectionUtils.isNotEmpty(parentDetailProEntities)) {
                List<BudgetProjectDetailProVO> list = BeanMapper.mapList(parentDetailProEntities, BudgetProjectDetailProVO.class);
                parentList.addAll(list);
                getParent(list, parentList);
            }
        }
        parentList = parentList.stream().collect(Collectors.collectingAndThen(
                Collectors.toCollection(()->new TreeSet<>(Comparator.comparing(BudgetProjectDetailProVO::getId))),ArrayList::new
        ));
        return parentList;
    }

    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/checkProjectBudget", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkProjectBudget(Long projectId, Long id) {
        QueryWrapper<BudgetProjectProEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.ne(id != null, "id", id);
        int count = service.count(queryWrapper);
        if (count > 0) {
            return CommonResponse.error("该项目已编制项目预算单据，请在原单据上修改或者变更！");
        }
        return CommonResponse.success("该项目已编制项目预算单据，请在原单据上修改或者变更！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> test(Long id) {
        budgetProjectPro.afterApprovalProcessor(id, 0, "BT202209000001");
        BudgetProjectProVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/changeTest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> changeTest(Long id) {
        budgetProjectChangePro.afterApprovalProcessor(id, 0, "BT202209000002");
        BudgetProjectProVO vo = null;
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description 查询成本科目是否唯一接口
     * @Param budgetCostVO
     */
    @RequestMapping(value = "/queryOnlySuject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetCostVO> queryOnlySuject(@RequestBody BudgetCostVO budgetCostVO) {
        Long projectId = budgetCostVO.getProjectId();
        Integer costType = budgetCostVO.getCostType();
        Map<Long, CostSubjectVO> subjectMap = budgetCostVO.getSubjectMap();
        Set<Long> subjectIds = subjectMap.keySet();
        if (projectId != null && costType != null && CollectionUtils.isNotEmpty(subjectIds)) {
            List<BudgetProjectDetailProVO> list = service.queryOnlySuject(projectId, costType, subjectIds);
            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, BudgetProjectDetailProVO> detailMap = list.stream().collect(Collectors.toMap(k -> k.getSubjectId(), (k) -> k));
                Map<Long, List<BudgetProjectDetailProVO>> materialMap = list.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(BudgetProjectDetailProVO::getMaterialId));
                for (Long key : subjectMap.keySet()) {
                    CostSubjectVO costSubjectVO = subjectMap.get(key);
                    BudgetProjectDetailProVO vo = detailMap.get(key) != null ? detailMap.get(key) : null;
                    List<BudgetProjectDetailProVO> materialvos = materialMap.get(key);
                    if (CollectionUtils.isNotEmpty(materialvos) && materialvos.size() == 1) {
                        vo = materialvos.get(0);
                    }
                    if (vo != null) {
                        costSubjectVO.setSubjectId(vo.getSubjectId());
                        costSubjectVO.setSubjectCode(vo.getSubjectCode());
                        costSubjectVO.setSubjectName(vo.getSubjectName());
                        costSubjectVO.setCostType(vo.getCostType());
                    } else {
                        costSubjectVO.setSubjectId(null);
                        costSubjectVO.setSubjectName(null);
                        costSubjectVO.setSubjectCode(null);
                        costSubjectVO.setCostType(null);
                    }
                }
                budgetCostVO.setSubjectMap(subjectMap);
            }
        }
        return CommonResponse.success("查询成本科目是否唯一！", budgetCostVO);
    }

    public static void main(String[] args) {
        BudgetCostVO costVO = new BudgetCostVO();
        costVO.setProjectId(1L);
        costVO.setCostType(2);
        HashMap<Long, CostSubjectVO> objectObjectHashMap = new HashMap<>();
        CostSubjectVO costSubjectVO = new CostSubjectVO();
        costSubjectVO.setSubjectId(1L);
        costSubjectVO.setSubjectCode("测试");
        costSubjectVO.setSubjectName("jc");
        objectObjectHashMap.put(1L, costSubjectVO);
        costVO.setSubjectMap(objectObjectHashMap);
        System.out.println(JSONObject.toJSONString(costVO));
    }


    @RequestMapping(value = "/handleCostDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectProVO> handleCostDetail(Long id) {
        BudgetProjectProVO vo = service.queryDetail(id);
        LambdaQueryWrapper<BudgetProjectDetailProEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetProjectDetailProEntity::getBudgetId, id);
        wrapper.isNull(BudgetProjectDetailProEntity::getMaterialId);
        wrapper.isNotNull(BudgetProjectDetailProEntity::getMaterialName);
        wrapper.isNotNull(BudgetProjectDetailProEntity::getCategoryName);
        List<BudgetProjectDetailProEntity> detailList = detailsService.list(wrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, MaterialVO> materialVOMap = new HashMap<>();
            Map<String, MaterialVO> archiveMap = new HashMap<>();
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (null != cdEntity.getCostType() && 2 == cdEntity.getCostType() && cdEntity.getMatchStatus() != null && cdEntity.getMatchStatus() != 1) {
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setCategoryName(cdEntity.getCategoryName());
                    materialVO.setName(cdEntity.getMaterialName());
                    materialVO.setSpec(cdEntity.getSpec());
                    materialVO.setUnitName(cdEntity.getUnit());
                    materialVO.setType(1);
                    //这个地方拼接一个key 用于从返回的数据中取到 档案的相关信息
                    String key = cdEntity.getName() + (cdEntity.getCostType() != null ? cdEntity.getCostType() : "") + cdEntity.getCategoryName() + cdEntity.getSpec() + cdEntity.getUnit();
                    cdEntity.setKey(key);
                    materialVOMap.put(key, materialVO);
                }
            }
            if (materialVOMap != null) {
                MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(materialVOMap, vo.getId(), vo.getBillCode(), vo.getProjectName(), "目标成本");
                CommonResponse<Map<String, MaterialVO>> listCommonResponse = materialApi.batchInsertArchiveBySourceBill(archiveVO);
                if (listCommonResponse.isSuccess()) {
                    Map<String, MaterialVO> data = listCommonResponse.getData();
                    if (data != null) {
                        archiveMap = data;
                    }
                }
            }
            for (BudgetProjectDetailProEntity cdEntity : detailList) {
                if (archiveMap != null) {
                    MaterialVO materialVO = archiveMap.get(cdEntity.getKey());
                    if (materialVO != null) {
                        cdEntity.setCategoryId(materialVO.getCategoryId());
                        cdEntity.setMaterialId(materialVO.getId());
                        cdEntity.setCode(materialVO.getCode());
                        cdEntity.setMatchStatus(1);
                        cdEntity.setMatchStatusDescription("已匹配");
                    }
                }
                if (cdEntity.getCostType() != null && cdEntity.getCostType() != 0) {
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType(cdEntity.getCostType()).getName());
                }
                //设置成本科目的id name code 和预算清单保持一致
                cdEntity.setSubjectId(cdEntity.getId());
                String subjectName = cdEntity.getName();
                if (cdEntity.getMaterialId() != null) {
                    if (StringUtils.isNotEmpty(cdEntity.getSpec())) {
                        subjectName = subjectName + " " + "[" + cdEntity.getSpec() + "]";
                    }
                }
                cdEntity.setSubjectName(subjectName);
                cdEntity.setSubjectCode(cdEntity.getCode());
            }
            detailsService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }




}
