/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeProVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectChangePro"})
public class BudgetProjectChangeProController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";
    @Autowired
    private IBudgetProjectChangeProService service;
    @Autowired
    private IBudgetProjectProService budgetService;
    @Autowired
    private IBudgetProjectDetailChangeProService detailsService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetProjectService budgetProjectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> saveOrUpdate(@RequestBody BudgetProjectChangeProVO saveOrUpdateVO) {
        List<BudgetProjectDetailChangeProEntity> changeDetailList;
        String operateType = null;
        BudgetProjectChangeProEntity entity = (BudgetProjectChangeProEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetProjectChangeProEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            this.budgetService.beforeSaveCheck(BeanMapper.mapList(entity.getDetailList(), BudgetProjectDetailProEntity.class));
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                operateType = "add";
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(changeDetailList = entity.getDetailList()) && operateType != null && operateType.equals("add")) {
            for (BudgetProjectDetailChangeProEntity changeProEntity : changeDetailList) {
                changeProEntity.setId(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<BudgetProjectDetailChangeProEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetProjectDetailChangeProEntity cdEntity : detailList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailChangeProEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                if (cdEntity.getBudgetDetailId() == null) {
                    cdEntity.setSubjectId(cdEntity.getId());
                } else {
                    cdEntity.setSubjectId(cdEntity.getBudgetDetailId());
                }
                String subjectName = cdEntity.getName();
                if (cdEntity.getMaterialId() != null && StringUtils.isNotEmpty((CharSequence)cdEntity.getSpec())) {
                    subjectName = subjectName + " [" + cdEntity.getSpec() + "]";
                }
                cdEntity.setSubjectCode(cdEntity.getCode());
                cdEntity.setSubjectName(subjectName);
                if (cdEntity.getCostType() == null) continue;
                cdEntity.setCostTypeName(CostTypeEnum.getEnumByType((Integer)cdEntity.getCostType()).getName());
            }
            entity.setDetailList(detailList);
            this.detailsService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetProjectProEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(BudgetProjectProEntity::getChangeStatus, (Object)2);
        updateWrapper.set(BudgetProjectProEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.set(BudgetProjectProEntity::getChangeVersion, (Object)entity.getVersion());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBudgetId());
        this.budgetService.update((Wrapper)updateWrapper);
        BudgetProjectChangeProVO vo = this.service.queryDetail(entity.getId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetail(Long id) {
        BudgetProjectChangeProVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeProVO> vos) {
        List mainIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List entities = (List)this.service.listByIds(mainIds);
        List longs = entities.stream().filter(x -> null != x.getSourceId()).map(BudgetProjectChangeProEntity::getSourceId).collect(Collectors.toList());
        List list = (List)this.budgetProjectService.listByIds(longs);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BudgetProjectEntity entity : list) {
                entity.setTargetId(null);
            }
            this.budgetProjectService.saveOrUpdateBatch(list);
        }
        if (ListUtil.isNotEmpty(vos)) {
            for (BudgetProjectChangeProVO vo : vos) {
                BudgetProjectChangeProEntity budgetProjectChangeProEntity = (BudgetProjectChangeProEntity)((Object)this.service.selectById(vo.getId()));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)budgetProjectChangeProEntity.getBudgetId());
                if (budgetProjectChangeProEntity.getChangeStatus() == 1) {
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus, (Object)1);
                } else {
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus, (Object)3);
                }
                this.budgetService.update((Wrapper)updateWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectChangePro-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetProjectChangeProData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> refBudgetProjectChangeProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeProVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetailChange(@RequestParam Long id) {
        BudgetProjectChangeProVO vo = this.service.queryDetailChange(id, true);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/checkQuote"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> checkQuote(@RequestBody List<Long> ids) {
        Iterator<Long> iterator;
        if (CollectionUtils.isNotEmpty(ids) && (iterator = ids.iterator()).hasNext()) {
            Long billId = iterator.next();
            CommonResponse res = this.billTypeApi.checkQuote("BT202210000001", billId);
            if (res.isSuccess()) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }
}

