/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ApprovmentEntity;
import com.ejianc.business.cost.bean.ClaimEntity;
import com.ejianc.business.cost.service.IApprovmentService;
import com.ejianc.business.cost.service.IClaimService;
import com.ejianc.business.cost.vo.ApprovmentVO;
import com.ejianc.business.cost.vo.ClaimVO;
import com.ejianc.business.sub.api.ICertificateApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"claim"})
public class ClaimController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "COST_CLAIM";
    @Autowired
    private IClaimService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IApprovmentService approvmentService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICertificateApi certificateApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimVO> saveOrUpdate(@RequestBody ClaimVO saveOrUpdateVO) {
        ClaimEntity entity = (ClaimEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ClaimEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimVO> queryDetail(Long id) {
        ClaimEntity entity = (ClaimEntity)((Object)this.service.selectById(id));
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ApprovmentEntity::getClaimId, (Object)id);
        queryWrapper.orderByDesc(ApprovmentEntity::getOccurDate);
        List list = this.approvmentService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setApprovmentList(BeanMapper.mapList((Iterable)list, ApprovmentVO.class));
        }
        CommonResponse response = this.certificateApi.getByCertificateId(id);
        vo.setCertificateList((List)response.getData());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ClaimVO claimVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List claimVOS = BeanMapper.mapList((Iterable)page.getRecords(), ClaimVO.class);
        for (ClaimVO claimVO : claimVOS) {
            this.fullInfo(claimVO);
        }
        pageData.setRecords(claimVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void fullInfo(ClaimVO claimVO) {
        CommonResponse response;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ApprovmentEntity::getClaimId, (Object)claimVO.getId());
        queryWrapper.in(ApprovmentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(ApprovmentEntity::getOccurDate);
        queryWrapper.last("limit 1");
        ApprovmentEntity entity = (ApprovmentEntity)((Object)this.approvmentService.getOne((Wrapper)queryWrapper));
        Set<Object> stringSet = new HashSet();
        if (null != entity && (response = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            stringSet = ((List)response.getData()).stream().map(AttachmentVO::getSourceType).collect(Collectors.toSet());
        }
        claimVO.setLinkFile(stringSet.contains("linkFile") ? "\u5df2\u4e0a\u4f20" : null);
        claimVO.setImageFile(stringSet.contains("imageFile") ? "\u5df2\u4e0a\u4f20" : null);
        claimVO.setSignFile(stringSet.contains("signFile") ? "\u5df2\u4e0a\u4f20" : null);
        claimVO.setPriceFile(stringSet.contains("priceFile") ? "\u5df2\u4e0a\u4f20" : null);
        claimVO.setQualityFile(stringSet.contains("qualityFile") ? "\u5df2\u4e0a\u4f20" : null);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<ClaimVO>> commonResponse = this.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = ((IPage)commonResponse.getData()).getRecords();
        records.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (null != vo.getLockState()) {
                switch (vo.getLockState()) {
                    case 1: {
                        vo.setLockStateName("\u9501\u9879");
                        break;
                    }
                    case 2: {
                        vo.setLockStateName("\u9501\u4ef7");
                        break;
                    }
                }
            }
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Claim-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refClaimData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> refClaimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ClaimVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

