/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CtrlSetDetailEntity;
import com.ejianc.business.cost.bean.CtrlSetEntity;
import com.ejianc.business.cost.service.ICtrlSetDetailService;
import com.ejianc.business.cost.service.ICtrlSetService;
import com.ejianc.business.cost.vo.CtrlSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ctrlSet"})
public class CtrlSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICtrlSetDetailService ctrlSetDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICtrlSetService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CtrlSetVO> saveOrUpdate(@RequestBody CtrlSetVO saveOrUpdateVO) {
        CtrlSetEntity entity = (CtrlSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CtrlSetEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CtrlSetVO vo = (CtrlSetVO)BeanMapper.map((Object)((Object)entity), CtrlSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<CtrlSetVO> ctrlSetVOS) {
        if (CollectionUtils.isNotEmpty(ctrlSetVOS)) {
            List codeList = ctrlSetVOS.stream().map(CtrlSetVO::getCode).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(CtrlSetEntity::getCode, codeList);
            List setEntities = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)setEntities)) {
                codeList = setEntities.stream().map(CtrlSetEntity::getCode).collect(Collectors.toList());
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801[" + StringUtils.join(codeList, (String)",") + "]\u5df2\u5b58\u5728!");
            }
            List list = BeanMapper.mapList(ctrlSetVOS, CtrlSetEntity.class);
            this.service.saveOrUpdateBatch(list);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CtrlSetVO> queryDetail(Long id) {
        CtrlSetEntity entity = (CtrlSetEntity)((Object)this.service.selectById(id));
        CtrlSetVO vo = (CtrlSetVO)BeanMapper.map((Object)((Object)entity), CtrlSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CtrlSetVO> vos) {
        List longs = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(CtrlSetDetailEntity::getSetId, longs);
        if (this.ctrlSetDetailService.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u660e\u7ec6\u6709\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CtrlSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CtrlSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CtrlSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCtrlSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CtrlSetVO>> refCtrlSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CtrlSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

