/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ApprovmentEntity;
import com.ejianc.business.cost.bean.ClaimEntity;
import com.ejianc.business.cost.mapper.ApprovmentMapper;
import com.ejianc.business.cost.service.IApprovmentService;
import com.ejianc.business.cost.service.IClaimService;
import com.ejianc.business.cost.vo.ApprovmentVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="approvmentService")
public class ApprovmentServiceImpl
extends BaseServiceImpl<ApprovmentMapper, ApprovmentEntity>
implements IApprovmentService {
    private static final String BILL_CODE = "COST_APPROVMENT";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public ApprovmentVO queryByAdd(Long claimId) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.claimService.selectById(claimId));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ApprovmentEntity::getClaimId, (Object)claimId);
        queryWrapper.in(ApprovmentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(ApprovmentEntity::getOccurDate);
        queryWrapper.last("limit 1");
        ApprovmentEntity entity = (ApprovmentEntity)((Object)this.getOne((Wrapper)queryWrapper));
        ApprovmentVO vo = null;
        if (null != entity) {
            vo = (ApprovmentVO)BeanMapper.map((Object)((Object)entity), ApprovmentVO.class);
            vo.setId(Long.valueOf(IdWorker.getId()));
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT240611000000004", "linkFile", String.valueOf(vo.getId()), "BT240611000000004", "linkFile");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT240611000000004", "imageFile", String.valueOf(vo.getId()), "BT240611000000004", "imageFile");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT240611000000004", "signFile", String.valueOf(vo.getId()), "BT240611000000004", "signFile");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT240611000000004", "priceFile", String.valueOf(vo.getId()), "BT240611000000004", "priceFile");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT240611000000004", "qualityFile", String.valueOf(vo.getId()), "BT240611000000004", "qualityFile");
        } else {
            vo = (ApprovmentVO)BeanMapper.map((Object)((Object)claimEntity), ApprovmentVO.class);
            vo.setId(Long.valueOf(IdWorker.getId()));
        }
        vo.setBillCode(null);
        vo.setClaimId(claimId);
        vo.setClaimCode(claimEntity.getBillCode());
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setVersion(null);
        vo.setMemo(null);
        vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        return vo;
    }

    @Override
    public ApprovmentVO saveOrUpdate(ApprovmentVO saveOrUpdateVO) {
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        qry.eq(ApprovmentEntity::getClaimId, (Object)saveOrUpdateVO.getClaimId());
        qry.notIn(ApprovmentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        ApprovmentEntity proEntity = (ApprovmentEntity)((Object)this.getOne((Wrapper)qry, false));
        if (null != proEntity) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u6279\u590d\u5355" + proEntity.getBillCode() + ",\u4e0d\u5141\u8bb8\u518d\u6b21\u65b0\u589e!");
        }
        ApprovmentEntity entity = (ApprovmentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApprovmentEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        ApprovmentVO vo = (ApprovmentVO)BeanMapper.map((Object)((Object)entity), ApprovmentVO.class);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(entity.getBillState())) {
            Integer lockState = null;
            CommonResponse response = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                Set stringSet = ((List)response.getData()).stream().map(AttachmentVO::getSourceType).collect(Collectors.toSet());
                if (stringSet.contains("linkFile") && stringSet.contains("imageFile") && stringSet.contains("signFile") && stringSet.contains("priceFile") && stringSet.contains("qualityFile")) {
                    lockState = 2;
                } else if (stringSet.contains("linkFile") && stringSet.contains("imageFile") && stringSet.contains("signFile")) {
                    lockState = 1;
                }
            }
            LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
            update.eq(BaseEntity::getId, (Object)entity.getId());
            update.set(ApprovmentEntity::getLockState, lockState);
            this.update((Wrapper)update);
            vo.setLockState(lockState);
        }
        return vo;
    }
}

