/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.target.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.target.bean.TargetCostFinishDetailEntity;
import com.ejianc.business.target.bean.TargetCostFinishEntity;
import com.ejianc.business.target.service.ITargetCostFinishDetailService;
import com.ejianc.business.target.service.ITargetCostFinishService;
import com.ejianc.business.target.vo.TargetCostExecutionReportVO;
import com.ejianc.business.target.vo.TargetCostFinishDetailComparatorVO;
import com.ejianc.business.target.vo.TargetCostFinishDetailVO;
import com.ejianc.business.target.vo.TargetCostFinishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"targetCostFinish"})
public class TargetCostFinishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TARGET_COST_FINISH_CODE";
    @Autowired
    private ITargetCostFinishService service;
    @Autowired
    private ITargetCostFinishDetailService targetCostFinishDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired(required=false)
    private RestHighLevelClient client;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME = "ejc_target_cost_execution";

    @RequestMapping(value={"/executionReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TargetCostExecutionReportVO>> executionReport(@RequestParam Long projectId) {
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<TargetCostExecutionReportVO> list = this.getExecutionReport(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/executionExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void executionExport(@RequestParam Long projectId, HttpServletResponse response) {
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<TargetCostExecutionReportVO> list = this.getExecutionReport(projectId);
        HashMap<String, List<TargetCostExecutionReportVO>> beans = new HashMap<String, List<TargetCostExecutionReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("execution-export.xlsx", beans, response);
    }

    private List<TargetCostExecutionReportVO> getExecutionReport(Long projectId) {
        ArrayList<TargetCostExecutionReportVO> list = new ArrayList<TargetCostExecutionReportVO>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort("code", SortOrder.ASC);
        sourceBuilder.size(10000);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add((TargetCostExecutionReportVO)JSON.parseObject((String)sourceAsString, TargetCostExecutionReportVO.class));
            }
        }
        catch (IOException e) {
            try {
                response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add((TargetCostExecutionReportVO)JSON.parseObject((String)sourceAsString, TargetCostExecutionReportVO.class));
                }
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
            }
        }
        return list;
    }

    @GetMapping(value={"/getSumFinishTaxMny"})
    @ResponseBody
    public CommonResponse<JSONObject> getSumFinishTaxMny(@RequestParam Long projectId, @RequestParam(required=false) Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TargetCostFinishEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq(TargetCostFinishEntity::getProjectId, (Object)projectId);
        queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
        List list = this.service.list((Wrapper)queryWrapper);
        BigDecimal sumFinishTaxMny = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((List)list)) {
            sumFinishTaxMny = list.stream().map(TargetCostFinishEntity::getFinishTaxMny).reduce(ComputeUtil::safeAdd).orElse(BigDecimal.ZERO);
        }
        JSONObject data = new JSONObject();
        data.put("sumFinishTaxMny", (Object)sumFinishTaxMny);
        return CommonResponse.success((String)"\u83b7\u53d6\u9879\u76ee\u7d2f\u8ba1\u5b8c\u5de5\u603b\u91d1\u989d\u6210\u529f\uff01", (Object)data);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TargetCostFinishVO> saveOrUpdate(@RequestBody TargetCostFinishVO saveOrUpdateVO) {
        TargetCostFinishEntity entity = (TargetCostFinishEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TargetCostFinishEntity.class));
        Long id = entity.getId();
        CommonResponse<String> checkResponse = this.checkSave(id, entity.getProjectId());
        if (!checkResponse.isSuccess()) {
            return CommonResponse.error((String)checkResponse.getMsg());
        }
        if (id == null || id == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<TargetCostFinishDetailEntity> targetCostFinishDetailList = entity.getTargetCostFinishDetailList();
        if (CollectionUtils.isNotEmpty(targetCostFinishDetailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TargetCostFinishDetailEntity cdEntity : targetCostFinishDetailList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TargetCostFinishDetailEntity cdEntity : targetCostFinishDetailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.targetCostFinishDetailService.saveOrUpdateBatch(targetCostFinishDetailList, targetCostFinishDetailList.size());
        }
        TargetCostFinishVO vo = (TargetCostFinishVO)BeanMapper.map((Object)((Object)entity), TargetCostFinishVO.class);
        List list = BeanMapper.mapList(targetCostFinishDetailList, TargetCostFinishDetailVO.class);
        Collections.sort(list, new TargetCostFinishDetailComparatorVO());
        vo.setTargetCostFinishDetailList(TreeNodeBUtil.buildTree((List)list));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkSave"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<String> checkSave(Long id, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.notIn(TargetCostFinishEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq(TargetCostFinishEntity::getProjectId, (Object)projectId);
        queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u975e\u751f\u6548\u6001\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TargetCostFinishVO> queryDetail(Long id) {
        TargetCostFinishEntity entity = (TargetCostFinishEntity)((Object)this.service.selectById(id));
        TargetCostFinishVO vo = (TargetCostFinishVO)BeanMapper.map((Object)((Object)entity), TargetCostFinishVO.class);
        List targetCostFinishDetailList = vo.getTargetCostFinishDetailList();
        if (CollectionUtils.isNotEmpty((Collection)targetCostFinishDetailList)) {
            for (TargetCostFinishDetailVO cdEntity : targetCostFinishDetailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            Collections.sort(targetCostFinishDetailList, new TargetCostFinishDetailComparatorVO());
            vo.setTargetCostFinishDetailList(TreeNodeBUtil.buildTree((List)targetCostFinishDetailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TargetCostFinishVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TargetCostFinishVO targetCostFinishVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TargetCostFinishVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "departmentName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TargetCostFinishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "departmentName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("TargetCostFinish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTargetCostFinishData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TargetCostFinishVO>> refTargetCostFinishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TargetCostFinishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

