package com.ejianc.business.budget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 清单定额关系明细
 *
 * @author generator
 *
 */
 @TableName("ejc_budget_set_detail")
public class BudgetSetDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="set_id")
    private Long setId; // 主表ID
    @TableField(value="set_type_id")
    private Long setTypeId; // 类型子表ID
    @TableField(value="detail_code")
    private String detailCode; // 清单编码
    @TableField(value="detail_name")
    private String detailName; // 清单名称
    @TableField(value="description")
    private String description; // 特征描述
    @TableField(value="detail_unit")
    private String detailUnit; // 单位
    @TableField(value="detail_num")
    private BigDecimal detailNum; // 工程量
    @TableField(value="quota_name")
    private String quotaName; // 关联定额
    @TableField(value="features")
    private String features; // 关键特征值
    @TableField(value="memo")
    private String memo; // 备注


    @TableField(exist=false)
    @SubEntity(serviceName="budgetSetQuotaService", pidName = "setDetailId")
    private List<BudgetSetQuotaEntity> quotaList = new ArrayList<>(); // 清单定额关系定额表
    @TableField(exist=false)
    @SubEntity(serviceName="budgetSetFeaturesService", pidName = "setDetailId")
    private List<BudgetSetFeaturesEntity> featuresList = new ArrayList<>(); // 清单定额关系特征值


    public Long getSetId() {
        return setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }
    public Long getSetTypeId() {
        return setTypeId;
    }

    public void setSetTypeId(Long setTypeId) {
        this.setTypeId = setTypeId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public String getQuotaName() {
        return quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }
    public String getFeatures() {
        return features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<BudgetSetQuotaEntity> getQuotaList() {
        return quotaList;
    }

    public void setQuotaList(List<BudgetSetQuotaEntity> quotaList) {
        this.quotaList = quotaList;
    }

    public List<BudgetSetFeaturesEntity> getFeaturesList() {
        return featuresList;
    }

    public void setFeaturesList(List<BudgetSetFeaturesEntity> featuresList) {
        this.featuresList = featuresList;
    }
}
