package com.ejianc.business.budget.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.vo.*;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 项目预算主实体
 *
 * @author generator
 *
 */
public interface IBudgetProjectProService extends IBaseService<BudgetProjectProEntity> {

    BudgetProjectProVO queryDetail(Long id);

    List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType);

    List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType);

    /**
     * 获取预算量价
     *
     * @param paramControlVO 项目预算Pro参数控制VO
     *
     * @return {@link BudgetProjectProQuantityAndMnyVO}
     */
    BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO);

    List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType);

    /**
     * 预算推送成本设置
     */
    void pushCostSetting(Long budgetId);

    List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds);

    /**
     * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
     * @param projectId
     * @return
     */
    Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId);

    List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId);

    Long pushToPro(BudgetProjectVO budgetProjectVO);

    BudgetProjectProVO compareDetail(Long id, Boolean compareFirst);

    void beforeSaveCheck(List<BudgetProjectDetailProEntity> detailList);
}
