package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.ICategoryBrandApi;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目预算主实体
 *
 * @author generator
 */
@Service("budgetProjectProService")
public class BudgetProjectProServiceImpl extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity> implements IBudgetProjectProService {
    @Autowired
    private BudgetProjectProMapper budgetProjectProMapper;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
    @Autowired
    private IBudgetProjectProService budgetProService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private IQuotaDetailService quotaDetailService;//定额库
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CODE";
    private static final String CHANGE_BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";
    private final String CHECK_PARAM = "P-Fu572q01";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBudgetSetService budgetSetService;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetProjectChangeProService budgetProjectChangeProService;
    @Autowired
    private IGuidePriceDetailService guidePriceDetailService;
    @Autowired
    private ICategoryBrandApi categoryBrandApi;
    @Autowired
    private IParamConfigApi paramConfigApi;


    // 临时物料档案是否开启
    private static final String PARAM_TEMP_MATERIAL_CODE = "P-QKse6304";

    // 临时定额库是否开启
    private static final String PARAM_TEMP_LBOR_CODE = "P-7d32tl03";

    @Override
    public BudgetProjectProVO queryDetail(Long id) {
        BudgetProjectProEntity entity = budgetProjectProMapper.selectById(id);
        if (entity != null) {
            BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, vo.getId()));
            List<BudgetProjectDetailProEntity> detailProEntityList = budgetProjectDetailProService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(detailProEntityList)) {
                List<BudgetProjectDetailProVO> resultMapList = BeanMapper.mapList(detailProEntityList, BudgetProjectDetailProVO.class);
                for (BudgetProjectDetailProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                //实现排序
                Collections.sort(resultMapList, new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
    }


    /**
     * 获取预算量价
     *
     * @param paramControlVO 项目预算Pro参数控制VO
     * @return {@link BudgetProjectProQuantityAndMnyVO}
     */
    @Override
    public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
        if (paramControlVO.getProjectId() == null) {
            return null;
        }

        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();

        // 1、根据项目id查询已生效的预算编制单据信息，获取表头各金额和总金额数据
        LambdaQueryWrapper<BudgetProjectProEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectProEntity::getProjectId, paramControlVO.getProjectId());
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        BudgetProjectProEntity entity = super.getOne(lambdaQuery);
        if (entity == null) {
            return null;
        }

        // 预算总金额（含税）
        quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
        // 预算总金额(无税)
        quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
        // 间接费(含税)
        quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
        // 间接费（无税）
        quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
        // 人工费（含税）
        quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
        // 人工费（无税）
        quantityAndMnyVO.setLaborMny(entity.getLaborMny());
        // 材料费（含税）
        quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
        // 材料费（无税）
        quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
        // 专业费（含税）
        quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
        // 专业费（无税）
        quantityAndMnyVO.setMajorMny(entity.getMajorMny());
        // 机械费(含税 )
        quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
        // 机械费（无税）
        quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
        //零星材料金额
        quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
        // 2、根据预算编制id和费用类型以及档案ids（可以不传），按照清单维度和档案维度查询预算清单量价（累计工程量、累计无税金额、累计含税金额）累计值
        Map<Long, BudgetProjectDetailProVO> detailProMap;
        if ((paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty(paramControlVO.getIds())) {
            detailProMap = budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds());
        } else {
            detailProMap = budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
        }
        quantityAndMnyVO.setDetailProMap(detailProMap);

        return quantityAndMnyVO;
    }

    @Override
    public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public void pushCostSetting(Long budgetId) {
        ArrayList<SubjectEntity> subjectAndUpdateList = new ArrayList<>();
        Map<Long, SubjectEntity> subjectMap = new HashMap<>();
        BudgetProjectProEntity entity = budgetProService.selectById(budgetId);
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        QueryWrapper<SubjectEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("setting_id", budgetId);
        List<SubjectEntity> subjectEntities = subjectService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty(subjectEntities)) {
                subjectMap = subjectEntities.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                for (BudgetProjectDetailProEntity projectDetailProEntity : detailList) {
                    SubjectEntity subjectEntity = null;
                    if (subjectMap.containsKey(projectDetailProEntity.getId())) {
                        //修改
                        subjectEntity = subjectMap.get(projectDetailProEntity.getId());
                        subjectEntity.setParentId(projectDetailProEntity.getParentId());
                        subjectEntity.setVersion(subjectEntity.getVersion());
                    } else {
                        //插入
                        subjectEntity = new SubjectEntity();
                        subjectEntity.setSettingId(budgetId);
                        subjectEntity.setId(projectDetailProEntity.getId());
                        subjectEntity.setVersion(null);
                    }
                    //移除没有移除完就删除
                    subjectMap.remove(subjectEntity.getId());

                    subjectEntity.setCostType(projectDetailProEntity.getCostType());
                    subjectEntity.setParentId(projectDetailProEntity.getParentId());
                    subjectEntity.setTid(projectDetailProEntity.getId());
                    subjectEntity.setSubjectName(projectDetailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(projectDetailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(projectDetailProEntity.getLeafFlag() == 1 ? true : false);
                    subjectEntity.setDetailIndex(projectDetailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            } else {
                //清单没有执行全部插入
                for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                    SubjectEntity subjectEntity = new SubjectEntity();
                    subjectEntity.setSettingId(budgetId);
                    subjectEntity.setCostType(detailProEntity.getCostType());
                    subjectEntity.setId(detailProEntity.getId());
                    subjectEntity.setParentId(detailProEntity.getParentId());
                    subjectEntity.setTid(detailProEntity.getId());
                    subjectEntity.setVersion(null);
                    subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(detailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1 ? true : false);
                    subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            }
            if (!subjectMap.isEmpty()) {
                List<Long> ids = subjectMap.keySet().stream().collect(Collectors.toList());
                subjectService.removeByIds(ids);
            }
            subjectService.saveOrUpdateBatch(subjectAndUpdateList, subjectAndUpdateList.size());
        } else {
            //预算清单子表为空 成本设置也该为空
            if (CollectionUtils.isNotEmpty(subjectEntities)) {
                List<Long> ids = subjectEntities.stream().map(SubjectEntity::getId).collect(Collectors.toList());
                subjectService.removeByIds(ids);
            }
        }
    }

    @Override
    public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
        return budgetProjectProMapper.queryOnlySuject(projectId, costType, subjectIds);
    }

    /**
     * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
     *
     * @param projectId
     * @return
     */
    @Override
    public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
        Map<Long, BigDecimal> map = new HashMap<>();
        if (projectId != null) {
            List<BudgetProjectProQuantityVO> list = budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId);
            if (CollectionUtils.isNotEmpty(list)) {
                map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
            }
        }
        return map;

    }

    @Override
    public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
        return budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
    }

    @Override
    public Long pushToPro(BudgetProjectVO budgetProjectVO) {
        LambdaQueryWrapper<BudgetProjectProEntity> qry = new LambdaQueryWrapper<>();
        qry.eq(BudgetProjectProEntity::getProjectId, budgetProjectVO.getProjectId());
        BudgetProjectProEntity proEntity = getOne(qry, false);
        if (null != proEntity) {
            if (null == proEntity.getSourceId()) {
                throw new BusinessException("已存在自制目标成本，不允许预算转换生成!");
            } else if (!BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(proEntity.getBillState())) {
                throw new BusinessException("该项目目标成本未生效，请处理后生成!");
            } else if (2 == proEntity.getChangeStatus()) {
                throw new BusinessException("目标成本变更中，请处理后生成!");
            }
        }

        Integer index = null;
        if (null == proEntity) {
            index = 0;
        } else {
            QueryWrapper<BudgetProjectDetailProEntity> query = Wrappers.query();
            query.eq("budget_id", proEntity.getId());
            query.isNull("parent_id");
            query.select("MAX(CONVERT(detail_index, UNSIGNED)) AS detail_index");
            BudgetProjectDetailProEntity detailProEntity = budgetProjectDetailProMapper.selectOne(query);
            index = null != detailProEntity && StringUtils.isNotBlank(detailProEntity.getDetailIndex()) ? Integer.parseInt((String) detailProEntity.getDetailIndex()) : 0;
        }
        List<BudgetProjectDetailProEntity> entities = new ArrayList<>();
        Set<Long> setDetailSet = budgetProjectVO.getCheckList().stream().filter(x -> !ConvertResultEnum.已忽略.getCode().equals(x.getResultState()) && null != x.getSetDetailId()).collect(Collectors.toList()).stream().map(BudgetProjectDetailVO::getSetDetailId).collect(Collectors.toSet());
        if (!setDetailSet.isEmpty()) {
            List<BudgetSetDetailEntity> setDetailEntities = (List<BudgetSetDetailEntity>) budgetSetDetailService.listByIds(new ArrayList<>(setDetailSet));
            //map<设置清单主键、设置清单>
            Map<Long, BudgetSetDetailEntity> setdetailMap = setDetailEntities.stream().collect(Collectors.toMap(BudgetSetDetailEntity::getId, Function.identity(), (x1, x2) -> x1));

            LambdaQueryWrapper<BudgetSetQuotaEntity> setQuotaQry = new LambdaQueryWrapper<>();
            setQuotaQry.in(BudgetSetQuotaEntity::getSetDetailId, new ArrayList<>(setDetailSet));
            List<BudgetSetQuotaEntity> setQuotaEntities = budgetSetQuotaService.list(setQuotaQry);
            //map<设置清单主键、设置定额集合>
            Map<Long, List<BudgetSetQuotaEntity>> setQuotaMap = new HashMap<>();
            List<Long> quotaIdList = new ArrayList<>();
            for (BudgetSetQuotaEntity quotaEntity : setQuotaEntities) {
                List<BudgetSetQuotaEntity> list = setQuotaMap.containsKey(quotaEntity.getSetDetailId()) ? setQuotaMap.get(quotaEntity.getSetDetailId()) : new ArrayList<>();
                list.add(quotaEntity);
                setQuotaMap.put(quotaEntity.getSetDetailId(), list);
                quotaIdList.add(quotaEntity.getQuotaId());
            }

            List<QuotaDetailEntity> quotaDetails = (List<QuotaDetailEntity>) quotaDetailService.listByIds(quotaIdList);
            //map<定额库清单主键、定额库清单>
            Map<Long, QuotaDetailEntity> quotaDetailMap = quotaDetails.stream().collect(Collectors.toMap(QuotaDetailEntity::getId, Function.identity(), (x1, x2) -> x1));
            LambdaQueryWrapper<QuotaMatEntity> quotaMatQry = Wrappers.lambdaQuery();
            quotaMatQry.in(QuotaMatEntity::getQuotaDetailId, quotaIdList);
            List<QuotaMatEntity> quotaMats = quotaMatService.list(quotaMatQry);
            //map<定额库清单主键、定额库主材集合>
            Map<Long, List<QuotaMatEntity>> quotaMatMap = quotaMats.stream().collect(Collectors.groupingBy(QuotaMatEntity::getQuotaDetailId));

            Map<String, BigDecimal> guidePriceMap = guidePriceDetailService.queryGuidePriceDetailData();
            Map<Long, CategoryBrandVO> branchMap = new HashMap<>();
            CommonResponse<List<CategoryBrandVO>> response = categoryBrandApi.queryWhetherByCtyIds(new ArrayList<>());
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                branchMap = response.getData().stream().collect(Collectors.toMap(CategoryBrandVO::getCategoryId, Function.identity(), (key1, key2) -> key1));
            }

            CommonResponse<ParamRegisterSetVO> paramRespone = paramConfigApi.getByCode(CHECK_PARAM);
            List<BudgetProjectDetailProEntity> detailList = null;
            if (paramRespone.isSuccess() && null != paramRespone.getData() && paramRespone.getData().getValueData().equals("2")) {
                detailList = budgetDetail(index, budgetProjectVO, setdetailMap, setQuotaMap, quotaDetailMap, quotaMatMap, guidePriceMap, branchMap);
            } else {
                detailList = noBudgetDetail(index, budgetProjectVO, setdetailMap, setQuotaMap, quotaDetailMap, quotaMatMap, guidePriceMap, branchMap);
            }

            List<Map> resultMapList = BeanMapper.mapList(detailList, Map.class);
            List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);

            gatherMny(null, treeData);

            treeToList(treeData, entities);
        }

        return makeTarget(entities, budgetProjectVO, proEntity);
    }

    private List<BudgetProjectDetailProEntity> budgetDetail(Integer index, BudgetProjectVO budgetProjectVO,
                                                            Map<Long, BudgetSetDetailEntity> setdetailMap, Map<Long, List<BudgetSetQuotaEntity>> setQuotaMap,
                                                            Map<Long, QuotaDetailEntity> quotaDetailMap, Map<Long, List<QuotaMatEntity>> quotaMatMap,
                                                            Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        List<BudgetProjectDetailProEntity> detailList = new ArrayList<>();
        Map<Long, Long> relationMap = new HashMap<>();
        List<BudgetProjectDetailVO> checkList = budgetProjectVO.getCheckList();
        Collections.sort(checkList, new BudgetDetailComparatoeVo());
        for (BudgetProjectDetailVO detailVO : checkList) {
            if (ConvertResultEnum.已忽略.getCode().equals(detailVO.getResultState()) && detailVO.getLeafFlag()) {
                continue;
            }
            if (null != detailVO.getSetDetailId()) {
                BudgetSetDetailEntity setDetailEntity = setdetailMap.get(detailVO.getSetDetailId());
                List<BudgetSetQuotaEntity> setQuotas = setQuotaMap.get(detailVO.getSetDetailId());
                if (CollectionUtils.isNotEmpty(setQuotas)) {
                    BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
                    detailProEntity.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
                    detailProEntity.setSourceId(budgetProjectVO.getId());
                    detailProEntity.setSourceDetailId(detailVO.getId());
                    detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                    detailProEntity.setId(IdWorker.getId());
                    detailProEntity.setCode(detailVO.getCode());
                    detailProEntity.setName(detailVO.getName());
                    detailProEntity.setSpec(detailVO.getProjectFeature());
                    detailProEntity.setUnit(detailVO.getUnit());
                    detailProEntity.setNum(detailVO.getNum());
                    detailProEntity.setLeafFlag(0);
                    detailProEntity.setSubjectId(detailProEntity.getId());
                    detailProEntity.setSubjectCode(detailProEntity.getCode());
                    detailProEntity.setSubjectName(detailProEntity.getName());
                    detailProEntity.setParentId(relationMap.get(detailVO.getParentId()));
                    detailList.add(detailProEntity);
                    for (int i = 1; i <= setQuotas.size(); i++) {
                        BudgetSetQuotaEntity setQuotaEntity = setQuotas.get(i - 1);
                        QuotaDetailEntity quotaDetailEntity = quotaDetailMap.get(setQuotaEntity.getQuotaId());
                        List<QuotaMatEntity> matEntities = quotaMatMap.get(setQuotaEntity.getQuotaId());
                        detailList.addAll(convert(budgetProjectVO, setDetailEntity, setQuotaEntity, quotaDetailEntity, matEntities, i, detailVO, detailProEntity, guidePriceMap, branchMap));
                    }
                }
            } else {
                //预算的根节点清单，序号+1
                if (null == detailVO.getParentId()) {
                    index++;
                    BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
                    detailProEntity.setDetailIndex(String.valueOf(index));
                    detailProEntity.setSourceId(budgetProjectVO.getId());
                    detailProEntity.setSourceDetailId(detailVO.getId());
                    detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                    detailProEntity.setId(IdWorker.getId());
                    detailProEntity.setCode(detailVO.getCode());
                    detailProEntity.setName(detailVO.getName());
                    detailProEntity.setSpec(detailVO.getProjectFeature());
                    detailProEntity.setUnit(detailVO.getUnit());
                    detailProEntity.setNum(detailVO.getNum());
                    detailProEntity.setLeafFlag(0);
                    detailProEntity.setSubjectId(detailProEntity.getId());
                    detailProEntity.setSubjectCode(detailProEntity.getCode());
                    detailProEntity.setSubjectName(detailProEntity.getName());
                    relationMap.put(detailVO.getId(), detailProEntity.getId());
                    detailList.add(detailProEntity);
                } else if (!detailVO.getLeafFlag()) {//非根节点
                    BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
                    detailProEntity.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
                    detailProEntity.setSourceId(budgetProjectVO.getId());
                    detailProEntity.setSourceDetailId(detailVO.getId());
                    detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                    detailProEntity.setId(IdWorker.getId());
                    detailProEntity.setCode(detailVO.getCode());
                    detailProEntity.setName(detailVO.getName());
                    detailProEntity.setSpec(detailVO.getProjectFeature());
                    detailProEntity.setUnit(detailVO.getUnit());
                    detailProEntity.setNum(detailVO.getNum());
                    detailProEntity.setLeafFlag(0);
                    detailProEntity.setSubjectId(detailProEntity.getId());
                    detailProEntity.setSubjectCode(detailProEntity.getCode());
                    detailProEntity.setSubjectName(detailProEntity.getName());
                    detailProEntity.setParentId(relationMap.get(detailVO.getParentId()));
                    relationMap.put(detailVO.getId(), detailProEntity.getId());
                    detailList.add(detailProEntity);
                } else {
                    BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
                    detailProEntity.setDetailIndex(index + detailVO.getDetailIndex().substring(detailVO.getDetailIndex().indexOf(".")));
                    detailProEntity.setSourceId(budgetProjectVO.getId());
                    detailProEntity.setSourceDetailId(detailVO.getId());
                    detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                    detailProEntity.setId(IdWorker.getId());
                    detailProEntity.setCode(detailVO.getCode());
                    detailProEntity.setName(detailVO.getName());
                    detailProEntity.setSpec(detailVO.getProjectFeature());
                    detailProEntity.setUnit(detailVO.getUnit());
                    detailProEntity.setNum(detailVO.getNum());
                    detailProEntity.setRate(BigDecimal.valueOf(9));
                    detailProEntity.setLeafFlag(1);
                    detailProEntity.setSubjectId(detailProEntity.getId());
                    detailProEntity.setSubjectCode(detailProEntity.getCode());
                    detailProEntity.setSubjectName(detailProEntity.getName());
                    detailProEntity.setParentId(relationMap.get(detailVO.getParentId()));
                    detailList.add(detailProEntity);
                }
            }
        }
        return detailList;
    }

    private List<BudgetProjectDetailProEntity> noBudgetDetail(Integer index, BudgetProjectVO budgetProjectVO,
                                                              Map<Long, BudgetSetDetailEntity> setdetailMap, Map<Long, List<BudgetSetQuotaEntity>> setQuotaMap,
                                                              Map<Long, QuotaDetailEntity> quotaDetailMap, Map<Long, List<QuotaMatEntity>> quotaMatMap,
                                                              Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        List<BudgetProjectDetailProEntity> detailList = new ArrayList<>();
        for (BudgetProjectDetailVO detailVO : budgetProjectVO.getCheckList()) {
            if (ConvertResultEnum.已忽略.getCode().equals(detailVO.getResultState()) || !detailVO.getLeafFlag()) {
                continue;
            }
            if (null != detailVO.getSetDetailId()) {
                BudgetSetDetailEntity setDetailEntity = setdetailMap.get(detailVO.getSetDetailId());
                List<BudgetSetQuotaEntity> setQuotas = setQuotaMap.get(detailVO.getSetDetailId());
                if (CollectionUtils.isNotEmpty(setQuotas)) {
                    for (BudgetSetQuotaEntity setQuotaEntity : setQuotas) {
                        QuotaDetailEntity quotaDetailEntity = quotaDetailMap.get(setQuotaEntity.getQuotaId());
                        List<QuotaMatEntity> matEntities = quotaMatMap.get(setQuotaEntity.getQuotaId());
                        index++;
                        detailList.addAll(convert(budgetProjectVO, setDetailEntity, setQuotaEntity, quotaDetailEntity, matEntities, index, detailVO, null, guidePriceMap, branchMap));
                    }
                }
            } else {
                index++;
                BudgetProjectDetailProEntity detailProEntity = new BudgetProjectDetailProEntity();
                detailProEntity.setDetailIndex(String.valueOf(index));
                detailProEntity.setSourceId(budgetProjectVO.getId());
                detailProEntity.setSourceDetailId(detailVO.getId());
                detailProEntity.setBudgetType(budgetProjectVO.getBudgetType());
                detailProEntity.setId(IdWorker.getId());
                detailProEntity.setCode(detailVO.getCode());
                detailProEntity.setName(detailVO.getName());
                detailProEntity.setSpec(detailVO.getProjectFeature());
                detailProEntity.setUnit(detailVO.getUnit());
                detailProEntity.setNum(detailVO.getNum());
                detailProEntity.setRate(BigDecimal.valueOf(9));
                detailProEntity.setLeafFlag(1);
                detailProEntity.setSubjectId(detailProEntity.getId());
                detailProEntity.setSubjectCode(detailProEntity.getCode());
                detailProEntity.setSubjectName(detailProEntity.getName());
                detailList.add(detailProEntity);
            }
        }
        return detailList;
    }

    @Autowired
    private IBudgetProjectHistoryProService historyProService;

    @Override
    public BudgetProjectProVO compareDetail(Long id, Boolean compareFirst) {
        BudgetProjectProEntity entity = this.selectById(id);
        BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
        List<BudgetProjectDetailProVO> detailList = vo.getDetailList();

        LambdaQueryWrapper<BudgetProjectHistoryProEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectHistoryProEntity::getBudgetId, id);
        if (compareFirst) {
            queryWrapper.orderByAsc(BudgetProjectHistoryProEntity::getCreateTime);
        } else {
            queryWrapper.orderByDesc(BudgetProjectHistoryProEntity::getCreateTime);
        }
        List<BudgetProjectHistoryProEntity> list = historyProService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            BudgetProjectHistoryProEntity budgetProjectHistoryProEntity = list.get(0);
            BudgetProjectHistoryProEntity budgetProjectHistory = historyProService.selectById(budgetProjectHistoryProEntity.getId());
            BudgetProjectHistoryProVO historyVO = BeanMapper.map(budgetProjectHistory, BudgetProjectHistoryProVO.class);

            CompareDifferenceUtil.compareObj(historyVO, vo);
            CompareDifferenceUtil.compareList(historyVO.getDetailList(), vo.getDetailList(), true);

       /*     vo.setBeforeBudgetTaxMny(historyVO.getBudgetTaxMny());
            vo.setBeforeMaterialTaxMny(historyVO.getMaterialTaxMny());
            vo.setBeforeLaborTaxMny(historyVO.getLaborTaxMny());
            vo.setBeforeIndirectionTaxMny(historyVO.getIndirectionTaxMny());

            if (CollectionUtils.isNotEmpty(detailList)) {
                List<BudgetProjectDetailHistoryProVO> historyVODetailList = historyVO.getDetailList();
                Map<Long, BudgetProjectDetailHistoryProVO> map = new HashMap<>();
                if (CollectionUtils.isNotEmpty(historyVODetailList)) {
                    map = historyVODetailList.stream().collect(Collectors.toMap(BudgetProjectDetailHistoryProVO::getBudgetDetailId, Function.identity(), (oldValue, newValue) -> newValue));
                }
                for (BudgetProjectDetailProVO detailVO : detailList) {
                    Long detailVOId = detailVO.getId();
                    BudgetProjectDetailHistoryProVO detailHistoryVO = map.get(detailVOId);
                    if (detailHistoryVO == null) {
                       // detailVO.setChangeFlag(Boolean.TRUE);
                    } else {
                        String code = detailVO.getCode();
                        String historyVOCode = detailHistoryVO.getCode();
                        detailVO.setBeforeCode(historyVOCode);
                        detailVO.setBeforeName(detailHistoryVO.getName());

                        detailVO.setBeforeCostType(detailHistoryVO.getCostType());
                        detailVO.setBeforeSpec(detailHistoryVO.getSpec());
                        detailVO.setBeforeUnit(detailHistoryVO.getUnit());
                        detailVO.setBeforeNum(detailHistoryVO.getNum());
                        detailVO.setBeforeTaxPrice(detailHistoryVO.getTaxPrice());
                        detailVO.setBeforeMaterialTaxMnyCost(detailHistoryVO.getMaterialTaxMnyCost());

                        detailVO.setBeforeLaborTaxMnyCost(detailHistoryVO.getLaborTaxMnyCost());

                        detailVO.setBeforeIndirectionTaxMnyCost(detailHistoryVO.getIndirectionTaxMnyCost());
                        detailVO.setBeforeTaxMny(detailHistoryVO.getTaxMny());


                   *//*     if (isNotEqual(code, detailVO.getBeforeCode())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }
                        if (isNotEqual(detailVO.getName(), detailVO.getBeforeName())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }
                        if (!Optional.ofNullable(detailVO.getCostType()).orElse(0).equals(Optional.ofNullable(detailVO.getBeforeCostType()).orElse(0))) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (isNotEqual(detailVO.getSpec(), detailVO.getBeforeSpec())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (isNotEqual(detailVO.getUnit(), detailVO.getBeforeUnit())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getNum(), detailVO.getBeforeNum())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getTaxPrice(), detailVO.getBeforeTaxPrice())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getMaterialTaxMnyCost(), detailVO.getBeforeMaterialTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getLaborTaxMnyCost(), detailVO.getBeforeLaborTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getIndirectionTaxMnyCost(), detailVO.getBeforeIndirectionTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getTaxMny(), detailVO.getBeforeTaxMny())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                        }*//*

                    }


                }
            }*/

        }

        if (CollectionUtils.isNotEmpty(detailList)) {
            Collections.sort(detailList, new BudgetDetailProComparatoeVo());
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return vo;
    }

    @Override
    public void beforeSaveCheck(List<BudgetProjectDetailProEntity> matchList) {
        if (CollectionUtils.isNotEmpty(matchList)) {
            // 临时物料档案校验
            Boolean tempMaterialFlag = Boolean.FALSE;
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_TEMP_MATERIAL_CODE);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                if (StringUtils.isNotEmpty(valueData)) {
                    tempMaterialFlag = valueData.equals("是");

                }
            }
            if (!tempMaterialFlag) {
                long count = matchList.stream().filter(detailProEntity -> detailProEntity.getCostType() != null && detailProEntity.getCostType() == CostTypeEnum.MATERIAL_COST_TYPE.getType() && !"del".equals(detailProEntity.getRowState()) && detailProEntity.getMatchStatus() != null && !"1".equals(detailProEntity.getMatchStatus().toString())).count();
                if (count > 0) {
                    throw new BusinessException("校验失败，参数【临时物料档案是否开启】未开启，请将未匹配的档案精确替换后重新保存！");
                }
            }

            // 临时人工定额校验
            Boolean tempLaborFlag = Boolean.FALSE;
            CommonResponse<ParamRegisterSetVO> byCodeLabor = paramConfigApi.getByCode(PARAM_TEMP_LBOR_CODE);
            if (byCodeLabor.isSuccess() && null != byCodeLabor.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCodeLabor.getData();
                String valueData = paramRegisterSetVO.getValueData();
                if (StringUtils.isNotEmpty(valueData)) {
                    tempLaborFlag = valueData.equals("是");
                }
            }
            if (!tempLaborFlag) {
                for (BudgetProjectDetailProEntity detailProEntity : matchList) {
                    List<String> detailIndexList = new ArrayList<>();
                    if (detailProEntity.getSourceId() == null && detailProEntity.getCostType() != null && detailProEntity.getCostType() == CostTypeEnum.LABOR_COST_TYPE.getType() && !"del".equals(detailProEntity.getRowState())) {
                        detailIndexList.add(detailProEntity.getDetailIndex());
                    }
                    if (!detailIndexList.isEmpty()) {
                        String detailIndexStr = String.join(",", detailIndexList);
                        throw new BusinessException("校验失败(有" + detailIndexList.size() + "条新增人工费临时定额)，序号为[ " + detailIndexStr + " ]，参数【临时定额库是否开启】未开启，请将新增临时定额处理后重新操作！");
                    }
                }
            }
        }

    }

    private Long makeTarget(List<BudgetProjectDetailProEntity> detailList, BudgetProjectVO budgetVO, BudgetProjectProEntity proEntity) {
        Long targetId = null;
        if (null == proEntity) {
            proEntity = new BudgetProjectProEntity();
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), budgetVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                proEntity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            proEntity.setSourceId(budgetVO.getId());
            proEntity.setTaxRate(BigDecimal.valueOf(9));
            proEntity.setProjectId(budgetVO.getProjectId());
            proEntity.setProjectName(budgetVO.getProjectName());
            proEntity.setOrgId(budgetVO.getOrgId());
            proEntity.setOrgName(budgetVO.getOrgName());
            proEntity.setEmployeeId(budgetVO.getEmployeeId());
            proEntity.setEmployeeName(budgetVO.getEmployeeName());
            proEntity.setDepartmentId(budgetVO.getDepartmentId());
            proEntity.setDepartmentName(budgetVO.getDepartmentName());
            proEntity.setChangeStatus(1);
            proEntity.setDetailList(detailList);
            fullMny(proEntity);
            saveOrUpdate(proEntity, false);
            targetId = proEntity.getId();
        } else {
            BudgetProjectChangeProVO budgetProjectChangeProVO = budgetProjectChangeProService.queryDetailChange(proEntity.getId(), false);
            BudgetProjectChangeProEntity entity = BeanMapper.map(budgetProjectChangeProVO, BudgetProjectChangeProEntity.class);
            BillCodeParam billCodeParam = BillCodeParam.build(CHANGE_BILL_CODE, InvocationInfoProxy.getTenantid(), budgetProjectChangeProVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            Long mainId = IdWorker.getId();
            entity.setId(mainId);
            entity.setSourceId(budgetVO.getId());
            List<BudgetProjectDetailChangeProEntity> changeDetailList = entity.getDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailList)) {
                Map<String, Long> idMap = new HashMap<>();
                for (BudgetProjectDetailChangeProEntity changeProEntity : changeDetailList) {
                    changeProEntity.setBudgetChangeId(mainId);
                    changeProEntity.setId(IdWorker.getId());
                    idMap.put(changeProEntity.getTid(), changeProEntity.getId());
                }
                for (BudgetProjectDetailChangeProEntity cdEntity : changeDetailList) {
                    if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
            }
            for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                BudgetProjectDetailChangeProEntity changeProEntity = BeanMapper.map(detailProEntity, BudgetProjectDetailChangeProEntity.class);
                changeProEntity.setBudgetChangeId(mainId);
                changeDetailList.add(changeProEntity);
            }
            fullMny(entity);
            budgetProjectChangeProService.saveOrUpdate(entity, false);

            //回写主表 变更信息
            LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(BudgetProjectProEntity::getChangeId, entity.getId());//变更主键
            updateWrapper.set(BudgetProjectProEntity::getChangeStatus, 2);//状态：变更中
            updateWrapper.set(BudgetProjectProEntity::getChangeCode, entity.getBillCode());//变更编码
            updateWrapper.set(BudgetProjectProEntity::getChangeVersion, entity.getVersion());//变更编码
            updateWrapper.eq(BudgetProjectProEntity::getId, entity.getBudgetId());
            budgetProService.update(updateWrapper);

            targetId = entity.getBudgetId();
        }
        return targetId;
    }

    private void fullMny(BudgetProjectChangeProEntity proEntity) {
        BigDecimal budgetMny = BigDecimal.ZERO;
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailChangeProEntity detailProEntity : proEntity.getDetailList()) {
                if (null == detailProEntity.getParentId()) {
                    budgetMny = ComputeUtil.safeAdd(budgetMny, detailProEntity.getMny());
                    budgetTaxMny = ComputeUtil.safeAdd(budgetTaxMny, detailProEntity.getTaxMny());
                    laborMny = ComputeUtil.safeAdd(laborMny, detailProEntity.getLaborMnyCost());
                    laborTaxMny = ComputeUtil.safeAdd(laborTaxMny, detailProEntity.getLaborTaxMnyCost());
                    materialMny = ComputeUtil.safeAdd(materialMny, detailProEntity.getMaterialMnyCost());
                    materialTaxMny = ComputeUtil.safeAdd(materialTaxMny, detailProEntity.getMaterialTaxMnyCost());
                }
            }
        }
        proEntity.setBudgetMny(budgetMny);
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborMny(laborMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialMny(materialMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }

    private void fullMny(BudgetProjectProEntity proEntity) {
        BigDecimal budgetMny = BigDecimal.ZERO;
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailProEntity detailProEntity : proEntity.getDetailList()) {
                if (null == detailProEntity.getParentId()) {
                    budgetMny = ComputeUtil.safeAdd(budgetMny, detailProEntity.getMny());
                    budgetTaxMny = ComputeUtil.safeAdd(budgetTaxMny, detailProEntity.getTaxMny());
                    laborMny = ComputeUtil.safeAdd(laborMny, detailProEntity.getLaborMnyCost());
                    laborTaxMny = ComputeUtil.safeAdd(laborTaxMny, detailProEntity.getLaborTaxMnyCost());
                    materialMny = ComputeUtil.safeAdd(materialMny, detailProEntity.getMaterialMnyCost());
                    materialTaxMny = ComputeUtil.safeAdd(materialTaxMny, detailProEntity.getMaterialTaxMnyCost());
                }
            }
        }
        proEntity.setBudgetMny(budgetMny);
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborMny(laborMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialMny(materialMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }

    /**
     * @param budgetProjectVO   项目预算书
     * @param setDetailEntity   清单关系设置子表
     * @param setQuotaEntity    清单关系设置定额
     * @param quotaDetailEntity 定额库子表
     * @param quotaMatList      定额库主材集合
     * @param detailVO          预算书清单
     * @param detailProEntity
     * @param guidePriceMap     指导价
     * @param branchMap
     * @return
     */
    private List<BudgetProjectDetailProEntity> convert(BudgetProjectVO budgetProjectVO, BudgetSetDetailEntity setDetailEntity, BudgetSetQuotaEntity setQuotaEntity,
                                                       QuotaDetailEntity quotaDetailEntity, List<QuotaMatEntity> quotaMatList, Integer index, BudgetProjectDetailVO detailVO,
                                                       BudgetProjectDetailProEntity detailProEntity, Map<String, BigDecimal> guidePriceMap, Map<Long, CategoryBrandVO> branchMap) {
        List<BudgetProjectDetailProEntity> result = new LinkedList<>();
        if (CollectionUtils.isNotEmpty(quotaMatList)) {
            BudgetProjectDetailProEntity parent = new BudgetProjectDetailProEntity();
            parent.setDetailIndex(null == detailProEntity ? String.valueOf(index) : detailProEntity.getDetailIndex() + "." + index);
            parent.setSourceId(budgetProjectVO.getId());
            parent.setSourceDetailId(detailVO.getId());
            parent.setBudgetType(budgetProjectVO.getBudgetType());
            parent.setId(IdWorker.getId());
            parent.setCode(quotaDetailEntity.getDetailCode());
            parent.setName(quotaDetailEntity.getDetailName());
            parent.setSpec(detailVO.getProjectFeature());
            parent.setUnit(detailVO.getUnit());
            parent.setNum(detailVO.getNum());
            parent.setLeafFlag(0);
            parent.setSubjectId(parent.getId());
            parent.setSubjectCode(parent.getCode());
            parent.setSubjectName(parent.getName());
            parent.setParentId(null == detailProEntity ? null : detailProEntity.getId());

            int childIndex = 1;
            List<BudgetProjectDetailProEntity> matList = new LinkedList<>();
            for (QuotaMatEntity matEntity : quotaMatList) {
                BudgetProjectDetailProEntity material = new BudgetProjectDetailProEntity();
                material.setId(IdWorker.getId());
                material.setDetailIndex(parent.getDetailIndex() + "." + childIndex);
                material.setSourceId(budgetProjectVO.getId());
                material.setSourceDetailId(detailVO.getId());
                material.setBudgetType(budgetProjectVO.getBudgetType());
                material.setParentId(parent.getId());
                material.setCategoryId(matEntity.getCategoryId());
                material.setCategoryName(matEntity.getCategoryName());
                material.setMaterialId(matEntity.getMaterialId());
                material.setMaterialName(matEntity.getMaterialName());
                material.setCode(matEntity.getMaterialCode());
                material.setName(matEntity.getMaterialName());
                material.setCostType(2);
                material.setCostTypeName("材料费");
                material.setSpec(matEntity.getMaterialSpec());
                material.setUnit(matEntity.getMaterialUnit());
                BigDecimal convertRate = null == matEntity.getConvertRate() ? BigDecimal.ONE : matEntity.getConvertRate();
                material.setNum(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(detailVO.getNum(), ComputeUtil.safeDiv(setQuotaEntity.getQuotaNum(), setDetailEntity.getDetailNum())), convertRate));
                BigDecimal lossRate = null == matEntity.getLossRate() ? BigDecimal.ONE : matEntity.getLossRate();
                material.setLossRate(lossRate);
                material.setRate(BigDecimal.valueOf(9));
                CategoryBrandVO brandVO = branchMap.get(material.getCategoryId());
                if (null != brandVO) {
                    material.setBrandId(brandVO.getBrandId());
                    material.setBrandName(brandVO.getBrandName());
                }
                BigDecimal guidePrice = guidePriceMap.get(material.getMaterialId().toString() + (null == material.getBrandId() ? null : material.getBrandId().toString()));
                material.setGuidePrice(guidePrice);
                material.setPrice(guidePrice);
                material.setTaxPrice(ComputeUtil.safeMultiply(material.getPrice(), ComputeUtil.safeAdd(BigDecimal.ONE, ComputeUtil.safeDiv(material.getRate(), BigDecimal.valueOf(100)))));
                material.setMaterialMnyCost(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(material.getNum(), material.getPrice()), lossRate));
                material.setMaterialTaxMnyCost(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(material.getNum(), material.getTaxPrice()), lossRate));
                material.setMny(material.getMaterialMnyCost());
                material.setTaxMny(material.getMaterialTaxMnyCost());
                material.setLeafFlag(1);
                material.setSubjectId(material.getId());
                material.setSubjectCode(material.getCode());
                material.setSubjectName(material.getName());
                matList.add(material);

                childIndex++;
            }

            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(parent.getDetailIndex() + "." + childIndex);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setSourceDetailId(detailVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setParentId(parent.getId());
            labor.setCode(quotaDetailEntity.getDetailCode());
            labor.setName(quotaDetailEntity.getDetailName());
            labor.setCostType(1);
            labor.setCostTypeName("人工费");
            labor.setSpec(quotaDetailEntity.getDescription());
            labor.setUnit(quotaDetailEntity.getDetailUnit());
            labor.setRate(BigDecimal.valueOf(9));
            labor.setNum(ComputeUtil.safeMultiply(detailVO.getNum(), ComputeUtil.safeDiv(setQuotaEntity.getQuotaNum(), setDetailEntity.getDetailNum())));
            labor.setPrice(quotaDetailEntity.getLaborPrice());
            labor.setTaxPrice(ComputeUtil.safeMultiply(labor.getPrice(), ComputeUtil.safeAdd(BigDecimal.ONE, ComputeUtil.safeDiv(labor.getRate(), BigDecimal.valueOf(100)))));
            labor.setLaborMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getPrice()));
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getTaxPrice()));
            labor.setMny(labor.getLaborMnyCost());
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(1);
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());

            result.add(parent);
            result.addAll(matList);
            result.add(labor);
        } else {
            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(null == detailProEntity ? String.valueOf(index) : detailProEntity.getDetailIndex() + "." + index);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setSourceDetailId(detailVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setCode(quotaDetailEntity.getDetailCode());
            labor.setName(quotaDetailEntity.getDetailName());
            labor.setCostType(1);
            labor.setCostTypeName("人工费");
            labor.setSpec(quotaDetailEntity.getDescription());
            labor.setUnit(quotaDetailEntity.getDetailUnit());
            labor.setRate(BigDecimal.valueOf(9));
            labor.setNum(ComputeUtil.safeMultiply(detailVO.getNum(), ComputeUtil.safeDiv(setQuotaEntity.getQuotaNum(), setDetailEntity.getDetailNum())));
            labor.setPrice(quotaDetailEntity.getLaborPrice());
            labor.setTaxPrice(ComputeUtil.safeMultiply(labor.getPrice(), ComputeUtil.safeAdd(BigDecimal.ONE, ComputeUtil.safeDiv(labor.getRate(), BigDecimal.valueOf(100)))));
            labor.setLaborMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getPrice()));
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getTaxPrice()));
            labor.setMny(labor.getLaborMnyCost());
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(1);
            labor.setParentId(null == detailProEntity ? null : detailProEntity.getId());
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());
            result.add(labor);
        }
        return result;
    }

    /**
     * 汇总金额和数量
     */
    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal materialMnyCost = null;
        BigDecimal materialTaxMnyCost = null;
        BigDecimal laborMnyCost = null;
        BigDecimal laborTaxMnyCost = null;
        BigDecimal indirectionMnyCost = null;
        BigDecimal indirectionTaxMnyCost = null;
        BigDecimal mechanicalMnyCost = null;
        BigDecimal mechanicalTaxMnyCost = null;

        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMny(ypd, (List) ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, getBigDecimalValue(ypd, "taxMny"));
            materialMnyCost = ComputeUtil.safeAdd(materialMnyCost, getBigDecimalValue(ypd, "materialMnyCost"));
            materialTaxMnyCost = ComputeUtil.safeAdd(materialTaxMnyCost, getBigDecimalValue(ypd, "materialTaxMnyCost"));
            laborMnyCost = ComputeUtil.safeAdd(laborMnyCost, getBigDecimalValue(ypd, "laborMnyCost"));
            laborTaxMnyCost = ComputeUtil.safeAdd(laborTaxMnyCost, getBigDecimalValue(ypd, "laborTaxMnyCost"));
            indirectionMnyCost = ComputeUtil.safeAdd(indirectionMnyCost, getBigDecimalValue(ypd, "indirectionMnyCost"));
            indirectionTaxMnyCost = ComputeUtil.safeAdd(indirectionTaxMnyCost, getBigDecimalValue(ypd, "indirectionTaxMnyCost"));
            mechanicalMnyCost = ComputeUtil.safeAdd(mechanicalMnyCost, getBigDecimalValue(ypd, "mechanicalMnyCost"));
            mechanicalTaxMnyCost = ComputeUtil.safeAdd(mechanicalTaxMnyCost, getBigDecimalValue(ypd, "mechanicalTaxMnyCost"));
        }
        if (now != null) {
            now.put("mny", mny);
            now.put("taxMny", taxMny);
            now.put("materialMnyCost", materialMnyCost);
            now.put("materialTaxMnyCost", materialTaxMnyCost);
            now.put("laborMnyCost", laborMnyCost);
            now.put("laborTaxMnyCost", laborTaxMnyCost);
            now.put("indirectionMnyCost", indirectionMnyCost);
            now.put("indirectionTaxMnyCost", indirectionTaxMnyCost);
            now.put("mechanicalMnyCost", mechanicalMnyCost);
            now.put("mechanicalTaxMnyCost", mechanicalTaxMnyCost);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }

    private void treeToList(List<Map<String, Object>> treeData, List<BudgetProjectDetailProEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, BudgetProjectDetailProEntity.class));
        }
    }
}
