package com.ejianc.business.target.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.target.bean.TargetCostFinishDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 目标成本完工统计
 * 
 * @author generator
 * 
 */
 @TableName("ejc_target_cost_finish")
public class TargetCostFinishEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="budget_id")
    private Long budgetId; // 预算
    @TableField(value="budget_name")
    private String budgetName; // 预算
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 预算总金额
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bill_date")
    private Date billDate; // 统计日期
    @TableField(value="labor_tax_mny")
    private BigDecimal laborTaxMny; // 本期人工费
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 本期材料费
    @TableField(value="major_tax_mny")
    private BigDecimal majorTaxMny; // 本期专业分包费
    @TableField(value="mechanical_tax_mny")
    private BigDecimal mechanicalTaxMny; // 本期机械费
    @TableField(value="indirection_tax_mny")
    private BigDecimal indirectionTaxMny; // 本期间接费
    @TableField(value="finish_tax_mny")
    private BigDecimal finishTaxMny; // 本期完工总金额
    @TableField(value="sum_finish_tax_mny")
    private BigDecimal sumFinishTaxMny; // (不含本期)
    @TableField(value="sum_finish_tax_mny_endthis")
    private BigDecimal sumFinishTaxMnyEndthis; // 累计完工总金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="remark")
    private String remark; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="targetCostFinishDetailService", pidName = "costFinishId")
    private List<TargetCostFinishDetailEntity> targetCostFinishDetailList = new ArrayList<>(); // 目标成本完工统计明细


    public BigDecimal getSumFinishTaxMnyEndthis() {
        return sumFinishTaxMnyEndthis;
    }

    public void setSumFinishTaxMnyEndthis(BigDecimal sumFinishTaxMnyEndthis) {
        this.sumFinishTaxMnyEndthis = sumFinishTaxMnyEndthis;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getBudgetName() {
        return budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }
    public BigDecimal getSumFinishTaxMny() {
        return sumFinishTaxMny;
    }

    public void setSumFinishTaxMny(BigDecimal sumFinishTaxMny) {
        this.sumFinishTaxMny = sumFinishTaxMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
    public List<TargetCostFinishDetailEntity> getTargetCostFinishDetailList() {
        return targetCostFinishDetailList;
    }

    public void setTargetCostFinishDetailList(List<TargetCostFinishDetailEntity> targetCostFinishDetailList) {
        this.targetCostFinishDetailList = targetCostFinishDetailList;
    }
}
