/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaDetailTemporaryEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.bean.QuotaMatTemporaryEntity;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaDetailTemporaryService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.service.IQuotaMatTemporaryService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.vo.QuotaDetailAccessVO;
import com.ejianc.business.budget.vo.QuotaDetailTemporaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"quotaDetailTemporary"})
public class QuotaDetailTemporaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IQuotaDetailTemporaryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IQuotaDetailService detailService;
    @Autowired
    private IQuotaService quotaService;
    @Autowired
    private IQuotaMatTemporaryService quotaMatTemporaryService;
    @Autowired
    private IQuotaMatService quotaMatService;

    @RequestMapping(value={"/batchAccess"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> batchAccess(@RequestBody QuotaDetailAccessVO accessVO) {
        Long quotaTypeId = accessVO.getQuotaTypeId();
        if (quotaTypeId == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5b9a\u989d\u5e93\u5206\u7c7b!");
        }
        List detailIds = accessVO.getDetailIds();
        if (CollectionUtils.isEmpty((Collection)detailIds)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5b9a\u989d\u5e93\u660e\u7ec6!");
        }
        List detailTemporaryEntities = (List)this.service.listByIds(detailIds);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(QuotaEntity::getEnableState, (Object)1);
        QuotaEntity quotaEntity = (QuotaEntity)((Object)this.quotaService.getOne((Wrapper)queryWrapper, false));
        if (quotaEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u542f\u7528\u7684\u5b9a\u989d\u5e93!");
        }
        Long quotaId = quotaEntity.getId();
        List detailCodes = detailTemporaryEntities.stream().filter(t -> t.getDetailCode() != null).map(e -> e.getDetailCode()).collect(Collectors.toList());
        LambdaQueryWrapper detailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        detailEntityLambdaQueryWrapper.eq(QuotaDetailEntity::getQuotaId, (Object)quotaId);
        detailEntityLambdaQueryWrapper.in(QuotaDetailEntity::getDetailCode, detailCodes);
        List list = this.detailService.list((Wrapper)detailEntityLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List repeatDetailCodes = list.stream().filter(t -> t.getDetailCode() != null).map(e -> e.getDetailCode()).collect(Collectors.toList());
            throw new BusinessException(Joiner.on((String)",").join(repeatDetailCodes) + "\u5b9a\u989d\u7f16\u7801\u91cd\u590d\uff0c\u4fee\u6539\u540e\u518d\u5165\u5e93\uff01");
        }
        for (QuotaDetailTemporaryEntity detailTemporaryEntity : detailTemporaryEntities) {
            detailTemporaryEntity.setQuotaId(quotaId);
            detailTemporaryEntity.setQuotaTypeId(quotaTypeId);
            detailTemporaryEntity.setPushFlag(1);
        }
        List quotaDetailEntities = BeanMapper.mapList((Iterable)detailTemporaryEntities, QuotaDetailEntity.class);
        boolean b = this.detailService.saveOrUpdateBatch(quotaDetailEntities);
        if (b) {
            LambdaQueryWrapper matTemporaryEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            matTemporaryEntityLambdaQueryWrapper.in(QuotaMatTemporaryEntity::getQuotaDetailId, (Collection)detailIds);
            List quotaMatTemporaryEntities = this.quotaMatTemporaryService.list((Wrapper)matTemporaryEntityLambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)quotaMatTemporaryEntities)) {
                for (QuotaMatTemporaryEntity quotaMatTemporaryEntity : quotaMatTemporaryEntities) {
                    quotaMatTemporaryEntity.setQuotaId(quotaId);
                    quotaMatTemporaryEntity.setQuotaTypeId(quotaTypeId);
                }
                List quotaMatEntities = BeanMapper.mapList((Iterable)quotaMatTemporaryEntities, QuotaMatEntity.class);
                this.quotaMatService.saveOrUpdateBatch(quotaMatEntities);
            }
            this.service.saveOrUpdateBatch(detailTemporaryEntities);
        }
        return CommonResponse.success((String)"\u51c6\u5165\u6b63\u5f0f\u5e93\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotaDetailTemporaryVO> saveOrUpdate(@RequestBody QuotaDetailTemporaryVO saveOrUpdateVO) {
        QuotaDetailTemporaryEntity entity = (QuotaDetailTemporaryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, QuotaDetailTemporaryEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getMatList())) {
            List nameList = entity.getMatList().stream().filter(x -> !"del".equals(x.getRowState())).map(QuotaMatTemporaryEntity::getMaterialName).collect(Collectors.toList());
            entity.setMatName(StringUtils.join(nameList, (String)","));
        }
        entity.setPushFlag(0);
        this.service.saveOrUpdate((Object)entity, false);
        QuotaDetailTemporaryVO vo = (QuotaDetailTemporaryVO)BeanMapper.map((Object)((Object)entity), QuotaDetailTemporaryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuotaDetailTemporaryVO> queryDetail(Long id) {
        QuotaDetailTemporaryEntity entity = (QuotaDetailTemporaryEntity)((Object)this.service.selectById(id));
        QuotaDetailTemporaryVO vo = (QuotaDetailTemporaryVO)BeanMapper.map((Object)((Object)entity), QuotaDetailTemporaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaDetailTemporaryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (QuotaDetailTemporaryVO quotaDetailTemporaryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailTemporaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("detailCode", "detailName", "sourceProjectName", "sourceBillCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("pushFlag", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotaDetailTemporaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("QuotaDetailTemporary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuotaDetailTemporaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuotaDetailTemporaryVO>> refQuotaDetailTemporaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotaDetailTemporaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

