/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetProjectDetailProService")
public class BudgetProjectDetailProServiceImpl
extends BaseServiceImpl<BudgetProjectDetailProMapper, BudgetProjectDetailProEntity>
implements IBudgetProjectDetailProService {
    @Autowired
    private IMaterialApi materialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandApi brandApi;
    @Autowired
    private IGuidePriceDetailService guidePriceDetailService;
    @Autowired
    private IQuotaService quotaService;
    @Autowired
    private IQuotaDetailService quotaDetailService;

    @Override
    public CommonResponse<JSONObject> excelImportForHK(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = HuaKangExcelReader.readExcel((MultipartFile)mf, (Integer)1, (Integer)1);
        if (result != null && result.size() > 0) {
            int detailIndexCellNum = 0;
            int codeCellNum = 1;
            int nameCellNum = 2;
            int specCellNum = 3;
            int unitCellNum = 4;
            int numCellNum = 5;
            int taxPriceCellNum = 6;
            int taxMnyCellNum = 7;
            int indexKnownNum = 0;
            Iterator iterator = result.iterator();
            int row = 0;
            while (iterator.hasNext()) {
                List datas = (List)iterator.next();
                int _indexKnownNum = indexKnownNum;
                for (int j = 0; j < datas.size(); ++j) {
                    String s = (String)datas.get(j);
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5e8f\u53f7")) {
                        detailIndexCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u7f16\u7801")) {
                        codeCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u540d\u79f0")) {
                        nameCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u7279\u5f81\u63cf\u8ff0")) {
                        specCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u8ba1\u91cf\u5355\u4f4d")) {
                        unitCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5de5\u7a0b\u91cf")) {
                        numCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u7efc\u5408\u5355\u4ef7")) {
                        taxPriceCellNum = j;
                        ++indexKnownNum;
                        continue;
                    }
                    if (!s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5408\u4ef7")) continue;
                    taxMnyCellNum = j;
                    ++indexKnownNum;
                }
                ++row;
                if (indexKnownNum > _indexKnownNum) {
                    iterator.remove();
                }
                if (indexKnownNum == 8) break;
                if (indexKnownNum >= 8 || row <= 10) continue;
                throw new BusinessException("\u672a\u8bc6\u522b\u8868\u5934\u5b57\u6bb5\u4fe1\u606f");
            }
            int engineeringNameIndex = 0;
            int nameIndex = 0;
            int itemIndex = 0;
            String engineeringtpid = "";
            String tpid = "";
            ArrayList<BudgetProjectDetailProVO> detailVoList = new ArrayList<BudgetProjectDetailProVO>();
            for (int i = 0; i < result.size(); ++i) {
                String unit;
                List datas = (List)result.get(i);
                boolean isTitle = false;
                for (int j = 0; j < datas.size(); ++j) {
                    String s = (String)datas.get(j);
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5e8f\u53f7")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u7f16\u7801")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u540d\u79f0")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u9879\u76ee\u7279\u5f81\u63cf\u8ff0")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u8ba1\u91cf\u5355\u4f4d")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5de5\u7a0b\u91cf")) {
                        isTitle = true;
                        continue;
                    }
                    if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u7efc\u5408\u5355\u4ef7")) {
                        isTitle = true;
                        continue;
                    }
                    if (!s.replaceAll("\\n|\\r|\\r\\n", "").contains("\u5408\u4ef7")) continue;
                    isTitle = true;
                }
                if (isTitle) continue;
                BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                boolean flag = false;
                boolean parentWarn = false;
                String detailIndex = (String)datas.get(detailIndexCellNum);
                String name = (String)datas.get(nameCellNum);
                String code = (String)datas.get(codeCellNum);
                if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)detailIndex)) {
                    if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                        if (detailIndex.contains("\u5de5\u7a0b\u540d\u79f0")) {
                            String engineeringName = detailIndex.replaceAll("\u5de5\u7a0b\u540d\u79f0\uff1a", "").trim();
                            vo.setDetailIndex(String.valueOf(++engineeringNameIndex));
                            vo.setName(engineeringName);
                            engineeringtpid = vo.getDetailIndex();
                            vo.setTid(vo.getDetailIndex());
                            nameIndex = 0;
                            vo.setImportFlag(Boolean.valueOf(true));
                            vo.setParentWarn(Boolean.valueOf(false));
                            vo.setCostType(Integer.valueOf(0));
                            vo.setRowState("add");
                            vo.setArchiveFlag("2");
                            vo.setShadowId(vo.getTid());
                            String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                            vo.setKey(key);
                            detailVoList.add(vo);
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)name)) continue;
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                    vo.setDetailIndex(engineeringNameIndex + "." + ++nameIndex);
                    vo.setName(name);
                    vo.setTpid(engineeringtpid);
                    vo.setTid(vo.getDetailIndex());
                    tpid = vo.getDetailIndex();
                    itemIndex = 0;
                    vo.setImportFlag(Boolean.valueOf(true));
                    vo.setParentWarn(Boolean.valueOf(false));
                    vo.setCostType(Integer.valueOf(0));
                    vo.setRowState("add");
                    vo.setArchiveFlag("2");
                    vo.setShadowId(vo.getTid());
                    String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                    vo.setKey(key);
                    detailVoList.add(vo);
                    continue;
                }
                String warnType = "";
                vo.setDetailIndex(engineeringNameIndex + "." + nameIndex + "." + ++itemIndex);
                vo.setTid(vo.getDetailIndex());
                vo.setTpid(tpid);
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName(name.replace(" ", ""));
                }
                vo.setCostType(Integer.valueOf(2));
                vo.setMaterialName(vo.getName());
                vo.setEntryType("1");
                String spec = (String)datas.get(specCellNum);
                if (!"1".equals(vo.getEntryType()) || !StringUtils.isEmpty((CharSequence)spec)) {
                    if (StringUtils.isNotEmpty((CharSequence)(spec = BudgetProjectDetailProServiceImpl.handleBlankString(spec.replace(" ", ""), true))) && spec.length() > 2000) {
                        flag = true;
                        warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                    }
                    vo.setSpec(spec);
                }
                if (StringUtils.isNotEmpty((CharSequence)(unit = (String)datas.get(unitCellNum))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    unit = BudgetProjectDetailProServiceImpl.handleBlankString(unit.replace(" ", ""), true);
                    vo.setUnit(unit);
                }
                if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                    String num = (String)datas.get(numCellNum);
                    if (StringUtils.isEmpty((CharSequence)num)) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(num));
                        }
                        catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    String taxPrice = (String)datas.get(taxPriceCellNum);
                    if (StringUtils.isNotEmpty((CharSequence)taxPrice)) {
                        try {
                            vo.setTaxPrice(new BigDecimal(taxPrice));
                        }
                        catch (Exception e) {
                            vo.setTaxPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (null == vo.getTaxPrice()) {
                        if (null != vo.getPrice()) {
                            if (null == vo.getRate()) {
                                vo.setTaxPrice(vo.getPrice());
                            } else {
                                BigDecimal add = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1));
                                vo.setTaxPrice(vo.getPrice().multiply(add));
                            }
                        }
                    } else if (null == vo.getPrice()) {
                        if (null == vo.getRate()) {
                            vo.setPrice(vo.getTaxPrice());
                        } else {
                            BigDecimal price = ComputeUtil.safeDiv((BigDecimal)vo.getTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1)));
                            vo.setPrice(price);
                        }
                    }
                }
                if (null != vo.getNum() && null != vo.getTaxPrice()) {
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getTaxPrice());
                    BigDecimal mny = null;
                    vo.setTaxMny(taxMny);
                    if (vo.getRate() != null) {
                        mny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getPrice());
                        vo.setMny(mny);
                    } else {
                        vo.setTaxMny(taxMny);
                        vo.setMny(taxMny);
                    }
                    if (vo.getCostType() != null) {
                        if (vo.getCostType() == 1) {
                            vo.setLaborTaxMnyCost(vo.getTaxMny());
                            vo.setLaborMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 2) {
                            vo.setMaterialMnyCost(vo.getMny());
                            vo.setMaterialTaxMnyCost(vo.getTaxMny());
                        }
                        if (vo.getCostType() == 3) {
                            vo.setMajorTaxMnyCost(vo.getTaxMny());
                            vo.setMajorMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 4) {
                            vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                            vo.setMechanicalMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 5) {
                            vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                            vo.setIndirectionMnyCost(vo.getMny());
                        }
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setArchiveFlag("2");
                vo.setShadowId(vo.getTid());
                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                vo.setKey(key);
                detailVoList.add(vo);
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag2((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List oldErrList = (List)allList.get(1);
            List successListMap = (List)allList.get(0);
            List errorList = ExcelImportUtil.treeToList((List)oldErrList);
            resp.put("successList", (Object)successListMap);
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            LambdaQueryWrapper quotaEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
            quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getEnableState, (Object)1);
            quotaEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            QuotaEntity quotaEntity = (QuotaEntity)((Object)this.quotaService.getOne((Wrapper)quotaEntityLambdaQueryWrapper, false));
            Map<Object, Object> quotaDetailMap = new HashMap();
            if (null != quotaEntity) {
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(QuotaDetailEntity::getQuotaId, (Object)quotaEntity.getId());
                List list = this.quotaDetailService.list((Wrapper)queryWrapper);
                quotaDetailMap = list.stream().collect(Collectors.toMap(QuotaDetailEntity::getDetailCode, BaseEntity::getId, (key1, key2) -> key2));
            }
            String taxRatePar = request.getParameter("taxRate");
            BigDecimal taxRate = ComputeUtil.toBigDecimal((String)taxRatePar);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetProjectDetailProVO> detailVoList = new ArrayList<BudgetProjectDetailProVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                String entryType;
                Object costType;
                List datas = (List)result.get(i);
                BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (!indexMap.containsKey(detailIndex)) {
                    indexMap.put(detailIndex, i);
                }
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    costType = (String)datas.get(1);
                    if (((String)costType).equals("/")) {
                        vo.setCostType(Integer.valueOf(0));
                    }
                    if (((String)costType).equals("\u4eba\u5de5\u8d39")) {
                        vo.setCostType(Integer.valueOf(1));
                        vo.setRate(taxRate);
                    }
                    if (((String)costType).equals("\u6750\u6599\u8d39")) {
                        vo.setCostType(Integer.valueOf(2));
                        vo.setMaterialName(vo.getName());
                        vo.setRate(taxRate);
                    }
                    if (((String)costType).equals("\u95f4\u63a5\u8d39")) {
                        vo.setCostType(Integer.valueOf(5));
                        vo.setRate(taxRate);
                    }
                    if (((String)costType).equals("\u5176\u4ed6\u8d39")) {
                        vo.setCostType(Integer.valueOf(4));
                        vo.setRate(taxRate);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    entryType = (String)datas.get(2);
                    if (entryType.equals("\u6863\u6848")) {
                        if (vo.getCostType() != 2) {
                            warnType = warnType + "\u6750\u6599\u7c7b\u578b\u4e3a\u6863\u6848\u65f6\uff0c\u8d39\u7528\u7c7b\u578b\u5fc5\u987b\u4e3a\u6750\u6599\u8d39!,";
                            flag = true;
                            parentWarn = true;
                        }
                        vo.setEntryType("1");
                    }
                    if (entryType.equals("\u624b\u52a8\u5f55\u5165")) {
                        vo.setEntryType("0");
                    }
                }
                if (vo.getCostType() != null && vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    entryType = (String)datas.get(2);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setCategoryName(null);
                        warnType = warnType + "\u6750\u6599\u7c7b\u578b\u4e3a\u7a7a,";
                        flag = true;
                        parentWarn = true;
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                        String categoryName = ((String)datas.get(3)).replace(" ", "");
                        vo.setCategoryName(categoryName);
                    }
                    if ((costType = vo.getCostType()) != null && ((Integer)costType == 1 || (Integer)costType == 4 || (Integer)costType == 5)) {
                        vo.setCategoryName(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(4));
                    costType = vo.getCostType();
                    if (costType != null && (Integer)costType == 1 && StringUtils.isNotEmpty((CharSequence)vo.getCode())) {
                        Long sourceId = (Long)quotaDetailMap.get(vo.getCode());
                        vo.setSourceId(sourceId);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    String name = ((String)datas.get(5)).replace(" ", "");
                    vo.setName(name);
                }
                if (vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    entryType = (String)datas.get(2);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setSpec(null);
                        warnType = warnType + "\u7279\u5f81/\u89c4\u683c\u578b\u53f7,";
                        flag = true;
                        parentWarn = true;
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    String spec = ((String)datas.get(6)).replace(" ", "");
                    if (StringUtils.isNotEmpty((CharSequence)(spec = BudgetProjectDetailProServiceImpl.handleBlankString(spec, true))) && spec.length() > 2000) {
                        flag = true;
                        warnType = warnType + "\u7279\u5f81/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                    }
                    vo.setSpec(spec);
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    String unit = ((String)datas.get(7)).replace(" ", "");
                    unit = BudgetProjectDetailProServiceImpl.handleBlankString(unit, true);
                    vo.setUnit(unit);
                }
                if (vo.getCostType() != null && vo.getCostType().equals(0) && StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal((String)datas.get(8)));
                        }
                        catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(9))) && vo.getCostType() != null && vo.getCostType() == 2) {
                        try {
                            vo.setLossRate(new BigDecimal((String)datas.get(9)));
                        }
                        catch (Exception e) {
                            vo.setLossRate(null);
                            warnType = warnType + "\u6750\u6599\u635f\u8017\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(10))) && vo.getCostType() != null && vo.getCostType() == 2) {
                        String brandName = ((String)datas.get(10)).trim();
                        CommonResponse brandVOCommonResponse = this.brandApi.queryBrandByName(brandName);
                        if (brandVOCommonResponse.isSuccess() && brandVOCommonResponse.getData() != null) {
                            vo.setBrandId(((BrandVO)brandVOCommonResponse.getData()).getId());
                            vo.setBrandName(((BrandVO)brandVOCommonResponse.getData()).getBrandName());
                        } else {
                            warnType = warnType + "\u54c1\u724c\u4e0d\u5b58\u5728,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(11))) && vo.getCostType() != null && vo.getCostType() == 1) {
                        try {
                            vo.setCompeteFactor(new BigDecimal((String)datas.get(11)));
                        }
                        catch (Exception e) {
                            vo.setCompeteFactor(null);
                            warnType = warnType + "\u7ade\u8058\u7cfb\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(12)))) {
                        try {
                            vo.setPrice(new BigDecimal((String)datas.get(12)));
                        }
                        catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (null == vo.getTaxPrice()) {
                        if (null != vo.getPrice()) {
                            if (null == vo.getRate()) {
                                vo.setTaxPrice(vo.getPrice());
                            } else {
                                BigDecimal add = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1));
                                vo.setTaxPrice(vo.getPrice().multiply(add));
                            }
                        }
                    } else if (null == vo.getPrice()) {
                        if (null == vo.getRate()) {
                            vo.setPrice(vo.getTaxPrice());
                        } else {
                            BigDecimal price = ComputeUtil.safeDiv((BigDecimal)vo.getTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1)));
                            vo.setPrice(price);
                        }
                    }
                }
                if (null != vo.getNum() && null != vo.getTaxPrice()) {
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getTaxPrice());
                    BigDecimal mny = null;
                    vo.setTaxMny(taxMny);
                    if (vo.getRate() != null) {
                        mny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getPrice());
                        vo.setMny(mny);
                    } else {
                        vo.setTaxMny(taxMny);
                        vo.setMny(taxMny);
                    }
                    if (vo.getCostType() != null) {
                        if (vo.getCostType() == 1) {
                            vo.setLaborTaxMnyCost(vo.getTaxMny());
                            vo.setLaborMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 2) {
                            vo.setMaterialMnyCost(vo.getMny());
                            vo.setMaterialTaxMnyCost(vo.getTaxMny());
                        }
                        if (vo.getCostType() == 5) {
                            vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                            vo.setIndirectionMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 4) {
                            vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                            vo.setMechanicalMnyCost(vo.getMny());
                        }
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setArchiveFlag("2");
                vo.setShadowId(vo.getTid());
                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                vo.setKey(key);
                detailVoList.add(vo);
            }
            for (BudgetProjectDetailProVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag2((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List oldErrList = (List)allList.get(1);
            List<Map<String, Object>> successListMap = (List<Map<String, Object>>)allList.get(0);
            MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, Boolean> materialHashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> equipmentCategoryMap = new HashMap<String, Boolean>();
            materialFuzzyMatchVO = this.checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
            this.logger.info("\u7269\u8d44\u5206\u7c7b\u662f\u5426\u5b58\u5728:" + JSONObject.toJSONString((Object)materialFuzzyMatchVO));
            Map materialCategoryMap = null;
            Map equipmentCategoryProMap = null;
            CommonResponse materialFuzzyMatchVOCommonResponse = this.materialApi.checkArchive(materialFuzzyMatchVO);
            if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse.getData();
                materialCategoryMap = data.getMaterialCategoryMap();
                equipmentCategoryProMap = data.getEquipmentCategoryMap();
                List newList = ExcelImportUtil.importCheckCategoryName((List)successListMap, (Map)materialCategoryMap, (Map)equipmentCategoryProMap);
                ArrayList newfalseList = new ArrayList();
                List newAllList = ExcelImportUtil.separate((List)newList, newfalseList);
                successListMap = (List)newAllList.get(0);
                oldErrList.addAll((Collection)newAllList.get(1));
            }
            List errorList = ExcelImportUtil.treeToList((List)oldErrList);
            MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<String, MaterialPlusVO>();
            materialNumberFuzzyMatchVO = this.queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
            this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u7cca\u6570\u91cf:" + JSONObject.toJSONString((Object)materialNumberFuzzyMatchVO));
            CommonResponse materialFuzzyMatchVOCommonResponse1 = this.materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
            Map materialPlusMapVO = null;
            if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse1.getData();
                materialPlusMapVO = data.getFuzzyMatchMap();
                Map<String, BigDecimal> guidePriceMap = this.guidePriceDetailService.queryGuidePriceDetailData();
                successListMap = this.setFuzzyMatch(successListMap, materialPlusMapVO, guidePriceMap);
            } else {
                this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u67e5\u8be2:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
            }
            resp.put("successList", (Object)successListMap);
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    public MaterialFuzzyMatchVO checkCategoryName(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialFuzzyMatchVO, HashMap<String, Boolean> materialHashMap, HashMap<String, Boolean> equipmentCategoryMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                String entryType;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.checkCategoryName(list, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String categoryName = (String)stringObjectMap.get("categoryName");
                String string = entryType = stringObjectMap.get("entryType") != null ? (String)stringObjectMap.get("entryType") : null;
                if (costType == null || costType != 2 || entryType == null || !entryType.equals("1")) continue;
                materialHashMap.put(categoryName, false);
            }
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
        }
        return materialFuzzyMatchVO;
    }

    public MaterialFuzzyMatchVO queryNumberFuzzy(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialNumberFuzzyMatchVO, HashMap<String, MaterialPlusVO> fuzzyMatchMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                String entryType;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.queryNumberFuzzy(list, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String categoryName = (String)stringObjectMap.get("categoryName");
                String string = entryType = stringObjectMap.get("entryType") != null ? (String)stringObjectMap.get("entryType") : null;
                if (costType == null || costType != 2 || entryType == null || !entryType.equals("1")) continue;
                materialNumberFuzzyMatchVO.setType(Integer.valueOf(1));
                MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                materialPlusVO.setType(Integer.valueOf(1));
                materialPlusVO.setCategoryName(categoryName);
                String spec = (String)stringObjectMap.get("spec");
                materialPlusVO.setSpec(spec);
                String name = (String)stringObjectMap.get("name");
                materialPlusVO.setName(name);
                String unit = (String)stringObjectMap.get("unit");
                materialPlusVO.setCategoryName(categoryName);
                materialPlusVO.setUnitName(unit);
                fuzzyMatchMap.put(stringObjectMap.get("key").toString(), materialPlusVO);
            }
            materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
        }
        return materialNumberFuzzyMatchVO;
    }

    public List<Map<String, Object>> setFuzzyMatch(List<Map<String, Object>> successListMap, Map<String, MaterialPlusVO> materialPlusMapVO, Map<String, BigDecimal> guidePriceMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                MaterialPlusVO materialPlusVO;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.setFuzzyMatch(list, materialPlusMapVO, guidePriceMap);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String key = (String)stringObjectMap.get("key");
                if (materialPlusMapVO == null || (materialPlusVO = materialPlusMapVO.get(key)) == null) continue;
                Integer matchStatus = materialPlusVO.getMatchStatus();
                Integer type = materialPlusVO.getType();
                if (matchStatus != null && matchStatus == 1) {
                    stringObjectMap.put("categoryId", materialPlusVO.getCategoryId());
                    stringObjectMap.put("categoryName", materialPlusVO.getCategoryName());
                    stringObjectMap.put("materialId", materialPlusVO.getId());
                    Object brandId = stringObjectMap.get("brandId");
                    String mkey = materialPlusVO.getId().toString() + (null == brandId ? null : brandId.toString());
                    stringObjectMap.put("guidePrice", guidePriceMap.get(mkey));
                    stringObjectMap.put("materialName", materialPlusVO.getName());
                    stringObjectMap.put("spec", materialPlusVO.getSpec());
                    stringObjectMap.put("unit", materialPlusVO.getUnitName());
                }
                Integer matchNumber = materialPlusVO.getMatchNumber();
                String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                stringObjectMap.put("matchStatus", matchStatus);
                stringObjectMap.put("matchNumber", matchNumber);
                stringObjectMap.put("matchStatusDescription", matchStatusDescription);
            }
        }
        return successListMap;
    }

    private static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (flag) {
            return str.trim();
        }
        return str.replaceAll("\\s*", "");
    }
}

