/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.mapper.GuidePriceMapper;
import com.ejianc.business.cost.service.IGuidePriceService;
import com.ejianc.business.cost.vo.GuidePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="guidePriceService")
public class GuidePriceServiceImpl
extends BaseServiceImpl<GuidePriceMapper, GuidePriceEntity>
implements IGuidePriceService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDJ-CODE";

    @Override
    public CommonResponse<GuidePriceVO> saveOrUpdate(GuidePriceVO guidePriceVO) {
        GuidePriceEntity entity = (GuidePriceEntity)((Object)BeanMapper.map((Object)guidePriceVO, GuidePriceEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)guidePriceVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        GuidePriceVO vo = (GuidePriceVO)BeanMapper.map((Object)((Object)entity), GuidePriceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

