package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.enums.ConvertResultEnum;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目预算
 *
 * @author generator
 */
@Controller
@RequestMapping("budgetProject")
public class BudgetProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBudgetProjectService service;

    @Autowired
    private IBudgetProjectDetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> saveOrUpdate(@RequestBody BudgetProjectVO saveorUpdateVO) {
//    	BudgetProjectEntity entity = BeanMapper.map(saveorUpdateVO, BudgetProjectEntity.class);
//    	service.saveOrUpdate(entity, false);
//    	BudgetProjectVO vo = BeanMapper.map(entity, BudgetProjectVO.class);
        CommonResponse<BudgetProjectVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> queryDetail(Long id) {
//    	BudgetProjectEntity entity = service.selectById(id);
//    	BudgetProjectVO vo = BeanMapper.map(entity, BudgetProjectVO.class);
//        return CommonResponse.success("查询详情数据成功！",vo);
        BudgetProjectVO vo = service.queryDetail(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectVO> vos) {
        service.removeByIds(vos.stream().map(BudgetProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BudgetProjectEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    // 关联科目
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> pushCost(@RequestBody BudgetProjectVO pushVO) {
        CommonResponse<BudgetProjectVO> response = service.pushCost(pushVO);
        return response;
    }

    @RequestMapping(value = "/convertToPro", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> convertToPro(@RequestBody BudgetProjectVO budgetProjectVO) {
        if (2 != budgetProjectVO.getBudgetType().intValue() && 4 != budgetProjectVO.getBudgetType().intValue()) {
            throw new BusinessException("只有类型为[施工图预算]和[签证]的预算书允许转换成目标成本!");
        }
        // 二次转换
        if (budgetProjectVO.getConvertState() != null && budgetProjectVO.getConvertState().intValue() == 1) {
            LambdaQueryWrapper<BudgetProjectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BudgetProjectDetailEntity::getBudgetId, budgetProjectVO.getId());
            queryWrapper.in(BudgetProjectDetailEntity::getResultState, Arrays.asList(ConvertResultEnum.存在相似清单.getCode(), ConvertResultEnum.无相似清单.getCode()));
            List<BudgetProjectDetailEntity> list = detailService.list(queryWrapper);
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("不存在匹配结果为存在相似清单或无相似清单的数据，无需再次转换！");
            }
            List<BudgetProjectDetailVO> budgetProjectDetailVOS = BeanMapper.mapList(list, BudgetProjectDetailVO.class);
            for (BudgetProjectDetailVO budgetProjectDetailVO : budgetProjectDetailVOS) {
                budgetProjectDetailVO.setResultState(null);
                budgetProjectDetailVO.setBaseResultState(null);
                budgetProjectDetailVO.setSetDetailId(null);
                budgetProjectDetailVO.setMatchTime(null);
            }
            budgetProjectVO.setCheckList(budgetProjectDetailVOS);
        }
        return service.convertToPro(budgetProjectVO);
    }

    @RequestMapping(value = "/pushToPro", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushToPro(Long budgetId) {
        return service.pushToPro(budgetId);
    }

    @RequestMapping(value = "/checkBeforePush", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkBeforePush(Long budgetId) {
        return service.checkBeforePush(budgetId);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> refBudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            }
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("budgetType", new Parameter(QueryParam.IN, "4,5"));
        IPage<BudgetProjectEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        //获取项目预算书列表
        List<BudgetProjectEntity> budgetDataList = page.getRecords();

        //判断列表是否为空
        if (!ObjectUtils.isEmpty(budgetDataList)){

            //项目预算书列表不为空、获取预算书id集合
            List<Long> idList = budgetDataList.stream().map(BudgetProjectEntity::getId).collect(Collectors.toList());

            //根据项目预算书id集合查询清单明细
            List<BudgetProjectDetailEntity> budgetProjectDetailList = detailService.lambdaQuery().in(BudgetProjectDetailEntity::getBudgetId, idList).list();

            //将预算书明细设置到项目预算书中
            budgetDataList.forEach(budgetProjectEntity -> {
                budgetProjectDetailList.forEach(budgetProjectDetailEntity -> {

                    //判断预算书的id与明细中的预算书id是否相等
                    if (Objects.equals(budgetProjectDetailEntity.getBudgetId(),budgetProjectEntity.getId())){
                        //若相等 则将预算书明细设置到预算书中
                        budgetProjectEntity.getCheckList().add(budgetProjectDetailEntity);
                    }
                });
            });

            //将处理的结果设置会分页对象中
            pageData.setRecords(BeanMapper.mapList(budgetDataList, BudgetProjectVO.class));
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 预算书清单参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetInventoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> refBudgetInventoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            }

            if (_con.get("budgetType") != null) {
                //根据前端传的不同预算书类型查询预算书列表
                param.getParams().put("budgetType", new Parameter(QueryParam.IN, _con.get("budgetType")));
            }
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        //查询预算书实体信息列表
        List<BudgetProjectEntity> budgetProjectEntityList = service.queryList(param, false);

        //创建预算书清单分页对象
        IPage<BudgetProjectDetailVO> pageData = new Page<>();

        //判断预算书实体信息列表是否为空
        if (!ObjectUtils.isEmpty(budgetProjectEntityList)){

            //预算书实体信息不为空、分页查询预算书下的所有预算清单
            QueryParam param2 = new QueryParam();
            param2.setPageSize(pageSize);
            param2.setPageIndex(pageNumber);

            param2.getParams().put("budget_id",new Parameter(QueryParam.IN,budgetProjectEntityList.stream().map(BudgetProjectEntity::getId).collect(Collectors.toList())));

            param2.getParams().put("leaf_flag",new Parameter(QueryParam.EQ,1)); //查询所有末级的节点

            //查询预算清单分页结果
            IPage<BudgetProjectDetailEntity> page = detailService.queryPage(param2, false);

            //获取分页结果
            List<BudgetProjectDetailEntity> list = page.getRecords();

            //判断分页结果是否为空
            if (!ObjectUtils.isEmpty(list)){

                //若分页结果不为空、查询其父级
                List<BudgetProjectDetailEntity> parentList = new ArrayList<>();
                parentList = getParent(list, parentList);

                //在原节点中添加所有的父节点
                list.addAll(parentList);

                //设置每个节点中的临时 当前节点id、父节点id
                for (BudgetProjectDetailEntity entity : list) {
                    entity.setTid(entity.getId().toString());
                    entity.setTpid(entity.getParentId() != null && entity.getParentId() > 0 ? entity.getParentId().toString() : "");
                }

                //实现排序
                Collections.sort(list, (o1,o2)->{
                    String[] preArrs = o1.getDetailIndex().split("\\.");
                    String[] sufArrs = o2.getDetailIndex().split("\\.");
                    int len = preArrs.length > sufArrs.length ? preArrs.length : sufArrs.length;
                    for (int i = 0; i < len; i++) {
                        int preNum = 0;
                        int sufNum = 0;

                        if (i < preArrs.length) {
                            preNum = Integer.parseInt(preArrs[i]);
                        }

                        if (i < sufArrs.length) {
                            sufNum = Integer.parseInt(sufArrs[i]);
                        }

                        if (preNum > sufNum) {
                            return 1;
                        } else if (preNum < sufNum) {
                            return -1;
                        }
                    }
                    return 0;
                });

                //将entity转换成 vo对象
                List<BudgetProjectDetailVO> budgetProjectDetailVOS = BeanMapper.mapList(list, BudgetProjectDetailVO.class);

                //生成树
                List<BudgetProjectDetailVO> budgetProjectDetailTree = TreeNodeBUtil.buildTree(budgetProjectDetailVOS);

                //设置分页的当前页、分页大小、分页的总数
                pageData.setCurrent(page.getCurrent());
                pageData.setSize(page.getSize());
                pageData.setPages(page.getPages());
                pageData.setTotal(page.getTotal());

                //设置分页数据对象
                pageData.setRecords(budgetProjectDetailTree);

            }

        }

        //返回分页数据对象
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    private List<BudgetProjectDetailEntity> getParent(List<BudgetProjectDetailEntity> list, List<BudgetProjectDetailEntity> parentList) {

        //获取各节点对应的父节点、收集为父节点id集合
        List<Long> ids = list.stream().filter(s -> s.getParentId() != null).map(BudgetProjectDetailEntity::getParentId).collect(Collectors.toList());

        //判断父节点id集合是否为空
        if (CollectionUtils.isNotEmpty(ids)) {

            //父节点id集合不为空
            QueryWrapper<BudgetProjectDetailEntity> objectQueryWrapper = new QueryWrapper<>();
            objectQueryWrapper.in("id", ids);

            //根据id集合查询父节点集合
            List<BudgetProjectDetailEntity> parentDetailEntities = detailService.list(objectQueryWrapper);

            //判断父节点集合是否为空
            if (CollectionUtils.isNotEmpty(parentDetailEntities)) {

                //递归获取所有节点的父节点集合
                parentList.addAll(parentDetailEntities);
                getParent(parentDetailEntities, parentList);
            }
        }

        //对父节点 根据id去重
        parentList = parentList.stream().collect(Collectors.collectingAndThen(
                Collectors.toCollection(()->new TreeSet<>(Comparator.comparing(BudgetProjectDetailEntity::getId))),ArrayList::new
        ));

        //返回父节点
        return parentList;
    }


}
