package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetTypeEntity;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetTypeService;
import com.ejianc.business.budget.vo.BudgetSetTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 清单定额关系工程类型
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetSetType")
public class BudgetSetTypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IBudgetSetTypeService service;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetSetTypeVO> saveOrUpdate(@RequestBody BudgetSetTypeVO saveOrUpdateVO) {
    	BudgetSetTypeEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetSetTypeEntity.class);
    	service.saveOrUpdate(entity, false);
    	BudgetSetTypeVO vo = BeanMapper.map(entity, BudgetSetTypeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetSetTypeVO> queryDetail(Long id) {
    	BudgetSetTypeEntity entity = service.selectById(id);
    	BudgetSetTypeVO vo = BeanMapper.map(entity, BudgetSetTypeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetSetTypeVO> vos) {
        List<Long> longs = vos.stream().map(BudgetSetTypeVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<BudgetSetDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(BudgetSetDetailEntity::getSetTypeId, longs);
        if (budgetSetDetailService.count(queryWrapper) > 0) {
            throw new BusinessException("所选[工程类型]下存在清单，不允许删除!");
        }
        service.removeByIds(longs, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetTypeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BudgetSetTypeEntity> page = service.queryPage(param,false);
        IPage<BudgetSetTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetTypeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BudgetSetTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetSetType-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refBudgetSetTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetTypeVO>> refBudgetSetTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetSetTypeEntity> page = service.queryPage(param,false);
        IPage<BudgetSetTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetTypeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
