package com.ejianc.business.budget.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author yqls
 * @Description: 预算API接口
 * @date 2021/03/31 17:46
 */
@RestController
@RequestMapping(value = "/api/budget/")
public class BudgetProjectApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetProjectService budgetService;

    /**
     * 根据queryParam查询预算列表
     * @param queryParam
     * @return
     */
    @PostMapping("getBudgetListByQueryParam")
    CommonResponse<JSONObject> getBudgetListByQueryParam(@RequestBody QueryParam queryParam){
        List<BudgetProjectEntity> list = budgetService.queryList(queryParam, false);
        JSONObject back = new JSONObject();
        back.put("list", list);
        return CommonResponse.success(back);
    }

}
