package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目预算清单明细
 *
 * @author generator
 */
@Service("budgetProjectDetailProService")
public class BudgetProjectDetailProServiceImpl extends BaseServiceImpl<BudgetProjectDetailProMapper, BudgetProjectDetailProEntity> implements IBudgetProjectDetailProService {

    @Autowired
    private IMaterialApi materialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBrandApi brandApi;
    @Autowired
    private IGuidePriceDetailService guidePriceDetailService;

    @Autowired
    private IQuotaService quotaService;

    @Autowired
    private IQuotaDetailService quotaDetailService;


    @Override
    public CommonResponse<JSONObject> excelImportForHK(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = HuaKangExcelReader.readExcel(mf, 1, 1);
            if (result != null && result.size() > 0) {
                // 各字段所在列号，因为存在列合并的情况，需要定位到列号
                // 序号
                int detailIndexCellNum = 0;
                // 项目编码
                int codeCellNum = 1;
                // 名称
                int nameCellNum = 2;
                // 特征描述
                int specCellNum = 3;
                // 计量单位
                int unitCellNum = 4;
                // 工程量
                int numCellNum = 5;
                // 单价
                int taxPriceCellNum = 6;
                // 合价
                int taxMnyCellNum = 7;

                // 识别字段下标
                int indexKnownNum = 0;
                Iterator<List<String>> iterator = result.iterator();
                int row = 0;
                while (iterator.hasNext()) {
                    List<String> datas = iterator.next();
                    int _indexKnownNum = indexKnownNum;
                    for (int j = 0; j < datas.size(); j++) {
                        String s = datas.get(j);
                        if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("序号")) {
                            detailIndexCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目编码")) {
                            codeCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目名称")) {
                            nameCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目特征描述")) {
                            specCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("计量单位")) {
                            unitCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("工程量")) {
                            numCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("综合单价")) {
                            taxPriceCellNum = j;
                            indexKnownNum++;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("合价")) {
                            taxMnyCellNum = j;
                            indexKnownNum++;
                        }
                    }
                    row++;
                    if (indexKnownNum > _indexKnownNum) {
                        iterator.remove();
                    }
                    if (indexKnownNum == 8) {
                        break;
                    }
                    if (indexKnownNum < 8 && row > 10) {
                        throw new BusinessException("未识别表头字段信息");
                    }
                }


                int engineeringNameIndex = 0;

                int nameIndex = 0;

                int itemIndex = 0;

                String engineeringtpid = "";

                String tpid = "";


                List<BudgetProjectDetailProVO> detailVoList = new ArrayList<>();


                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    boolean isTitle = false;
                    for (int j = 0; j < datas.size(); j++) {
                        String s = datas.get(j);
                        if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("序号")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目编码")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目名称")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("项目特征描述")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("计量单位")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("工程量")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("综合单价")) {
                            isTitle = true;
                        } else if (s.replaceAll("\\n|\\r|\\r\\n", "").contains("合价")) {
                            isTitle = true;
                        }
                    }
                    // 如果是标投资端直接忽略
                    if (isTitle) {
                        continue;
                    }

                    BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String detailIndex = datas.get(detailIndexCellNum);
                    String name = datas.get(nameCellNum);

                    String code = datas.get(codeCellNum);
                    if (StringUtils.isEmpty(code) || StringUtils.isEmpty(detailIndex)) {
                        if (StringUtils.isNotEmpty(detailIndex)) {
                            // 工程名称
                            if (detailIndex.contains("工程名称")) {
                                String engineeringName = detailIndex.replaceAll("工程名称：", "").trim();
                                engineeringNameIndex++;
                                vo.setDetailIndex(String.valueOf(engineeringNameIndex));
                                vo.setName(engineeringName);
                                engineeringtpid = vo.getDetailIndex();
                                vo.setTid(vo.getDetailIndex());
                                nameIndex = 0;
                                vo.setImportFlag(true);// true=可以导入，false=不可导入
                                vo.setParentWarn(false);
                                vo.setCostType(0);
                                vo.setRowState("add");
                                vo.setArchiveFlag("2");
                                vo.setShadowId(vo.getTid());
                                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                                vo.setKey(key);
                                detailVoList.add(vo);
                                continue;
                            }
                            // 标题
                            if (StringUtils.isEmpty(name)) {
                                continue;
                            }
                        } else {
                            // 序号为空，name不为空则是项目名称
                            if (StringUtils.isNotEmpty(name)) {
                                nameIndex++;
                                vo.setDetailIndex(engineeringNameIndex + "." + nameIndex);
                                vo.setName(name);
                                vo.setTpid(engineeringtpid);
                                vo.setTid(vo.getDetailIndex());
                                tpid = vo.getDetailIndex();
                                itemIndex = 0;
                                vo.setImportFlag(true);// true=可以导入，false=不可导入
                                vo.setParentWarn(false);
                                vo.setCostType(0);
                                vo.setRowState("add");
                                vo.setArchiveFlag("2");
                                vo.setShadowId(vo.getTid());
                                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                                vo.setKey(key);
                                detailVoList.add(vo);
                                continue;
                            }


                        }

                    } else {
                        itemIndex++;
                        String warnType = "";
                        vo.setDetailIndex(engineeringNameIndex + "." + nameIndex + "." + itemIndex);
                        vo.setTid(vo.getDetailIndex());
                        vo.setTpid(tpid);

                        if (StringUtils.isEmpty(code)) {// 清单编码为空
                            vo.setCode(null);
                            warnType = warnType + "编码为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setCode(code);
                        }

                        if (StringUtils.isEmpty(name)) {//清单名称为空
                            vo.setName(null);
                            warnType = warnType + "清单名称为空,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            vo.setName(name.replace(" ", ""));
                        }

                        vo.setCostType(2);
                        vo.setMaterialName(vo.getName());
                  /*  if (StringUtils.isEmpty(datas.get(3))) {//费用类型为空

                    } else {
                        String costType = datas.get(3);
                        if (costType.equals("/")){
                            vo.setCostType(0);
                        }
                        if (costType.equals("人工费")){
                            vo.setCostType(1);
                        }
                        if (costType.equals("材料费")){
                            vo.setCostType(2);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("专业分包费")){
                            vo.setCostType(3);
                        }
                        if (costType.equals("机械费")){
                            vo.setCostType(4);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("间接费")){
                            vo.setCostType(5);
                        }
                    }*/
                        vo.setEntryType("1");
                    /*if (StringUtils.isNotEmpty(datas.get(4))){
                        String entryType = datas.get(4);
                        if (entryType.equals("档案")){
                            if (vo.getCostType()==1 || vo.getCostType()==3 || vo.getCostType()==5){
                                warnType =  warnType+"材料类型为档案时，费用类型必须为材料费或机械费!,";
                                flag = true;
                                parentWarn = true;
                            }
                            vo.setEntryType("1");
                        }
                        if (entryType.equals("手动录入")){
                            vo.setEntryType("0");
                        }
                    }
                    if (vo.getCostType()!=null && vo.getCostType()!=null && (vo.getCostType()==2 || vo.getCostType()==4) &&  StringUtils.isEmpty(datas.get(5))) {
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)){
                            vo.setCategoryName(null);
                            warnType =  warnType+"材料/设备类型为空,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(5))){
                            String categoryName =datas.get(5).replace(" ", "");
                            vo.setCategoryName(categoryName);
                        }
                        Integer costType = vo.getCostType();
                        if (costType!=null){
                            if (costType==1 || costType==3 || costType==5){
                                vo.setCategoryName(null);
                            }
                        }
                    }
                    if (vo.getCostType()!=null && (vo.getCostType()==2 || vo.getCostType()==4) && StringUtils.isEmpty(datas.get(6))) {//特征描述/规格型号
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)){
                            vo.setSpec(null);
                            warnType =  warnType+"特征描述/规格型号,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(6))){
                            String spec =datas.get(6).replace(" ", "");
                            spec=handleBlankString(spec,true);
                            if(StringUtils.isNotEmpty(spec) && spec.length() > 2000){
                                flag = true;
                                warnType = warnType + "特征描述/规格型号超过2000字,";
                            }
                            vo.setSpec(spec);
                        }
                    }*/
                        String spec = datas.get(specCellNum);

                        if ("1".equals(vo.getEntryType()) && StringUtils.isEmpty(spec)) {
                          /*  vo.setSpec(null);
                            warnType = warnType + "特征描述/规格型号,";
                            flag = true;
                            parentWarn = true;*/
                        } else {
                            spec = handleBlankString(spec.replace(" ", ""), true);
                            if (StringUtils.isNotEmpty(spec) && spec.length() > 2000) {
                                flag = true;
                                warnType = warnType + "特征描述/规格型号超过2000字,";
                            }
                            vo.setSpec(spec);
                        }

                        String unit = datas.get(unitCellNum);
                        if (StringUtils.isNotEmpty(unit)) {
                            if (StringUtils.isNotEmpty(datas.get(7))) {
                                unit = handleBlankString(unit.replace(" ", ""), true);
                                vo.setUnit(unit);
                            }
                        }
                        //子级才校验数量单价
                        if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                            String num = datas.get(numCellNum);
                            if (StringUtils.isEmpty(num)) {
                                vo.setNum(null);
                                warnType = warnType + "工程量为空,";
                                flag = true;
                            } else {
                                try {
                                    vo.setNum(new BigDecimal(num));
                                } catch (Exception e) {
                                    vo.setNum(null);
                                    warnType = warnType + "工程量只能为数字或小数,";
                                    flag = true;
                                }
                            }
                            String taxPrice = datas.get(taxPriceCellNum);
                            if (StringUtils.isNotEmpty(taxPrice)) {
                                try {
                                    vo.setTaxPrice(new BigDecimal(taxPrice));
                                } catch (Exception e) {
                                    vo.setTaxPrice(null);
                                    warnType = warnType + "综合单价只能为数字或小数,";
                                    flag = true;
                                }
                            }
                    /*    if (StringUtils.isNotEmpty(datas.get(10))) {
                            try {
                                vo.setPrice(new BigDecimal(datas.get(10)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType+"综合单价(无税)只能为数字或小数,";
                                flag = true;
                            }
                        }
                  */
                            if (null == vo.getTaxPrice()) {
                                if (null == vo.getPrice()) {
                                } else {
                                    if (null == vo.getRate()) {
                                        vo.setTaxPrice(vo.getPrice());
                                    } else {
                                        BigDecimal add = ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1));
                                        vo.setTaxPrice(vo.getPrice().multiply(add));
                                    }
                                }
                            } else {
                                if (null == vo.getPrice()) {
                                    if (null == vo.getRate()) {
                                        vo.setPrice(vo.getTaxPrice());
                                    } else {
                                        BigDecimal price = ComputeUtil.safeDiv(vo.getTaxPrice(), ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1)));
                                        vo.setPrice(price);
                                    }
                                }
                            }
                        }
                        if (null != vo.getNum() && null != vo.getTaxPrice()) {
                            BigDecimal taxMny = ComputeUtil.safeMultiply(vo.getNum(), vo.getTaxPrice());
                            BigDecimal mny = null;
                            vo.setTaxMny(taxMny);
                            if (vo.getRate() != null) {
                                mny = ComputeUtil.safeMultiply(vo.getNum(), vo.getPrice());
                                vo.setMny(mny);
                            } else {
                                vo.setTaxMny(taxMny);
                                vo.setMny(taxMny);
                            }
                            if (vo.getCostType() != null) {
                                if (vo.getCostType() == 1) {
                                    vo.setLaborTaxMnyCost(vo.getTaxMny());
                                    vo.setLaborMnyCost(vo.getMny());
                                }
                                if (vo.getCostType() == 2) {
                                    vo.setMaterialMnyCost(vo.getMny());
                                    vo.setMaterialTaxMnyCost(vo.getTaxMny());
                                }
                                if (vo.getCostType() == 3) {
                                    vo.setMajorTaxMnyCost(vo.getTaxMny());
                                    vo.setMajorMnyCost(vo.getMny());
                                }
                                if (vo.getCostType() == 4) {
                                    vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                                    vo.setMechanicalMnyCost(vo.getMny());
                                }
                                if (vo.getCostType() == 5) {
                                    vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                                    vo.setIndirectionMnyCost(vo.getMny());
                                }
                            }
                        }

                        vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                        vo.setParentWarn(parentWarn);
                        if (flag) {
                            warnType = warnType.substring(0, warnType.length() - 1);
                        }
                        vo.setWarnType(warnType);
                        vo.setRowState("add");
                        vo.setArchiveFlag("2");
                        vo.setShadowId(vo.getTid());
                        String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                        vo.setKey(key);
                        detailVoList.add(vo);

                    }


                }

               /* for(BudgetProjectDetailProVO tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }*/


                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag2(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> oldErrList = allList.get(1);

                List<Map<String, Object>> successListMap = allList.get(0);
                /*MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, Boolean> materialHashMap = new HashMap<>();
                HashMap<String, Boolean> equipmentCategoryMap = new HashMap<>();

                materialFuzzyMatchVO = checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);

                logger.info("物资设备分类是否存在:" + JSONObject.toJSONString(materialFuzzyMatchVO));
                //物资
                Map<String, Boolean> materialCategoryMap = null;
                //设备
                Map<String, Boolean> equipmentCategoryProMap = null;
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse = materialApi.checkArchive(materialFuzzyMatchVO);
                if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse.getData();
                    materialCategoryMap = data.getMaterialCategoryMap();
                    equipmentCategoryProMap = data.getEquipmentCategoryMap();
                    //分类不存在放在newAllList中下标为一
                    List<Map<String, Object>> newList = ExcelImportUtil.importCheckCategoryName(successListMap, materialCategoryMap, equipmentCategoryProMap);
                    List<Map<String, Object>> newfalseList = new ArrayList<>();
                    List<List<Map<String, Object>>> newAllList = ExcelImportUtil.separate(newList, newfalseList);
                    successListMap = newAllList.get(0);
                    oldErrList.addAll(newAllList.get(1));
                }

                //模糊查询
                MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<>();
                materialNumberFuzzyMatchVO = queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                logger.info("物资设备模糊数量:" + JSONObject.toJSONString(materialNumberFuzzyMatchVO));
                //模糊数量
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse1 = materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
                Map<String, MaterialPlusVO> materialPlusMapVO = null;
                if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse1.getData();
                    materialPlusMapVO = data.getFuzzyMatchMap();
                    //设置模糊匹配
                    successListMap = setFuzzyMatch(successListMap, materialPlusMapVO);
                } else {
                    logger.info("物资设备模查询:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
                }*/

                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(oldErrList);
                resp.put("successList", successListMap);
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {

                LambdaQueryWrapper<QuotaEntity> quotaEntityLambdaQueryWrapper = Wrappers.<QuotaEntity>lambdaQuery();
                quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getEnableState, 1);
                quotaEntityLambdaQueryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
                QuotaEntity quotaEntity = quotaService.getOne(quotaEntityLambdaQueryWrapper, false);
                Map<String, Long> quotaDetailMap = new HashMap<>();
                if (null != quotaEntity) {
                    LambdaQueryWrapper<QuotaDetailEntity> queryWrapper = Wrappers.<QuotaDetailEntity>lambdaQuery();
                    queryWrapper.eq(QuotaDetailEntity::getQuotaId, quotaEntity.getId());
                    List<QuotaDetailEntity> list = quotaDetailService.list(queryWrapper);
                    quotaDetailMap = list.stream().collect(Collectors.toMap(QuotaDetailEntity::getDetailCode, QuotaDetailEntity::getId,(key1 , key2)-> key2 ));
                }

                String taxRatePar = request.getParameter("taxRate");
                BigDecimal taxRate = ComputeUtil.toBigDecimal(taxRatePar);
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailProVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        //return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {//费用类型为空

                    } else {
                        String costType = datas.get(1);
                        if (costType.equals("/")) {
                            vo.setCostType(0);
                        }
                        if (costType.equals("人工费")) {
                            vo.setCostType(1);
                            vo.setRate(taxRate);
                        }
                        if (costType.equals("材料费")) {
                            vo.setCostType(2);
                            vo.setMaterialName(vo.getName());
                            vo.setRate(taxRate);
                        }
                        if (costType.equals("间接费")) {
                            vo.setCostType(5);
                            vo.setRate(taxRate);
                        }
                        if (costType.equals("其他费")) {
                            vo.setCostType(4);
                            vo.setRate(taxRate);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(2))) {
                        String entryType = datas.get(2);
                        if (entryType.equals("档案")) {
                            if (vo.getCostType() != 2) {
                                warnType = warnType + "材料类型为档案时，费用类型必须为材料费!,";
                                flag = true;
                                parentWarn = true;
                            }
                            vo.setEntryType("1");
                        }
                        if (entryType.equals("手动录入")) {
                            vo.setEntryType("0");
                        }
                    }
                    if (vo.getCostType() != null && vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty(datas.get(3))) {
                        String entryType = datas.get(2);
                        if ("档案".equals(entryType)) {
                            vo.setCategoryName(null);
                            warnType = warnType + "材料类型为空,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(3))) {
                            String categoryName = datas.get(3).replace(" ", "");
                            vo.setCategoryName(categoryName);
                        }
                        Integer costType = vo.getCostType();
                        if (costType != null) {
                            if (costType == 1 || costType == 4 || costType == 5) {
                                vo.setCategoryName(null);
                            }
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(4))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(4).trim());
                        Integer costType = vo.getCostType();
                        if (costType != null && costType == 1 && StringUtils.isNotEmpty(vo.getCode())) {
                            Long sourceId = quotaDetailMap.get(vo.getCode());
                            vo.setSourceId(sourceId);
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        String name = datas.get(5).trim();
                        vo.setName(name);
                    }

                    if (vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty(datas.get(6))) {//特征描述/规格型号
                        String entryType = datas.get(2);
                        if ("档案".equals(entryType)) {
                            vo.setSpec(null);
                            warnType = warnType + "特征/规格型号,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(6))) {
                            String spec = datas.get(6).trim();
                            spec = handleBlankString(spec, true);
                            if (StringUtils.isNotEmpty(spec) && spec.length() > 2000) {
                                flag = true;
                                warnType = warnType + "特征/规格型号超过2000字,";
                            }
                            vo.setSpec(spec);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(7))) {
                        if (StringUtils.isNotEmpty(datas.get(7))) {
                            String unit = datas.get(7).trim();
                            unit = handleBlankString(unit, true);
                            vo.setUnit(unit);
                        }
                    }
                    if (vo.getCostType() != null && vo.getCostType().equals(0)) {
                        if (StringUtils.isNotEmpty(datas.get(8))) {
                            try {
                                vo.setNum(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }
                    }


                    //子级才校验数量单价
                    if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                        if (StringUtils.isEmpty(datas.get(8))) {
                            vo.setNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setNum(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(9)) && vo.getCostType() != null && vo.getCostType() == 2) {
                            try {
                                vo.setLossRate(new BigDecimal(datas.get(9)));
                            } catch (Exception e) {
                                vo.setLossRate(null);
                                warnType = warnType + "材料损耗只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(10)) && vo.getCostType() != null && vo.getCostType() == 2) {
                            String brandName = datas.get(10).trim();
                            CommonResponse<BrandVO> brandVOCommonResponse = brandApi.queryBrandByName(brandName);
                            if (brandVOCommonResponse.isSuccess() && brandVOCommonResponse.getData() != null) {
                                vo.setBrandId(brandVOCommonResponse.getData().getId());
                                vo.setBrandName(brandVOCommonResponse.getData().getBrandName());
                            } else {
                                warnType = warnType + "品牌不存在,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(11)) && vo.getCostType() != null && vo.getCostType() == 1) {
                            try {
                                vo.setCompeteFactor(new BigDecimal(datas.get(11)));
                            } catch (Exception e) {
                                vo.setCompeteFactor(null);
                                warnType = warnType + "竞聘系数只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isEmpty(datas.get(12))) {
//                            vo.setTaxPrice(null);
//                            warnType = warnType+"单价为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setPrice(new BigDecimal(datas.get(12)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType + "单价(无税)只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (null == vo.getTaxPrice()) {
                            if (null == vo.getPrice()) {
                            } else {
                                if (null == vo.getRate()) {
                                    vo.setTaxPrice(vo.getPrice());
                                } else {
                                    BigDecimal add = ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1));
                                    vo.setTaxPrice(vo.getPrice().multiply(add));
                                }
                            }
                        } else {
                            if (null == vo.getPrice()) {
                                if (null == vo.getRate()) {
                                    vo.setPrice(vo.getTaxPrice());
                                } else {
                                    BigDecimal price = ComputeUtil.safeDiv(vo.getTaxPrice(), ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1)));
                                    vo.setPrice(price);
                                }
                            }
                        }
                    }
                    if (null != vo.getNum() && null != vo.getTaxPrice()) {
                        BigDecimal taxMny = ComputeUtil.safeMultiply(vo.getNum(), vo.getTaxPrice());
                        BigDecimal mny = null;
                        vo.setTaxMny(taxMny);
                        if (vo.getRate() != null) {
                            mny = ComputeUtil.safeMultiply(vo.getNum(), vo.getPrice());
                            vo.setMny(mny);
                        } else {
                            vo.setTaxMny(taxMny);
                            vo.setMny(taxMny);
                        }
                        if (vo.getCostType() != null) {
                            if (vo.getCostType() == 1) {
                                vo.setLaborTaxMnyCost(vo.getTaxMny());
                                vo.setLaborMnyCost(vo.getMny());
                            }
                            if (vo.getCostType() == 2) {
                                vo.setMaterialMnyCost(vo.getMny());
                                vo.setMaterialTaxMnyCost(vo.getTaxMny());
                            }
                            if (vo.getCostType() == 5) {
                                vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                                vo.setIndirectionMnyCost(vo.getMny());
                            }
                            if (vo.getCostType() == 4) {
                                vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                                vo.setMechanicalMnyCost(vo.getMny());
                            }
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setArchiveFlag("2");
                    vo.setShadowId(vo.getTid());
                    String key = (vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit()).replace(" ", "");
                    vo.setKey(key);
                    detailVoList.add(vo);
                }

                for (BudgetProjectDetailProVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag2(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> oldErrList = allList.get(1);

                List<Map<String, Object>> successListMap = allList.get(0);
                MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, Boolean> materialHashMap = new HashMap<>();
                HashMap<String, Boolean> equipmentCategoryMap = new HashMap<>();

                materialFuzzyMatchVO = checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);

                logger.info("物资分类是否存在:" + JSONObject.toJSONString(materialFuzzyMatchVO));
                //物资
                Map<String, Boolean> materialCategoryMap = null;
                //设备
                Map<String, Boolean> equipmentCategoryProMap = null;
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse = materialApi.checkArchive(materialFuzzyMatchVO);
                if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse.getData();
                    materialCategoryMap = data.getMaterialCategoryMap();
                    equipmentCategoryProMap = data.getEquipmentCategoryMap();
                    //分类不存在放在newAllList中下标为一
                    List<Map<String, Object>> newList = ExcelImportUtil.importCheckCategoryName(successListMap, materialCategoryMap, equipmentCategoryProMap);
                    List<Map<String, Object>> newfalseList = new ArrayList<>();
                    List<List<Map<String, Object>>> newAllList = ExcelImportUtil.separate(newList, newfalseList);
                    successListMap = newAllList.get(0);
                    oldErrList.addAll(newAllList.get(1));
                }
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(oldErrList);
                //模糊查询
                MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<>();
                materialNumberFuzzyMatchVO = queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                logger.info("物资设备模糊数量:" + JSONObject.toJSONString(materialNumberFuzzyMatchVO));
                //模糊数量
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse1 = materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
                Map<String, MaterialPlusVO> materialPlusMapVO = null;
                if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse1.getData();
                    materialPlusMapVO = data.getFuzzyMatchMap();
                    Map<String, BigDecimal> guidePriceMap = guidePriceDetailService.queryGuidePriceDetailData();
                    //设置模糊匹配
                    successListMap = setFuzzyMatch(successListMap, materialPlusMapVO, guidePriceMap);
                } else {
                    logger.info("物资设备模查询:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
                }

                resp.put("successList", successListMap);
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    public MaterialFuzzyMatchVO checkCategoryName(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialFuzzyMatchVO, HashMap<String, Boolean> materialHashMap, HashMap<String, Boolean> equipmentCategoryMap) {
        //校验分类
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                if (stringObjectMap.get("children") != null) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) stringObjectMap.get("children");
                    checkCategoryName(list, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
                } else {
                    Integer costType = stringObjectMap.get("costType") != null ? (Integer) stringObjectMap.get("costType") : null;
                    String categoryName = (String) stringObjectMap.get("categoryName");
                    String entryType = stringObjectMap.get("entryType") != null ? (String) stringObjectMap.get("entryType") : null;
                    if (costType != null && costType == 2 && entryType != null && entryType.equals("1")) {
                        materialHashMap.put(categoryName, false);
                    }
                }
            }
            //分类是否存在
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
        }
        return materialFuzzyMatchVO;
    }


    public MaterialFuzzyMatchVO queryNumberFuzzy(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialNumberFuzzyMatchVO, HashMap<String, MaterialPlusVO> fuzzyMatchMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                if (stringObjectMap.get("children") != null) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) stringObjectMap.get("children");
                    queryNumberFuzzy(list, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                } else {
                    Integer costType = stringObjectMap.get("costType") != null ? (Integer) stringObjectMap.get("costType") : null;
                    String categoryName = (String) stringObjectMap.get("categoryName");
                    String entryType = stringObjectMap.get("entryType") != null ? (String) stringObjectMap.get("entryType") : null;
                    if (costType != null && costType == 2 && entryType != null && entryType.equals("1")) {
                        //查询模糊数量
                        materialNumberFuzzyMatchVO.setType(1);
                        MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                        materialPlusVO.setType(1);
                        materialPlusVO.setCategoryName(categoryName);
                        String spec = (String) stringObjectMap.get("spec");
                        materialPlusVO.setSpec(spec);
                       /* String code = (String) stringObjectMap.get("code");
                        materialPlusVO.setCode(code);*/
                        String name = (String) stringObjectMap.get("name");
                        materialPlusVO.setName(name);
                        String unit = (String) stringObjectMap.get("unit");
                        materialPlusVO.setCategoryName(categoryName);
                        materialPlusVO.setUnitName(unit);
                        fuzzyMatchMap.put(stringObjectMap.get("key").toString(), materialPlusVO);
                    }
                }
            }
            //模糊数量
            materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
        }
        return materialNumberFuzzyMatchVO;
    }

    public List<Map<String, Object>> setFuzzyMatch(List<Map<String, Object>> successListMap, Map<String, MaterialPlusVO> materialPlusMapVO, Map<String, BigDecimal> guidePriceMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                if (stringObjectMap.get("children") != null) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) stringObjectMap.get("children");
                    setFuzzyMatch(list, materialPlusMapVO, guidePriceMap);
                } else {
                    Integer costType = stringObjectMap.get("costType") != null ? (Integer) stringObjectMap.get("costType") : null;
                    String key = (String) stringObjectMap.get("key");
                    if (materialPlusMapVO != null) {
                        MaterialPlusVO materialPlusVO = materialPlusMapVO.get(key);
                        if (materialPlusVO != null) {
                            Integer matchStatus = materialPlusVO.getMatchStatus();
                            Integer type = materialPlusVO.getType();
                            if (matchStatus != null && matchStatus == 1) {
                                stringObjectMap.put("categoryId", materialPlusVO.getCategoryId());
                                stringObjectMap.put("categoryName", materialPlusVO.getCategoryName());
                                stringObjectMap.put("materialId", materialPlusVO.getId());
                                Object brandId = stringObjectMap.get("brandId");
                                String mkey = materialPlusVO.getId().toString() + (null == brandId ? null : brandId.toString());
                                stringObjectMap.put("guidePrice", guidePriceMap.get(mkey));
                                stringObjectMap.put("materialName", materialPlusVO.getName());
                                stringObjectMap.put("spec", materialPlusVO.getSpec());
                                stringObjectMap.put("unit", materialPlusVO.getUnitName());
                            }
                            Integer matchNumber = materialPlusVO.getMatchNumber();
                            String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                            stringObjectMap.put("matchStatus", matchStatus);
                            stringObjectMap.put("matchNumber", matchNumber);
                            stringObjectMap.put("matchStatusDescription", matchStatusDescription);
                        }
                    }
                }
            }
        }
        return successListMap;
    }

    private static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        if (flag) {
            // 只去除首尾空格
            return str.trim();
        } else {
            // 去除空格和空白字符
            return str.replaceAll("\\s*", "");
        }
    }
}
