package com.ejianc.business.budget.utils;

public class CellWidthUtil {

    /**
     * 根据字符串长度计算单元格宽度
     * @param str 部门名称
     * @return 单元格宽度
     */
    public static int calculateCellWidth(String str) {
        // 基础宽度（每个字符占用的宽度）
        int baseWidth = 3; // 可以根据实际情况调整

        // 最小宽度和最大宽度
        int minWidth = 10; // 最小列宽
        int maxWidth = 30; // 最大列宽

        // 计算动态宽度
        int dynamicWidth = str.length() * baseWidth;

        // 限制宽度在最小值和最大值之间
        return Math.min(Math.max(dynamicWidth, minWidth), maxWidth);
    }

}
