package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.CostDocumentsDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 成本单据
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_documents")
public class CostDocumentsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="cost_date")
    private Date costDate; // 成本日期
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="costDocumentsDetailService",pidName = "documentsId")
    private List<CostDocumentsDetailEntity> costDocumentsDetailList = new ArrayList<>(); // 成本单据明细
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getCostDate() {
        return costDate;
    }

    public void setCostDate(Date costDate) {
        this.costDate = costDate;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<CostDocumentsDetailEntity> getCostDocumentsDetailList() {
        return costDocumentsDetailList;
    }

    public void setCostDocumentsDetailList(List<CostDocumentsDetailEntity> costDocumentsDetailList) {
        this.costDocumentsDetailList = costDocumentsDetailList;
    }
}
