package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.ProjectSituationTeamEntity;
import com.ejianc.business.cost.bean.ProjectSituationQuantityEntity;
import com.ejianc.business.cost.bean.ProjectSituationLaborEntity;
import com.ejianc.business.cost.bean.ProjectSituationMaterialEntity;
import com.ejianc.business.cost.bean.ProjectSituationEquipmentEntity;
import com.ejianc.business.cost.bean.ProjectSituationCostEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 在建项目情况填报
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_project_situation")
public class ProjectSituationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_level")
    private String projectLevel; // 项目等级
    @TableField(value="bid_tax_mny")
    private BigDecimal bidTaxMny; // 中标金额
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bid_date")
    private Date bidDate; // 中标时间
    @TableField(value="head_user")
    private String headUser; // 负责人
    @TableField(value="examine_num")
    private Integer examineNum; // 考察次数
    @TableField(value="entourage_user")
    private String entourageUser; // 随行人员
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bill_date")
    private Date billDate; // 填报日期
    @TableField(value="labor_post_flag")
    private Integer laborPostFlag; // 劳务派驻单
    @TableField(value="equipment_post_flag")
    private Integer equipmentPostFlag; // 机械派驻单
    @TableField(value="labor_sub_contract_flag")
    private Integer laborSubContractFlag; // 劳务分包合同
    @TableField(value="equipment_sub_contract_flag")
    private Integer equipmentSubContractFlag; // 机械分包合同
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="remark")
    private String remark; // 总结及建议
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationTeamService")
    private List<ProjectSituationTeamEntity> projectSituationTeamList = new ArrayList<>(); // 在建项目情况填报-劳务组织
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationQuantityService")
    private List<ProjectSituationQuantityEntity> projectSituationQuantityList = new ArrayList<>(); // 在建项目情况填报-工程量
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationLaborService")
    private List<ProjectSituationLaborEntity> projectSituationLaborList = new ArrayList<>(); // 在建项目情况填报-劳务
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationMaterialService")
    private List<ProjectSituationMaterialEntity> projectSituationMaterialList = new ArrayList<>(); // 在建项目情况填报-材料
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationEquipmentService")
    private List<ProjectSituationEquipmentEntity> projectSituationEquipmentList = new ArrayList<>(); // 在建项目情况填报-机械
    @TableField(exist=false)
    @SubEntity(serviceName="projectSituationCostService")
    private List<ProjectSituationCostEntity> projectSituationCostList = new ArrayList<>(); // 在建项目情况填报-动态成本
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectLevel() {
        return projectLevel;
    }

    public void setProjectLevel(String projectLevel) {
        this.projectLevel = projectLevel;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public String getHeadUser() {
        return headUser;
    }

    public void setHeadUser(String headUser) {
        this.headUser = headUser;
    }
    public Integer getExamineNum() {
        return examineNum;
    }

    public void setExamineNum(Integer examineNum) {
        this.examineNum = examineNum;
    }
    public String getEntourageUser() {
        return entourageUser;
    }

    public void setEntourageUser(String entourageUser) {
        this.entourageUser = entourageUser;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getLaborPostFlag() {
        return laborPostFlag;
    }

    public void setLaborPostFlag(Integer laborPostFlag) {
        this.laborPostFlag = laborPostFlag;
    }
    public Integer getEquipmentPostFlag() {
        return equipmentPostFlag;
    }

    public void setEquipmentPostFlag(Integer equipmentPostFlag) {
        this.equipmentPostFlag = equipmentPostFlag;
    }
    public Integer getLaborSubContractFlag() {
        return laborSubContractFlag;
    }

    public void setLaborSubContractFlag(Integer laborSubContractFlag) {
        this.laborSubContractFlag = laborSubContractFlag;
    }
    public Integer getEquipmentSubContractFlag() {
        return equipmentSubContractFlag;
    }

    public void setEquipmentSubContractFlag(Integer equipmentSubContractFlag) {
        this.equipmentSubContractFlag = equipmentSubContractFlag;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
    public List<ProjectSituationTeamEntity> getProjectSituationTeamList() {
        return projectSituationTeamList;
    }

    public void setProjectSituationTeamList(List<ProjectSituationTeamEntity> projectSituationTeamList) {
        this.projectSituationTeamList = projectSituationTeamList;
    }
    public List<ProjectSituationQuantityEntity> getProjectSituationQuantityList() {
        return projectSituationQuantityList;
    }

    public void setProjectSituationQuantityList(List<ProjectSituationQuantityEntity> projectSituationQuantityList) {
        this.projectSituationQuantityList = projectSituationQuantityList;
    }
    public List<ProjectSituationLaborEntity> getProjectSituationLaborList() {
        return projectSituationLaborList;
    }

    public void setProjectSituationLaborList(List<ProjectSituationLaborEntity> projectSituationLaborList) {
        this.projectSituationLaborList = projectSituationLaborList;
    }
    public List<ProjectSituationMaterialEntity> getProjectSituationMaterialList() {
        return projectSituationMaterialList;
    }

    public void setProjectSituationMaterialList(List<ProjectSituationMaterialEntity> projectSituationMaterialList) {
        this.projectSituationMaterialList = projectSituationMaterialList;
    }
    public List<ProjectSituationEquipmentEntity> getProjectSituationEquipmentList() {
        return projectSituationEquipmentList;
    }

    public void setProjectSituationEquipmentList(List<ProjectSituationEquipmentEntity> projectSituationEquipmentList) {
        this.projectSituationEquipmentList = projectSituationEquipmentList;
    }
    public List<ProjectSituationCostEntity> getProjectSituationCostList() {
        return projectSituationCostList;
    }

    public void setProjectSituationCostList(List<ProjectSituationCostEntity> projectSituationCostList) {
        this.projectSituationCostList = projectSituationCostList;
    }
}
