package com.ejianc.business.cost.controller;

import com.alibaba.druid.sql.visitor.functions.If;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.CostAmountVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.budget.vo.comparator.CostDetailProComparatoeVo;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.CostStatisticDetailVO;
import com.ejianc.business.cost.vo.CostStatisticVO;
import com.ejianc.business.cost.vo.SubjectVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 成本设置科目明细
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("subject")
public class SubjectController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;
    
    @Autowired
    private ISubjectService service;

    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;


    @Autowired
    private ICostDetailService costDetailService;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectVO> saveOrUpdate(@RequestBody SubjectVO saveorUpdateVO) {
    	SubjectEntity entity = BeanMapper.map(saveorUpdateVO, SubjectEntity.class);
    	service.saveOrUpdate(entity, false);
    	SubjectVO vo = BeanMapper.map(entity, SubjectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectVO> queryDetail(Long id) {
    	SubjectEntity entity = service.selectById(id);
    	SubjectVO vo = BeanMapper.map(entity, SubjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectVO> vos) {
        service.removeByIds(vos.stream().map(SubjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<SubjectEntity> page = service.queryPage(param,false);
        IPage<SubjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 设置参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "subjectRef", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("subjectCode");
        queryParam.getFuzzyFields().add("subjectName");

        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<SubjectVO> list = service.geSubjects(wrapper);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(SubjectVO entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("leafFlag", entity.getLeafFlag());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        return result;
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCostStatist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostStatisticVO> queryCostStatist(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        CostStatisticVO costStatisticVO = new CostStatisticVO();
        Long projectId=null;
        String subjectName=null;
        String subjectCode=null;
        Integer costType=null;
        if (param.getParams().containsKey("projectId")){
            projectId = Long.parseLong(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().containsKey("subjectName")){
            subjectName = param.getParams().get("subjectName").getValue().toString();
            param.getParams().remove("subjectName");
        }
        if (param.getParams().containsKey("subjectCode")){
            subjectCode =param.getParams().get("subjectCode").getValue().toString();
            param.getParams().remove("subjectCode");
        }
        if (param.getParams().containsKey("costType")){
            costType =Integer.parseInt(param.getParams().get("costType").getValue().toString());
            param.getParams().remove("costType");
        }
        Map<Long, List<CostAmountVO>> costAmountVOMap=new HashMap<>();
        List<CostStatisticDetailVO> list= service.queryCostStatist(subjectCode,subjectName,projectId,costType);
        List<CostStatisticDetailVO> noRelationList = new ArrayList<>();
        List<CostAmountVO> costAmountVOS = service.queryCostList(projectId);
        if (CollectionUtils.isNotEmpty(costAmountVOS)){
            costAmountVOMap=costAmountVOS.stream().filter(s->s.getSubjectId()!=null).collect(Collectors.groupingBy(CostAmountVO::getSubjectId));
        }
        if (CollectionUtils.isNotEmpty(list)){
            for (CostStatisticDetailVO costStatisticDetailVO : list) {
                    if (costStatisticDetailVO.getParentId()==null && costStatisticDetailVO.getLeafFlag()==false){
                        costStatisticDetailVO.setBudgetTaxMny(null);
                        costStatisticDetailVO.setCostTaxMny(null);
                    }
                    if(costAmountVOMap.containsKey(costStatisticDetailVO.getId())){
                        costStatisticDetailVO.setCostNum(costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s->s.getNum()!=null).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getNum,BigDecimal::add)));
                        BigDecimal laborTaxMnyCost = costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s -> s.getLaborTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getLaborTaxMnyCost, BigDecimal::add));
                        BigDecimal materialTaxMnyCost=costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s->s.getMaterialTaxMnyCost()!=null).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMaterialTaxMnyCost,BigDecimal::add));
                        BigDecimal majorTaxMnyCost= costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s->s.getMajorTaxMnyCost()!=null).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMajorTaxMnyCost,BigDecimal::add));
                        BigDecimal mechanicalTaxMnyCost= costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s->s.getMechanicalTaxMnyCost()!=null).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMechanicalTaxMnyCost,BigDecimal::add));
                        BigDecimal indirectionTaxMnyCost = costAmountVOMap.get(costStatisticDetailVO.getId()).stream().filter(s -> s.getIndirectionTaxMnyCost() != null).collect(Collectors.reducing(BigDecimal.ZERO, CostAmountVO::getIndirectionTaxMnyCost, BigDecimal::add));
                        costStatisticDetailVO.setCostTaxMny(ComputeUtil.safeAdd(laborTaxMnyCost,materialTaxMnyCost,majorTaxMnyCost,mechanicalTaxMnyCost,indirectionTaxMnyCost));
                    }
                if (costStatisticDetailVO.getCostTaxMny()!=null){
                    costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticDetailVO.getCostTaxMny(),costStatisticDetailVO.getBudgetTaxMny()),new BigDecimal(100)));
                }
                if (costStatisticDetailVO.getParentId()!=null && costStatisticDetailVO.getLeafFlag()==true){
                    if (costStatisticDetailVO.getBudgetTaxMny()!=null && costStatisticDetailVO.getBudgetNum()!=null){
                        costStatisticDetailVO.setBudgetTaxPrice(ComputeUtil.safeDiv(costStatisticDetailVO.getBudgetTaxMny(),costStatisticDetailVO.getBudgetNum()));
                    }
                }
                if (costStatisticDetailVO.getCostTaxMny()!=null && costStatisticDetailVO.getCostNum()!=null ){
                    costStatisticDetailVO.setCostTaxPrice(ComputeUtil.safeDiv(costStatisticDetailVO.getCostTaxMny(),costStatisticDetailVO.getCostNum()));
                }
                costStatisticDetailVO.setCostTypeName(costStatisticDetailVO.getCostType()!=null ? CostTypeEnum.getEnumByType(costStatisticDetailVO.getCostType()).getName() :null);
            }
        }
        //没有被科目的金额
        Map<Integer, List<CostAmountVO>> collect = costAmountVOS.stream().filter(s -> s.getSubjectId() == null).collect(Collectors.groupingBy(CostAmountVO::getCostType));
        if (CollectionUtils.isNotEmpty(collect)){
            long noRelationParentId = IdWorker.getId();
            CostStatisticDetailVO costStatisticDetailVO = new CostStatisticDetailVO();
            costStatisticDetailVO.setSubjectName("未关联预算成本");
            costStatisticDetailVO.setId(noRelationParentId);
            costStatisticDetailVO.setLeafFlag(false);
            BigDecimal sumNoRelationTaxMny=null;
            for (Integer type : collect.keySet()) {
                CostStatisticDetailVO costStatisticDetailChildrenVO = new CostStatisticDetailVO();
                costStatisticDetailChildrenVO.setCostTypeName(CostTypeEnum.getEnumByType(type).getName());
                costStatisticDetailChildrenVO.setId(IdWorker.getId());
                costStatisticDetailChildrenVO.setCostType(type);
                costStatisticDetailChildrenVO.setParentId(noRelationParentId);
                BigDecimal  costTaxMny=BigDecimal.ZERO;
                if (type==1){
                    costTaxMny=collect.get(type).stream().filter(e->null!=e.getLaborTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getLaborTaxMnyCost,BigDecimal::add));
                }
                if (type==2){
                    costTaxMny=collect.get(type).stream().filter(e->null!=e.getMaterialTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMaterialTaxMnyCost,BigDecimal::add));
                }
                if (type==3){
                    costTaxMny=collect.get(type).stream().filter(e->null!=e.getMajorTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMajorTaxMnyCost,BigDecimal::add));
                }
                if (type==4){
                    costTaxMny=collect.get(type).stream().filter(e->null!=e.getMechanicalTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getMechanicalTaxMnyCost,BigDecimal::add));
                }
                if (type==5){
                    costTaxMny=collect.get(type).stream().filter(e->null!=e.getIndirectionTaxMnyCost()).collect(Collectors.reducing(BigDecimal.ZERO,CostAmountVO::getIndirectionTaxMnyCost,BigDecimal::add));
                }
                costStatisticDetailChildrenVO.setCostTaxMny(costTaxMny);
                if (costStatisticDetailChildrenVO.getCostTaxMny()!=null){
                    costStatisticDetailChildrenVO.setCostBugetRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticDetailChildrenVO.getCostTaxMny(),costStatisticDetailChildrenVO.getBudgetTaxMny()),new BigDecimal(100)));
                }
                costStatisticDetailChildrenVO.setLeafFlag(true);
                sumNoRelationTaxMny=ComputeUtil.safeAdd(sumNoRelationTaxMny,costTaxMny);
                noRelationList.add(costStatisticDetailChildrenVO);
            }
            costStatisticDetailVO.setCostTaxMny(sumNoRelationTaxMny);
            if (costStatisticDetailVO.getCostTaxMny()!=null){
                costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticDetailVO.getCostTaxMny(),costStatisticDetailVO.getBudgetTaxMny()),new BigDecimal(100)));
            }
            noRelationList.add(costStatisticDetailVO);
        }
        //实现排序
        Collections.sort(list,new CostDetailProComparatoeVo());
        list=setParentMnyAndNUm(list);
        costStatisticVO.setDetailList(TreeNodeBUtil.buildTree(list));
        List<CostStatisticDetailVO> detailList = costStatisticVO.getDetailList();
        if (CollectionUtils.isNotEmpty(noRelationList)){
            //获取下标
            Collections.sort(noRelationList, new Comparator<CostStatisticDetailVO>() {
                @Override
                public int compare(CostStatisticDetailVO o1, CostStatisticDetailVO o2) {
                    if (o2.getCostType()==null){
                        return 100;
                    }
                    if (o1.getCostType()==null){
                        return 100;
                    }
                    return o1.getCostType().compareTo(o2.getCostType());
                }
            });
            Collections.sort(detailList, new Comparator<CostStatisticDetailVO>() {
                @Override
                public int compare(CostStatisticDetailVO o1, CostStatisticDetailVO o2) {
                    if (o2.getCostType()==null){
                        return 100;
                    }
                    if (o1.getCostType()==null){
                        return 100;
                    }
                    return o1.getDetailIndex().compareTo(o2.getDetailIndex());
                }
            });
            Integer detailIndex =null;
            if (CollectionUtils.isNotEmpty(detailList) && StringUtils.isNotEmpty( detailList.get(detailList.size() - 1).getDetailIndex())){
                 detailIndex=  detailList.get(detailList.size() - 1).getDetailIndex().contains(".")  ? Integer.parseInt(detailList.get(detailList.size() - 1).getDetailIndex().split("\\.")[0])+1 : Integer.parseInt(detailList.get(detailList.size() - 1).getDetailIndex())+1;
            }else {
                detailIndex=1;
            }
            Integer index=0;
            for (CostStatisticDetailVO costStatisticDetailVO : noRelationList) {
                if (costStatisticDetailVO.getParentId()==null){
                    costStatisticDetailVO.setDetailIndex(detailIndex+"");
                    String code="0"+detailIndex;
                    costStatisticDetailVO.setSubjectCode(code);
                }else {
                    index=index+1;
                    costStatisticDetailVO.setDetailIndex(detailIndex+"."+index);
                    String code="0"+detailIndex+"0"+index;
                    costStatisticDetailVO.setSubjectCode(code);
                }
            }
            Collections.sort(noRelationList,new CostDetailProComparatoeVo());
            List<CostStatisticDetailVO> costStatisticDetailVOS = TreeNodeBUtil.buildTree(noRelationList);
            detailList.addAll(costStatisticDetailVOS);
        }
        CostAmountVO vo= service.queryCostSumMny(projectId);
        CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectDetail(projectId);
        if(commonResponse.isSuccess()){
            costStatisticVO.setProjectName(commonResponse.getData().getName());
            costStatisticVO.setProjectId(projectId);
        }
        if (vo!=null){
            costStatisticVO.setLaborTaxMnyCost(vo.getLaborTaxMnyCost());
            costStatisticVO.setMaterialTaxMnyCost(vo.getMaterialTaxMnyCost());
            costStatisticVO.setMajorTaxMnyCost(vo.getMajorTaxMnyCost());
            costStatisticVO.setMechanicalTaxMnyCost(vo.getMechanicalTaxMnyCost());
            costStatisticVO.setIndirectionTaxMnyCost(vo.getIndirectionTaxMnyCost());
            BigDecimal sum = ComputeUtil.safeAdd(costStatisticVO.getLaborTaxMnyCost(), costStatisticVO.getMaterialTaxMnyCost(), costStatisticVO.getMajorTaxMnyCost(), costStatisticVO.getMechanicalTaxMnyCost(), costStatisticVO.getIndirectionTaxMnyCost());
            costStatisticVO.setLastTaxMnyCost(sum);
        }
        CostStatisticVO budgetVo= service.queryBudgetSumMny(projectId);
        if (budgetVo!=null){
            costStatisticVO.setLaborTaxMny(budgetVo.getLaborTaxMny());
            costStatisticVO.setMaterialTaxMny(budgetVo.getMaterialTaxMny());
            costStatisticVO.setMajorTaxMny(budgetVo.getMajorTaxMny());
            costStatisticVO.setMechanicalTaxMny(budgetVo.getMechanicalTaxMny());
            costStatisticVO.setIndirectionTaxMny(budgetVo.getIndirectionTaxMny());
            BigDecimal sum = ComputeUtil.safeAdd(costStatisticVO.getLaborTaxMny(), costStatisticVO.getMaterialTaxMny(), costStatisticVO.getMajorTaxMny(), costStatisticVO.getMechanicalTaxMny(), costStatisticVO.getIndirectionTaxMny());
            costStatisticVO.setBudgetTaxMny(sum);
        }

        costStatisticVO.setLastTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getLastTaxMnyCost(),costStatisticVO.getBudgetTaxMny()),new BigDecimal(100)));
        costStatisticVO.setLaborTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getLaborTaxMnyCost(),costStatisticVO.getLaborTaxMny()),new BigDecimal(100)));
        costStatisticVO.setMaterialTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getMaterialTaxMnyCost(),costStatisticVO.getMaterialTaxMny()),new BigDecimal(100)));
        costStatisticVO.setMajorTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getMajorTaxMnyCost(),costStatisticVO.getMajorTaxMny()),new BigDecimal(100)));
        costStatisticVO.setMechanicalTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getMechanicalTaxMnyCost(),costStatisticVO.getMechanicalTaxMny()),new BigDecimal(100)));
        costStatisticVO.setIndirectionTaxMnyCostRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticVO.getIndirectionTaxMnyCost(),costStatisticVO.getIndirectionTaxMny()),new BigDecimal(100)));
        costStatisticVO.setDetailList(detailList);
        return CommonResponse.success("查询列表数据成功！",costStatisticVO);
    }

    private List<CostStatisticDetailVO> setParentMnyAndNUm(List<CostStatisticDetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            Map<Long, CostStatisticDetailVO> map = list.stream().collect(Collectors.toMap(k->k.getId(),(k)->k));
            for (CostStatisticDetailVO costStatisticDetailVO : list) {
                if (costStatisticDetailVO.getLeafFlag()==false){
                    List<Long> ids=new ArrayList<>();
                    Long id = costStatisticDetailVO.getId();
                    ids=  getChildrenIds(id,ids);
                    for (Long aLong : ids) {
                        if (map.containsKey(aLong)){
                            costStatisticDetailVO.setCostTaxMny(ComputeUtil.safeAdd(costStatisticDetailVO.getCostTaxMny(),map.get(aLong).getCostTaxMny()));
                            costStatisticDetailVO.setBudgetTaxMny(ComputeUtil.safeAdd(costStatisticDetailVO.getBudgetTaxMny(),map.get(aLong).getBudgetTaxMny()));
                            if (costStatisticDetailVO.getCostTaxMny()!=null){
                                costStatisticDetailVO.setCostBugetRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(costStatisticDetailVO.getCostTaxMny(),costStatisticDetailVO.getBudgetTaxMny()),new BigDecimal(100)));
                            }
                        }
                    }
                }
            }
        }
        return list;
    }

    private List<Long> getChildrenIds(Long id,List<Long> ids) {
        QueryWrapper<SubjectEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("parent_id",id);
        List<SubjectEntity> list = service.list(objectQueryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            for (SubjectEntity entity : list) {
                if (entity.getLeafFlag()==true){
                    ids.add(entity.getId());
                }else {
                    getChildrenIds(entity.getId(),ids);
                }
            }
        }
        return ids;
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<CostStatisticVO> costStatisticVOCommonResponse = queryCostStatist(param);
        List<CostStatisticDetailVO> detailList=new ArrayList<>();
        if (costStatisticVOCommonResponse.isSuccess()){
            CostStatisticVO data = costStatisticVOCommonResponse.getData();
            detailList=this.treeToList(data.getDetailList());
        }
//        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("costStatistic-export.xlsx", beans, response);
    }
    private List<CostStatisticDetailVO> treeToList(List<CostStatisticDetailVO> values) {
        List<CostStatisticDetailVO> result = new ArrayList<>();
        for (CostStatisticDetailVO value : values) {
            result.add(value);
            if (!value.getChildren().isEmpty()) {
                List<CostStatisticDetailVO> child = BeanMapper.mapList(value.getChildren(),CostStatisticDetailVO.class );
                List<CostStatisticDetailVO> entityList = this.treeToList(child);
                result.addAll(entityList);
            }
        }
        if (result.size() > 0) {
            for (CostStatisticDetailVO value : result) {
                value.setChildren(null);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(ComputeUtil.safeDiv(new BigDecimal(5),new BigDecimal(0)));
    }

}
